/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world.structures.piece;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.MHelper;
import org.betterx.betternether.registry.NetherStructurePieces;
import org.betterx.betternether.world.structures.piece.CustomPiece;

public class DestructionPiece
extends CustomPiece {
    private final BlockPos.MutableBlockPos POS = new BlockPos.MutableBlockPos();
    private final BlockPos center;
    private final int radius;
    private final int radSqr;
    private int minY;
    private int maxY;

    public DestructionPiece(BoundingBox bounds, RandomSource random) {
        super(NetherStructurePieces.DESTRUCTION_PIECE, random.m_188502_(), bounds);
        this.radius = random.m_188503_(5) + 1;
        this.radSqr = this.radius * this.radius;
        this.center = new BlockPos(MHelper.randRange(bounds.m_162395_(), bounds.m_162399_(), random), MHelper.randRange(bounds.m_162396_(), bounds.m_162400_(), random), MHelper.randRange(bounds.m_162398_(), bounds.m_162401_(), random));
        this.makeBoundingBox();
    }

    public DestructionPiece(StructurePieceSerializationContext context, CompoundTag tag) {
        super(NetherStructurePieces.DESTRUCTION_PIECE, tag);
        this.center = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("center"));
        this.radius = tag.m_128451_("radius");
        this.radSqr = this.radius * this.radius;
        this.makeBoundingBox();
    }

    protected void m_183620_(StructurePieceSerializationContext structurePieceSerializationContext, CompoundTag tag) {
        tag.m_128365_("center", (Tag)NbtUtils.m_129224_((BlockPos)this.center));
        tag.m_128405_("radius", this.radius);
    }

    public void m_213694_(WorldGenLevel world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, RandomSource random, BoundingBox blockBox, ChunkPos chunkPos, BlockPos blockPos) {
        for (int x = blockBox.m_162401_(); x <= blockBox.m_162398_(); ++x) {
            int px = x - this.center.m_123341_();
            px *= px;
            for (int z = blockBox.m_162396_(); z <= blockBox.m_162400_(); ++z) {
                int pz = z - this.center.m_123343_();
                pz *= pz;
                for (int y = this.minY; y <= this.maxY; ++y) {
                    int py = y - this.center.m_123342_() << 1;
                    if (px + (py *= py) + pz > this.radSqr + random.m_188503_(this.radius)) continue;
                    this.POS.m_122178_(x, y, z);
                    if (world.m_46859_((BlockPos)this.POS)) continue;
                    if (random.m_188499_()) {
                        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)this.POS, f_73382_);
                        continue;
                    }
                    int dist = BlocksHelper.downRay((LevelAccessor)world, (BlockPos)this.POS, this.maxY - 5);
                    if (dist <= 0) continue;
                    BlockState state = world.m_8055_((BlockPos)this.POS);
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)this.POS, f_73382_);
                    this.POS.m_142448_(this.POS.m_123342_() - dist);
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)this.POS, state);
                }
            }
        }
    }

    private void makeBoundingBox() {
        int x1 = this.center.m_123341_() - this.radius;
        int x2 = this.center.m_123341_() + this.radius;
        this.minY = Math.max(22, this.center.m_123342_() - this.radius);
        if (this.minY < 38) {
            this.minY = 38;
        }
        this.maxY = Math.min(96, this.center.m_123342_() + this.radius);
        int z1 = this.center.m_123343_() - this.radius;
        int z2 = this.center.m_123343_() + this.radius;
        this.f_73383_ = new BoundingBox(x1, this.minY, z1, x2, this.maxY, z2);
    }
}

