/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world.structures.piece;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.registry.NetherStructurePieces;
import org.betterx.betternether.world.structures.city.BuildingStructureProcessor;
import org.betterx.betternether.world.structures.city.StructureCityBuilding;
import org.betterx.betternether.world.structures.city.palette.CityPalette;
import org.betterx.betternether.world.structures.city.palette.Palettes;
import org.betterx.betternether.world.structures.piece.CustomPiece;

public class CityPiece
extends CustomPiece {
    private final BlockPos.MutableBlockPos POS = new BlockPos.MutableBlockPos();
    private final StructureProcessor paletteProcessor;
    private final StructureCityBuilding building;
    private final CityPalette palette;
    private final BlockPos pos;

    public CityPiece(StructureCityBuilding building, BlockPos pos, int id, CityPalette palette) {
        super(NetherStructurePieces.NETHER_CITY_PIECE, id, building.getBoundingBox(pos));
        this.building = building;
        this.pos = pos.m_7949_();
        this.f_73383_ = building.getBoundingBox(pos);
        this.palette = palette;
        this.paletteProcessor = new BuildingStructureProcessor(palette);
    }

    public CityPiece(StructurePieceSerializationContext context, CompoundTag tag) {
        super(NetherStructurePieces.NETHER_CITY_PIECE, tag);
        this.building = new StructureCityBuilding(tag.m_128461_("building"), tag.m_128451_("offset")).getRotated(Rotation.values()[tag.m_128451_("rotation")]);
        this.building.setMirror(Mirror.values()[tag.m_128451_("mirror")]);
        this.pos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("pos"));
        this.f_73383_ = this.building.getBoundingBox(this.pos);
        this.palette = Palettes.getPalette(tag.m_128461_("palette"));
        this.paletteProcessor = new BuildingStructureProcessor(this.palette);
    }

    protected void m_183620_(StructurePieceSerializationContext structurePieceSerializationContext, CompoundTag tag) {
        tag.m_128359_("building", this.building.getName());
        tag.m_128405_("rotation", this.building.getRotation().ordinal());
        tag.m_128405_("mirror", this.building.getMirror().ordinal());
        tag.m_128405_("offset", this.building.getYOffset());
        tag.m_128365_("pos", (Tag)NbtUtils.m_129224_((BlockPos)this.pos));
        tag.m_128359_("palette", this.palette.getName());
    }

    public void m_213694_(WorldGenLevel world, StructureManager arg, ChunkGenerator chunkGenerator, RandomSource random, BoundingBox blockBox, ChunkPos chunkPos, BlockPos blockPos) {
        if (!this.f_73383_.m_71049_(blockBox)) {
            return;
        }
        BoundingBox clamped = new BoundingBox(this.f_73383_.m_162395_(), this.f_73383_.m_162396_(), this.f_73383_.m_162398_(), this.f_73383_.m_162399_(), this.f_73383_.m_162400_(), this.f_73383_.m_162401_());
        int cminZ = Math.max(clamped.m_162398_(), blockBox.m_162398_());
        int cmaxZ = Math.min(clamped.m_162401_(), blockBox.m_162401_());
        int cminX = Math.max(clamped.m_162395_(), blockBox.m_162395_());
        int cmaxX = Math.min(clamped.m_162399_(), blockBox.m_162399_());
        int cminY = Math.max(clamped.m_162396_(), blockBox.m_162396_());
        int cmaxY = Math.min(clamped.m_162400_(), blockBox.m_162400_());
        clamped = new BoundingBox(cminX, cminY, cminZ, cmaxX, cmaxY, cmaxZ);
        this.building.placeInChunk((ServerLevelAccessor)world, this.pos, clamped, this.paletteProcessor);
        ChunkAccess chunk = world.m_6325_(chunkPos.f_45578_, chunkPos.f_45579_);
        for (int x = clamped.m_162395_(); x <= clamped.m_162399_(); ++x) {
            for (int z = clamped.m_162398_(); z <= clamped.m_162401_(); ++z) {
                int y;
                this.POS.m_122178_(x, clamped.m_162396_(), z);
                BlockState state = world.m_8055_((BlockPos)this.POS);
                if (!state.m_60795_() && state.m_60838_((BlockGetter)world, (BlockPos)this.POS)) {
                    for (y = clamped.m_162396_() - 1; y > 4; --y) {
                        this.POS.m_142448_(y);
                        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)this.POS, state);
                        if (BlocksHelper.isNetherGroundMagma(world.m_8055_(this.POS.m_7495_()))) break;
                    }
                }
                this.POS.m_122178_(x - clamped.m_162395_(), clamped.m_162396_(), z - clamped.m_162398_());
                for (y = clamped.m_162396_(); y <= clamped.m_162400_(); ++y) {
                    this.POS.m_142448_(y);
                    chunk.m_8113_((BlockPos)this.POS);
                }
            }
        }
    }
}

