/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world.structures.city;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StructureBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.betterx.betternether.blocks.BlockBNPot;
import org.betterx.betternether.blocks.BlockPottedPlant;
import org.betterx.betternether.blocks.BlockSmallLantern;
import org.betterx.betternether.world.structures.city.palette.CityPalette;

public class BuildingStructureProcessor
extends StructureProcessor {
    protected final CityPalette palette;

    public BuildingStructureProcessor(CityPalette palette) {
        this.palette = palette;
    }

    private StructureTemplate.StructureBlockInfo setState(BlockState state, StructureTemplate.StructureBlockInfo info) {
        return new StructureTemplate.StructureBlockInfo(info.f_74675_(), state, info.f_74677_());
    }

    public StructureTemplate.StructureBlockInfo m_7382_(LevelReader worldView, BlockPos pos, BlockPos blockPos, StructureTemplate.StructureBlockInfo structureBlockInfo, StructureTemplate.StructureBlockInfo structureBlockInfo2, StructurePlaceSettings structurePlacementData) {
        BlockState state = structureBlockInfo.f_74676_();
        if (state.m_60795_()) {
            return structureBlockInfo2;
        }
        Block block = state.m_60734_();
        String name = BuiltInRegistries.f_256975_.m_7981_((Object)block).m_135815_();
        if (name.startsWith("roof_tile")) {
            if (block instanceof StairBlock) {
                return this.setState(this.palette.getRoofStair(state), structureBlockInfo2);
            }
            if (block instanceof SlabBlock) {
                return this.setState(this.palette.getRoofSlab(state), structureBlockInfo2);
            }
            return this.setState(this.palette.getRoofBlock(state), structureBlockInfo2);
        }
        if (name.contains("nether") && name.contains("brick")) {
            if (block instanceof StairBlock) {
                return this.setState(this.palette.getFoundationStair(state), structureBlockInfo2);
            }
            if (block instanceof SlabBlock) {
                return this.setState(this.palette.getFoundationSlab(state), structureBlockInfo2);
            }
            if (block instanceof WallBlock) {
                return this.setState(this.palette.getFoundationWall(state), structureBlockInfo2);
            }
            return this.setState(this.palette.getFoundationBlock(state), structureBlockInfo2);
        }
        if (name.contains("plank") || name.contains("reed") || state.m_204336_(BlockTags.f_13090_)) {
            if (block instanceof StairBlock) {
                return this.setState(this.palette.getPlanksStair(state), structureBlockInfo2);
            }
            if (block instanceof SlabBlock) {
                return this.setState(this.palette.getPlanksSlab(state), structureBlockInfo2);
            }
            return this.setState(this.palette.getPlanksBlock(state), structureBlockInfo2);
        }
        if (name.contains("glass") || name.contains("frame")) {
            if (block instanceof IronBarsBlock) {
                return this.setState(this.palette.getGlassPane(state), structureBlockInfo2);
            }
            return this.setState(this.palette.getGlassBlock(state), structureBlockInfo2);
        }
        if (block instanceof RotatedPillarBlock) {
            if (name.contains("log")) {
                return this.setState(this.palette.getLog(state), structureBlockInfo2);
            }
            return this.setState(this.palette.getBark(state), structureBlockInfo2);
        }
        if (block instanceof StairBlock) {
            return this.setState(this.palette.getStoneStair(state), structureBlockInfo2);
        }
        if (block instanceof SlabBlock) {
            return this.setState(this.palette.getStoneSlab(state), structureBlockInfo2);
        }
        if (block instanceof WallBlock) {
            return this.setState(this.palette.getWall(state), structureBlockInfo2);
        }
        if (block instanceof FenceBlock) {
            return this.setState(this.palette.getFence(state), structureBlockInfo2);
        }
        if (block instanceof FenceGateBlock) {
            return this.setState(this.palette.getGate(state), structureBlockInfo2);
        }
        if (block instanceof DoorBlock) {
            return this.setState(this.palette.getDoor(state), structureBlockInfo2);
        }
        if (block instanceof TrapDoorBlock) {
            return this.setState(this.palette.getTrapdoor(state), structureBlockInfo2);
        }
        if (block instanceof PressurePlateBlock) {
            if (block.m_49962_(state) == SoundType.f_56736_) {
                return this.setState(this.palette.getWoodenPlate(state), structureBlockInfo2);
            }
            return this.setState(this.palette.getStonePlate(state), structureBlockInfo2);
        }
        if (block instanceof BlockSmallLantern) {
            if (state.m_61143_((Property)BlockSmallLantern.FACING) == Direction.UP) {
                return this.setState(this.palette.getCeilingLight(state), structureBlockInfo2);
            }
            if (state.m_61143_((Property)BlockSmallLantern.FACING) != Direction.DOWN) {
                return this.setState(this.palette.getWallLight(state), structureBlockInfo2);
            }
            return this.setState(this.palette.getFloorLight(state), structureBlockInfo2);
        }
        if (block instanceof BlockBNPot) {
            return this.setState(this.palette.getPot(state), structureBlockInfo2);
        }
        if (block instanceof BlockPottedPlant) {
            return this.setState(this.palette.getPlant(state), structureBlockInfo2);
        }
        if (block instanceof StructureBlock) {
            return this.setState(Blocks.f_50016_.m_49966_(), structureBlockInfo2);
        }
        if (!name.contains("nether") && !name.contains("mycelium") && state.m_60838_((BlockGetter)worldView, structureBlockInfo.f_74675_()) && state.m_60815_() && !(state.m_60734_() instanceof BaseEntityBlock)) {
            if (state.m_60791_() > 0) {
                return this.setState(this.palette.getGlowingBlock(state), structureBlockInfo2);
            }
            return this.setState(this.palette.getStoneBlock(state), structureBlockInfo2);
        }
        return structureBlockInfo2;
    }

    protected StructureProcessorType<?> m_6953_() {
        return StructureProcessorType.f_74461_;
    }
}

