/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world.features;

import java.util.Iterator;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.betterx.bclib.api.v3.levelgen.features.UserGrowableFeature;
import org.betterx.bclib.blocks.BlockProperties;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.MHelper;
import org.betterx.betternether.blocks.BlockPlantWall;
import org.betterx.betternether.blocks.RubeusLog;
import org.betterx.betternether.registry.NetherBlocks;
import org.betterx.betternether.world.features.NetherThreadDataStorage;
import org.betterx.betternether.world.features.NonOverlappingFeature;
import org.betterx.betternether.world.features.configs.NaturalTreeConfiguration;
import org.betterx.betternether.world.structures.StructureGeneratorThreadContext;

public class RubeusTreeFeature
extends NonOverlappingFeature<NaturalTreeConfiguration>
implements UserGrowableFeature<NaturalTreeConfiguration> {
    private static final float[] CURVE_X = new float[]{9.0f, 7.0f, 1.5f, 0.5f, 3.0f, 7.0f};
    private static final float[] CURVE_Y = new float[]{20.0f, 17.0f, 12.0f, 4.0f, 0.0f, -2.0f};
    private static final int MIDDLE_Y = 10;

    public RubeusTreeFeature() {
        super(NaturalTreeConfiguration.CODEC);
    }

    @Override
    protected boolean isStructure(BlockState state) {
        return state.m_60734_() == NetherBlocks.MAT_RUBEUS.getLog();
    }

    @Override
    protected boolean isGround(BlockState state) {
        return BlocksHelper.isNetherGround(state);
    }

    @Override
    protected boolean place(ServerLevelAccessor world, BlockPos pos, RandomSource random, NaturalTreeConfiguration config, int MAX_HEIGHT, StructureGeneratorThreadContext context) {
        int length = BlocksHelper.upRay((LevelAccessor)world, pos, 27);
        if (length >= 25) {
            return super.place(world, pos, random, config, MAX_HEIGHT, context);
        }
        return false;
    }

    private void updateSDFFrom(BlockPos bpos, StructureGeneratorThreadContext context) {
        for (int x = -7; x <= 7; ++x) {
            for (int y = -7; y <= 7; ++y) {
                for (int z = -7; z <= 7; ++z) {
                    int dist;
                    if (x == 0 && y == 0 && z == 0 || (dist = Math.abs(x) + Math.abs(y) + Math.abs(z)) > 7) continue;
                    BlockPos blPos = bpos.m_7918_(x, y, z);
                    context.LOGS_DIST.merge(blPos, (byte)dist, (oldDist, newDist) -> (byte)Math.min(oldDist.byteValue(), dist));
                }
            }
        }
    }

    private void updateDistances(ServerLevelAccessor world, StructureGeneratorThreadContext context) {
        for (Map.Entry<BlockPos, Byte> entry : context.LOGS_DIST.entrySet()) {
            byte dist = entry.getValue();
            BlockPos logPos = entry.getKey();
            BlockState currentState = world.m_8055_(logPos);
            if (!currentState.m_61138_((Property)BlockStateProperties.f_61414_)) continue;
            int cDist = (Integer)currentState.m_61143_((Property)BlockStateProperties.f_61414_);
            if (dist < cDist) {
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, logPos, (BlockState)currentState.m_61124_((Property)BlockStateProperties.f_61414_, (Comparable)Integer.valueOf(dist)));
                cDist = dist;
            }
            if (cDist < 7) continue;
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, logPos, Blocks.f_50016_.m_49966_());
        }
    }

    @Override
    public boolean grow(ServerLevelAccessor world, BlockPos pos, RandomSource random, NaturalTreeConfiguration config, StructureGeneratorThreadContext context) {
        boolean natural = config.natural;
        context.clear();
        world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 0);
        float scale = MHelper.randRange(0.5f, 1.0f, random);
        int minCount = (double)scale < 0.75 ? 3 : 4;
        int maxCount = (double)scale < 0.75 ? 5 : 7;
        int count = MHelper.randRange(minCount, maxCount, random);
        for (int n = 0; n < count; ++n) {
            float branchSize = MHelper.randRange(0.5f, 0.8f, random) * scale;
            float angle = (float)n * ((float)Math.PI * 2) / (float)count;
            float radius = CURVE_X[0] * branchSize;
            int x1 = Math.round((float)pos.m_123341_() + radius * (float)Math.cos(angle) + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
            int y1 = Math.round((float)pos.m_123342_() + CURVE_Y[0] * branchSize + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
            int z1 = Math.round((float)pos.m_123343_() + radius * (float)Math.sin(angle) + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
            float crownR = 5.0f * branchSize;
            if (crownR < 1.5f) {
                crownR = 1.5f;
            }
            this.crown((LevelAccessor)world, x1, y1 + 1, z1, crownR, random);
            int middle = Math.round((float)pos.m_123342_() + (float)(10 + MHelper.randRange(-2, 2, random)) * branchSize);
            boolean generate = true;
            for (int i = 1; i < CURVE_X.length && generate; ++i) {
                radius = CURVE_X[i] * branchSize;
                int x2 = Math.round((float)pos.m_123341_() + radius * (float)Math.cos(angle) + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
                int y2 = Math.round((float)pos.m_123342_() + CURVE_Y[i] * branchSize + (CURVE_Y[i] > 0.0f ? MHelper.randRange(-2.0f, 2.0f, random) * branchSize : 0.0f));
                int z2 = Math.round((float)pos.m_123343_() + radius * (float)Math.sin(angle) + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
                if (CURVE_Y[i] <= 0.0f && !this.isGround(world.m_8055_((BlockPos)context.POS.m_122178_(x2, y2, z2)))) {
                    boolean noGround = true;
                    for (int d = 1; d < 3; ++d) {
                        if (!this.isGround(world.m_8055_((BlockPos)context.POS.m_122178_(x2, y2 - d, z2)))) continue;
                        y2 -= d;
                        noGround = false;
                        break;
                    }
                    if (noGround) {
                        x2 = pos.m_123341_();
                        y2 = pos.m_123342_();
                        generate = false;
                    }
                }
                this.line((LevelAccessor)world, x1, y1, z1, x2, y2, z2, middle, context);
                x1 = x2;
                y1 = y2;
                z1 = z2;
            }
        }
        Iterator<BlockPos> iterator = context.TOP.iterator();
        while (iterator.hasNext()) {
            BlockPos bpos = iterator.next();
            if (bpos == null || !context.POINTS.contains(bpos.m_7494_()) || context.TOP.contains(bpos.m_7494_())) continue;
            iterator.remove();
        }
        iterator = context.MIDDLE.iterator();
        while (iterator.hasNext()) {
            BlockPos bpos = iterator.next();
            if (bpos != null) {
                BlockPos up = bpos.m_7494_();
                if (!context.MIDDLE.contains(up) && (context.TOP.contains(up) || !context.POINTS.contains(up))) continue;
                iterator.remove();
                continue;
            }
            iterator.remove();
        }
        for (BlockPos bpos : context.POINTS) {
            if (context.POINTS.contains(bpos.m_7494_()) && context.POINTS.contains(bpos.m_7495_())) {
                state = NetherBlocks.MAT_RUBEUS.getLog().m_49966_();
                if (context.MIDDLE.contains(bpos)) {
                    this.setCondition((LevelAccessor)world, bpos, pos.m_123342_(), (BlockState)state.m_61124_(RubeusLog.SHAPE, (Comparable)BlockProperties.TripleShape.MIDDLE), false, random);
                } else if (context.TOP.contains(bpos)) {
                    this.setCondition((LevelAccessor)world, bpos, pos.m_123342_(), (BlockState)state.m_61124_(RubeusLog.SHAPE, (Comparable)BlockProperties.TripleShape.TOP), false, random);
                } else {
                    this.setCondition((LevelAccessor)world, bpos, pos.m_123342_(), (BlockState)state.m_61124_(RubeusLog.SHAPE, (Comparable)BlockProperties.TripleShape.BOTTOM), natural, random);
                }
            } else {
                state = NetherBlocks.MAT_RUBEUS.getBark().m_49966_();
                if (context.MIDDLE.contains(bpos)) {
                    this.setCondition((LevelAccessor)world, bpos, pos.m_123342_(), (BlockState)state.m_61124_(RubeusLog.SHAPE, (Comparable)BlockProperties.TripleShape.MIDDLE), false, random);
                } else if (context.TOP.contains(bpos)) {
                    this.setCondition((LevelAccessor)world, bpos, pos.m_123342_(), (BlockState)state.m_61124_(RubeusLog.SHAPE, (Comparable)BlockProperties.TripleShape.TOP), false, random);
                } else {
                    this.setCondition((LevelAccessor)world, bpos, pos.m_123342_(), (BlockState)state.m_61124_(RubeusLog.SHAPE, (Comparable)BlockProperties.TripleShape.BOTTOM), natural, random);
                }
            }
            this.updateSDFFrom(bpos, context);
        }
        this.updateDistances(world, context);
        context.LOGS_DIST.clear();
        context.POINTS.clear();
        context.MIDDLE.clear();
        context.TOP.clear();
        return true;
    }

    private void line(LevelAccessor level, int x1, int y1, int z1, int x2, int y2, int z2, int middleY, StructureGeneratorThreadContext context) {
        int dx = x2 - x1;
        int dy = y2 - y1;
        int dz = z2 - z1;
        int mx = Math.max(Math.max(Math.abs(dx), Math.abs(dy)), Math.abs(dz));
        float fdx = (float)dx / (float)mx;
        float fdy = (float)dy / (float)mx;
        float fdz = (float)dz / (float)mx;
        float px = x1;
        float py = y1;
        float pz = z1;
        BlockPos pos = context.POS.m_122178_(x1, y1, z1).m_7949_();
        context.POINTS.add(pos);
        if (pos.m_123342_() == middleY) {
            context.MIDDLE.add(pos);
        } else if (pos.m_123342_() > middleY) {
            context.TOP.add(pos);
        }
        pos = context.POS.m_122178_(x2, y2, z2).m_7949_();
        context.POINTS.add(pos);
        if (pos.m_123342_() == middleY) {
            context.MIDDLE.add(pos);
        } else if (pos.m_123342_() > middleY) {
            context.TOP.add(pos);
        }
        for (int i = 0; i < mx; ++i) {
            context.POS.m_122178_(Math.round(px += fdx), Math.round(py += fdy), Math.round(pz += fdz));
            pos = context.POS.m_7949_();
            context.POINTS.add(pos);
            if (context.POS.m_123342_() == middleY) {
                context.MIDDLE.add(pos);
                continue;
            }
            if (context.POS.m_123342_() <= middleY) continue;
            context.TOP.add(pos);
        }
    }

    private void crown(LevelAccessor world, int x, int y, int z, float radius, RandomSource random) {
        int start;
        BlockPos.MutableBlockPos POS = new BlockPos.MutableBlockPos();
        BlockState leaves = (BlockState)NetherBlocks.RUBEUS_LEAVES.m_49966_().m_61124_((Property)LeavesBlock.f_54419_, (Comparable)Boolean.valueOf(true));
        BlockState cone = NetherBlocks.MAT_RUBEUS.getCone().m_49966_();
        float halfR = radius * 0.5f;
        float r2 = radius * radius;
        int cy = start = (int)Math.floor(-radius);
        while ((float)cy <= radius) {
            int cy2_out = cy * cy;
            float cy2_in = (float)cy + halfR;
            cy2_in *= cy2_in;
            POS.m_142448_((int)((float)(y + cy) - halfR));
            int cx = start;
            while ((float)cx <= radius) {
                int cx2 = cx * cx;
                POS.m_142451_(x + cx);
                int cz = start;
                while ((float)cz <= radius) {
                    int cz2 = cz * cz;
                    if ((float)(cx2 + cy2_out + cz2) < r2 && (float)cx2 + cy2_in + (float)cz2 > r2) {
                        POS.m_142443_(z + cz);
                        this.setIfAirLeaves(world, (BlockPos)POS, leaves);
                        if ((POS.m_123341_() + POS.m_123343_() & 1) == 0 && random.m_188503_(6) == 0) {
                            this.setIfAir(world, POS.m_7495_(), cone);
                        }
                    }
                    ++cz;
                }
                ++cx;
            }
            ++cy;
        }
    }

    private void setCondition(LevelAccessor world, BlockPos pos, int y, BlockState state, boolean moss, RandomSource random) {
        if (pos.m_123342_() > y) {
            this.setIfAir(world, pos, state);
        } else {
            this.setIfGroundOrAir(world, pos, state);
        }
        if (moss && Math.abs(pos.m_123342_() - y) < 4) {
            for (Direction dir : BlocksHelper.HORIZONTAL) {
                if (random.m_188503_(3) <= 0) continue;
                this.setIfAir(world, pos.m_121945_(dir), (BlockState)NetherBlocks.JUNGLE_MOSS.m_49966_().m_61124_((Property)BlockPlantWall.FACING, (Comparable)dir));
            }
        }
    }

    private void setIfAir(LevelAccessor world, BlockPos pos, BlockState state) {
        BlockState bState = world.m_8055_(pos);
        if ((world.m_46859_(pos) || bState.m_247087_() || bState.m_60734_() == NetherBlocks.RUBEUS_LEAVES) && state.m_60710_((LevelReader)world, pos)) {
            BlocksHelper.setWithoutUpdate(world, pos, state);
        }
    }

    private void setIfGroundOrAir(LevelAccessor world, BlockPos pos, BlockState state) {
        BlockState bState = world.m_8055_(pos);
        if ((bState.m_60795_() || bState.m_60734_() == NetherBlocks.RUBEUS_LEAVES || bState.m_247087_() || BlocksHelper.isNetherGround(bState)) && state.m_60710_((LevelReader)world, pos)) {
            BlocksHelper.setWithoutUpdate(world, pos, state);
        }
    }

    private void setIfAirLeaves(LevelAccessor world, BlockPos pos, BlockState state) {
        BlockState bState = world.m_8055_(pos);
        if (world.m_46859_(pos) || bState.m_247087_()) {
            BlocksHelper.setWithoutUpdate(world, pos, state);
        }
    }

    public boolean grow(ServerLevelAccessor level, BlockPos pos, RandomSource random, NaturalTreeConfiguration configuration) {
        return this.grow(level, pos, random, new NaturalTreeConfiguration(false, configuration.distance), NetherThreadDataStorage.generatorForThread().context);
    }
}

