/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world.features;

import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.betterx.bclib.api.v3.levelgen.features.UserGrowableFeature;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.MHelper;
import org.betterx.betternether.registry.NetherBlocks;
import org.betterx.betternether.world.features.ContextFeature;
import org.betterx.betternether.world.features.NetherThreadDataStorage;
import org.betterx.betternether.world.structures.StructureGeneratorThreadContext;

public class NetherSakuraFeature
extends ContextFeature<NoneFeatureConfiguration>
implements UserGrowableFeature<NoneFeatureConfiguration> {
    public NetherSakuraFeature() {
        super(NoneFeatureConfiguration.f_67815_);
    }

    @Override
    protected boolean place(ServerLevelAccessor world, BlockPos pos, RandomSource random, NoneFeatureConfiguration config, int MAX_HEIGHT, StructureGeneratorThreadContext context) {
        if ((double)pos.m_123342_() < (double)MAX_HEIGHT * 0.75) {
            return false;
        }
        return this.grow(world, pos, random, MAX_HEIGHT, context);
    }

    protected boolean grow(ServerLevelAccessor world, BlockPos pos, RandomSource random, int MAX_HEIGHT, StructureGeneratorThreadContext context) {
        float scale_factor = (float)MAX_HEIGHT / 128.0f;
        context.LOGS_DIST.clear();
        int l = MHelper.randRange((int)(15.0f * scale_factor), (int)(24.0f * scale_factor), random);
        double height = MHelper.randRange((int)(10.0f * scale_factor), (int)(15.0f * scale_factor), random);
        double radius = height * (0.2 + random.m_188500_() * 0.1);
        if ((double)l + height - (double)BlocksHelper.downRay((LevelAccessor)world, pos, (int)((double)l + height)) > 10.0) {
            return false;
        }
        l = BlocksHelper.downRay((LevelAccessor)world, pos, l + 1);
        int l2 = l * 2 / 3;
        for (int x = -3; x <= 3; ++x) {
            int x2 = x * x;
            context.POS.m_142451_(pos.m_123341_() + x);
            for (int z = -3; z <= 3; ++z) {
                int z2 = z * z;
                double d = (double)(x2 + z2) + 1.4;
                if (!(d < 10.0)) continue;
                if (d < 2.8 || random.m_188499_()) {
                    int start;
                    context.POS.m_142443_(pos.m_123343_() + z);
                    double length = (double)MHelper.randRange(l2, l, random) / (d > 2.0 ? d : 1.0);
                    if (length < 1.0) {
                        length = 1.0;
                    }
                    int y = start = MHelper.randRange(-2, 0, random);
                    while ((double)y < length) {
                        context.POS.m_142448_(pos.m_123342_() - y);
                        if (this.canReplace(world.m_8055_((BlockPos)context.POS))) {
                            BlocksHelper.setWithUpdate((LevelAccessor)world, (BlockPos)context.POS, NetherBlocks.MAT_NETHER_SAKURA.getLog().m_49966_());
                            this.updateSDFFrom((BlockPos)context.POS, context);
                        }
                        ++y;
                    }
                    if (NetherBlocks.MAT_NETHER_SAKURA.isTreeLog(world.m_8055_((BlockPos)context.POS).m_60734_())) {
                        BlocksHelper.setWithUpdate((LevelAccessor)world, (BlockPos)context.POS, NetherBlocks.MAT_NETHER_SAKURA.getBark().m_49966_());
                        this.updateSDFFrom((BlockPos)context.POS, context);
                    }
                }
                if (!(d < 2.0)) continue;
                this.crown((LevelAccessor)world, (BlockPos)context.POS, radius, height, context);
            }
        }
        this.updateDistances(world, context);
        context.LOGS_DIST.clear();
        return true;
    }

    private void updateSDFFrom(BlockPos bpos, StructureGeneratorThreadContext context) {
        for (int x = -7; x <= 7; ++x) {
            for (int y = -7; y <= 7; ++y) {
                for (int z = -7; z <= 7; ++z) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    int dist = Math.abs(x) + Math.abs(y) + Math.abs(z);
                    BlockPos blPos = bpos.m_7918_(x, y, z);
                    context.LOGS_DIST.merge(blPos, (byte)dist, (oldDist, newDist) -> (byte)Math.min(oldDist.byteValue(), dist));
                }
            }
        }
    }

    private void updateDistances(ServerLevelAccessor world, StructureGeneratorThreadContext context) {
        for (Map.Entry<BlockPos, Byte> entry : context.LOGS_DIST.entrySet()) {
            int dist = entry.getValue().byteValue();
            BlockPos logPos = entry.getKey();
            BlockState currentState = world.m_8055_(logPos);
            if (!currentState.m_61138_((Property)BlockStateProperties.f_61414_)) continue;
            int cDist = (Integer)currentState.m_61143_((Property)BlockStateProperties.f_61414_);
            if (dist < cDist && dist <= 7) {
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, logPos, (BlockState)currentState.m_61124_((Property)BlockStateProperties.f_61414_, (Comparable)Integer.valueOf(dist)));
            } else {
                dist = cDist;
            }
            if (dist <= 7) continue;
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, logPos, Blocks.f_50016_.m_49966_());
        }
    }

    private void crown(LevelAccessor world, BlockPos pos, double radius, double height, StructureGeneratorThreadContext context) {
        int cz2;
        int cz;
        int cx2;
        int cx;
        BlockState leaves = (BlockState)NetherBlocks.NETHER_SAKURA_LEAVES.m_49966_().m_61124_((Property)LeavesBlock.f_54419_, (Comparable)Boolean.valueOf(true));
        double r2 = radius * radius;
        int start = (int)Math.floor(-radius);
        int cy = 0;
        while ((double)cy <= radius) {
            int cy2 = cy * cy;
            context.POS2.m_142448_(pos.m_123342_() + cy);
            cx = start;
            while ((double)cx <= radius) {
                cx2 = cx * cx;
                context.POS2.m_142451_(pos.m_123341_() + cx);
                cz = start;
                while ((double)cz <= radius) {
                    cz2 = cz * cz;
                    if ((double)(cx2 + cy2 + cz2) < r2) {
                        context.POS2.m_142443_(pos.m_123343_() + cz);
                        if (world.m_8055_((BlockPos)context.POS2).m_247087_()) {
                            BlocksHelper.setWithUpdate(world, (BlockPos)context.POS2, leaves);
                        }
                    }
                    ++cz;
                }
                ++cx;
            }
            ++cy;
        }
        int cy2 = 0;
        while ((double)cy2 <= height) {
            r2 = radius * (1.0 - (double)cy2 / height);
            r2 *= r2;
            context.POS2.m_142451_(pos.m_123341_());
            context.POS2.m_142443_(pos.m_123343_());
            context.POS2.m_142448_(pos.m_123342_() - cy2);
            BlockState state = world.m_8055_((BlockPos)context.POS2);
            if (!state.m_247087_() && !NetherBlocks.MAT_NETHER_SAKURA.isTreeLog(state.m_60734_())) {
                return;
            }
            cx = start;
            while ((double)cx <= radius) {
                cx2 = cx * cx;
                context.POS2.m_142451_(pos.m_123341_() + cx);
                cz = start;
                while ((double)cz <= radius) {
                    cz2 = cz * cz;
                    if ((double)(cx2 + cz2) < r2) {
                        context.POS2.m_142443_(pos.m_123343_() + cz);
                        if (world.m_8055_((BlockPos)context.POS2).m_247087_()) {
                            BlocksHelper.setWithUpdate(world, (BlockPos)context.POS2, leaves);
                        }
                    }
                    ++cz;
                }
                ++cx;
            }
            ++cy2;
        }
    }

    private boolean canReplace(BlockState state) {
        return BlocksHelper.isNetherGround(state) || state.m_247087_();
    }

    public boolean grow(ServerLevelAccessor level, BlockPos pos, RandomSource random, NoneFeatureConfiguration configuration) {
        return this.grow(level, pos, random, 128, NetherThreadDataStorage.generatorForThread().context);
    }
}

