/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world.biomes;

import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.placement.CaveSurface;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeBuilder;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeSettings;
import org.betterx.bclib.api.v2.levelgen.surface.SurfaceRuleBuilder;
import org.betterx.bclib.api.v2.levelgen.surface.rules.Conditions;
import org.betterx.bclib.api.v2.levelgen.surface.rules.SwitchRuleSource;
import org.betterx.betternether.blocks.BlockSoulSandstone;
import org.betterx.betternether.registry.NetherBlocks;
import org.betterx.betternether.registry.NetherEntities;
import org.betterx.betternether.registry.NetherFeatures;
import org.betterx.betternether.registry.features.placed.NetherObjectsPlaced;
import org.betterx.betternether.registry.features.placed.NetherTerrainPlaced;
import org.betterx.betternether.registry.features.placed.NetherTreesPlaced;
import org.betterx.betternether.registry.features.placed.NetherVegetationPlaced;
import org.betterx.betternether.world.NetherBiome;
import org.betterx.betternether.world.NetherBiomeConfig;
import org.betterx.betternether.world.biomes.NetherGrasslands;

public class NetherWartForest
extends NetherBiome {
    public NetherWartForest(ResourceKey<Biome> biomeID, BCLBiomeSettings settings) {
        super(biomeID, settings);
    }

    public static class Config
    extends NetherBiomeConfig {
        public Config(String name) {
            super(name);
        }

        @Override
        protected void addCustomBuildData(BCLBiomeBuilder builder) {
            builder.fogColor(151, 6, 6).loop((Holder)SoundEvents.f_11954_).additions((Holder)SoundEvents.f_11901_).mood((Holder)SoundEvents.f_12007_).music((Holder)SoundEvents.f_12157_).particles((ParticleOptions)ParticleTypes.f_123784_, 0.05f).feature(NetherFeatures.NETHER_RUBY_ORE).feature(NetherTerrainPlaced.REPLACE_SOUL_SANDSTONE).feature(NetherObjectsPlaced.WART_DEADWOOD).feature(NetherTreesPlaced.SOUL_LILY).feature(NetherTreesPlaced.WART_TREE).feature(NetherObjectsPlaced.BASALT_STALAGMITE_SPARSE).feature(NetherVegetationPlaced.BLACK_BUSH).feature(NetherVegetationPlaced.VEGETATION_WART_FOREST).feature(NetherObjectsPlaced.BASALT_STALACTITE_SPARSE).addNetherClimateParamater(-0.5f, 0.5f, 0.0f).edgeSize(9);
        }

        @Override
        public BCLBiomeBuilder.BiomeSupplier<NetherBiome> getSupplier() {
            return NetherWartForest::new;
        }

        @Override
        public <M extends Mob> int spawnWeight(NetherEntities.KnownSpawnTypes type) {
            int res = super.spawnWeight(type);
            switch (type) {
                case FLYING_PIG: {
                    res = type.weight;
                    break;
                }
                case NAGA: {
                    res = 0;
                }
            }
            return res;
        }

        @Override
        public SurfaceRuleBuilder surface() {
            return super.surface().rule(SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189375_, (SurfaceRules.RuleSource)new SwitchRuleSource(Conditions.NETHER_NOISE, List.of(NetherGrasslands.SOUL_SOIL, NetherGrasslands.SOUL_SAND, NetherGrasslands.MOSS, NetherGrasslands.SOUL_SAND, NETHERRACK))), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_202171_((int)4, (boolean)true, (int)1, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)new SwitchRuleSource(Conditions.NETHER_NOISE, List.of(SurfaceRules.m_189390_((BlockState)((BlockState)NetherBlocks.SOUL_SANDSTONE.m_49966_().m_61124_((Property)BlockSoulSandstone.UP, (Comparable)Boolean.valueOf(true)))), SurfaceRules.m_189390_((BlockState)((BlockState)NetherBlocks.SOUL_SANDSTONE.m_49966_().m_61124_((Property)BlockSoulSandstone.UP, (Comparable)Boolean.valueOf(false))))))), new SwitchRuleSource(Conditions.NETHER_NOISE, List.of(NetherGrasslands.SOUL_SOIL, NetherGrasslands.SOUL_SAND, NETHERRACK))}));
        }
    }
}

