/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.integrations.emi;

import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import org.betterx.betternether.BetterNether;
import org.betterx.betternether.integrations.emi.EMIPlugin;
import org.betterx.worlds.together.util.Logger;

public class EMIForgeRecipe
implements EmiRecipe {
    private final ResourceLocation id;
    private final EmiIngredient input;
    private final EmiStack output;
    private final AbstractCookingRecipe recipe;
    private final int speedup;

    public EMIForgeRecipe(AbstractCookingRecipe recipe, int speedup) {
        this.id = new ResourceLocation("emi", recipe.m_6423_().m_135827_() + "/" + recipe.m_6423_().m_135815_() + "/forge");
        this.input = EmiIngredient.of((Ingredient)((Ingredient)recipe.m_7527_().get(0)));
        this.output = EmiStack.of((ItemStack)recipe.m_8043_(Minecraft.m_91087_().f_91073_.m_9598_()));
        this.recipe = recipe;
        this.speedup = speedup;
    }

    static void addAllRecipes(EmiRegistry emiRegistry, RecipeManager manager) {
        org.betterx.bclib.integration.emi.EMIPlugin.addAllRecipes((EmiRegistry)emiRegistry, (RecipeManager)manager, (Logger)BetterNether.LOGGER, (RecipeType)RecipeType.f_44108_, recipe -> new EMIForgeRecipe((AbstractCookingRecipe)recipe, 2));
    }

    public EmiRecipeCategory getCategory() {
        return EMIPlugin.FORGE;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return List.of(this.input);
    }

    public List<EmiStack> getOutputs() {
        return List.of(this.output);
    }

    public int getDisplayWidth() {
        return 82;
    }

    public int getDisplayHeight() {
        return 38;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addFillingArrow(24, 5, 50 * this.recipe.m_43753_()).tooltip((mx, my) -> List.of(ClientTooltipComponent.m_169948_((FormattedCharSequence)Component.m_237110_((String)"emi.cooking.time", (Object[])new Object[]{Float.valueOf((float)(this.recipe.m_43753_() / this.speedup) / 20.0f)}).m_7532_())));
        widgets.addTexture(EmiTexture.EMPTY_FLAME, 1, 24);
        widgets.addAnimatedTexture(EmiTexture.FULL_FLAME, 1, 24, 4000 / this.speedup, false, true, true);
        widgets.addText(Component.m_237110_((String)"emi.cooking.experience", (Object[])new Object[]{Float.valueOf(this.recipe.m_43750_())}).m_7532_(), 26, 28, -1, true);
        widgets.addSlot(this.input, 0, 4);
        widgets.addSlot((EmiIngredient)this.output, 56, 0).large(true).recipeContext((EmiRecipe)this);
    }
}

