/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.integrations;

import java.lang.reflect.Constructor;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import org.apache.logging.log4j.LogManager;
import org.betterx.betternether.registry.NetherItems;

public class VanillaHammersIntegration {
    private static boolean hasHammers = FabricLoader.getInstance().isModLoaded("vanilla-hammers");
    private static Constructor<?> hammerConstructor;

    public static Item makeHammer(Tier material, int attackDamage, float attackSpeed) {
        if (!hasHammers) {
            return Items.f_41852_;
        }
        try {
            return (Item)hammerConstructor.newInstance(material, attackDamage, Float.valueOf(attackSpeed), NetherItems.defaultSettings());
        }
        catch (Exception e) {
            e.printStackTrace();
            return Items.f_41852_;
        }
    }

    public static boolean hasHammers() {
        return hasHammers;
    }

    static {
        try {
            if (hasHammers) {
                LogManager.getLogger().info("[BetterNether] Enabled Vanilla Hammers Integration");
                Class<?> hammerItemClass = Class.forName("draylar.magna.item.HammerItem");
                if (hammerItemClass != null) {
                    for (Constructor<?> c : hammerItemClass.getConstructors()) {
                        if (c.getParameterCount() != 4) continue;
                        hammerConstructor = c;
                        break;
                    }
                }
                hasHammers = hammerConstructor != null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

