/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.entity.model;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.Entity;
import org.betterx.betternether.entity.EntityNaga;

public class ModelNaga
extends AgeableListModel<EntityNaga> {
    private static final int SPIKE_COUNT = 8;
    private static final int TAIL_COUNT = 4;
    public ModelPart head;
    public ModelPart body;
    public ModelPart[] tail;
    public ModelPart[] spikes;
    private float pitch;
    private float maxAngle = 0.1f;

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.m_171576_();
        PartDefinition modelPartData_HEAD = modelPartData.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-5.0f, -10.0f, -7.0f, 10.0f, 10.0f, 10.0f), PartPose.m_171419_((float)0.0f, (float)-9.0f, (float)0.0f));
        PartDefinition modelPartData_BODY = modelPartData.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(40, 0).m_171481_(-2.0f, 0.0f, -1.0f, 4.0f, 20.0f, 2.0f).m_171514_(0, 20).m_171481_(-5.0f, 3.0f, -6.0f, 10.0f, 16.0f, 6.0f), PartPose.m_171419_((float)0.0f, (float)-10.0f, (float)0.0f));
        modelPartData_BODY.m_171599_("spike_0", CubeListBuilder.m_171558_().m_171514_(33, 25).m_171481_(0.0f, 0.0f, 0.0f, 10.0f, 18.0f, 0.0f), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)((float)Math.toRadians(-40.0)), (float)0.0f));
        modelPartData_BODY.m_171599_("spike_1", CubeListBuilder.m_171558_().m_171514_(33, 25).m_171481_(0.0f, 0.0f, 0.0f, 10.0f, 18.0f, 0.0f), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)((float)Math.toRadians(-140.0)), (float)0.0f));
        float[] tailPitch = new float[]{(float)Math.toRadians(45.0), (float)Math.toRadians(45.0), 0.0f, 0.0f};
        assert (tailPitch.length == 4);
        PartDefinition tailParent = modelPartData_BODY;
        for (int i = 0; i < 4; ++i) {
            PartDefinition modelPartData_TAIL;
            int width;
            int height = (4 - i) * 4 / 4;
            if (height < 2) {
                height = 2;
            }
            if ((width = Math.round((float)height / 2.0f)) < 1) {
                width = 1;
            }
            tailParent = modelPartData_TAIL = tailParent.m_171599_("tail_" + i, CubeListBuilder.m_171558_().m_171514_(40, 0).m_171481_((float)(-height) * 0.5f, 0.0f, (float)(-width) * 0.5f, (float)height, 20.0f, (float)width), PartPose.m_171423_((float)0.0f, (float)19.0f, (float)0.0f, (float)tailPitch[i], (float)0.0f, (float)0.0f));
            if (i >= 3) continue;
            int px = 32 + (12 - height * 3);
            int index = (i << 1) + 2;
            modelPartData_TAIL.m_171599_("spike_" + index, CubeListBuilder.m_171558_().m_171514_(px, 22).m_171481_(0.0f, 0.0f, 0.0f, (float)(height * 3), 20.0f, 0.0f), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)((float)Math.toRadians(-60.0)), (float)0.0f));
            modelPartData_TAIL.m_171599_("spike_" + ++index, CubeListBuilder.m_171558_().m_171514_(px, 22).m_171481_(0.0f, 0.0f, 0.0f, (float)(height * 3), 20.0f, 0.0f), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)((float)Math.toRadians(-120.0)), (float)0.0f));
        }
        return LayerDefinition.m_171565_((MeshDefinition)modelData, (int)64, (int)64);
    }

    public ModelNaga(ModelPart root) {
        this.body = root.m_171324_("body");
        this.head = root.m_171324_("head");
        this.tail = new ModelPart[4];
        this.spikes = new ModelPart[8];
        this.spikes[0] = this.body.m_171324_("spike_0");
        this.spikes[1] = this.body.m_171324_("spike_1");
        for (int i = 0; i < 4; ++i) {
            if (i == 0) {
                this.tail[0] = this.body.m_171324_("tail_0");
            } else {
                this.tail[i] = this.tail[i - 1].m_171324_("tail_" + i);
            }
            if (i >= 3) continue;
            int index = (i << 1) + 2;
            this.spikes[index] = this.tail[i].m_171324_("spike_" + index);
            this.spikes[++index] = this.tail[i].m_171324_("spike_" + index);
        }
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.body);
    }

    public void prepareMobModel(EntityNaga livingEntity, float f, float g, float h) {
        this.pitch = livingEntity.m_20998_(h);
        super.m_6839_((Entity)livingEntity, f, g, h);
    }

    public void setupAnim(EntityNaga entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        int i;
        float angle;
        boolean rollTooBig = entity.m_21256_() > 4;
        boolean isSwimming = entity.m_6067_();
        this.head.f_104204_ = headYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = rollTooBig ? -0.7853982f : (this.pitch > 0.0f ? (isSwimming ? this.lerpAngle(this.head.f_104203_, -0.7853982f, this.pitch) : this.lerpAngle(this.head.f_104203_, headPitch * ((float)Math.PI / 180), this.pitch)) : headPitch * ((float)Math.PI / 180));
        double speed = entity.m_20096_() && (entity.m_20184_().f_82479_ != 0.0 || entity.m_20184_().f_82481_ != 0.0) && !entity.m_20159_() ? 6.0 : 0.5;
        this.maxAngle = this.lerpAngle(this.maxAngle, speed > 1.0 ? 0.1f : 0.5f, 0.03f);
        double animation = (double)animationProgress * speed / 20.0;
        float start_angle = angle = (float)Math.sin(animation) * this.maxAngle * 0.3f;
        this.tail[0].f_104204_ = angle;
        for (i = 1; i < this.tail.length; ++i) {
            angle = (float)Math.atan(Math.sin((double)i * 1.7 + animation)) * this.maxAngle;
            this.tail[i].f_104205_ = angle - start_angle;
            start_angle += angle;
        }
        for (i = 0; i < this.spikes.length; ++i) {
            float yaw;
            this.spikes[i].f_104204_ = yaw = (i & 1) == 0 ? (float)Math.toRadians(-50.0 + Math.sin(animation * 0.4 + (double)(i / 2)) * 10.0) : (float)Math.toRadians(-110.0 - Math.sin(animation * 0.4 + (double)(i / 2)) * 10.0);
        }
    }

    protected float lerpAngle(float from, float to, float position) {
        float angle = (to - from) % ((float)Math.PI * 2);
        if (angle < (float)(-Math.PI)) {
            angle += (float)Math.PI * 2;
        }
        if (angle >= (float)Math.PI) {
            angle -= (float)Math.PI * 2;
        }
        return from + position * angle;
    }
}

