/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.entity;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.betterx.bclib.entity.DespawnableAnimal;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.MHelper;
import org.betterx.betternether.registry.NetherBlocks;
import org.betterx.betternether.registry.NetherEntities;
import org.betterx.betternether.registry.NetherTags;
import org.betterx.betternether.registry.SoundsRegistry;

public class EntityFirefly
extends DespawnableAnimal
implements FlyingAnimal {
    private static final Vec3i[] SEARCH;
    private static final EntityDataAccessor<Float> COLOR_RED;
    private static final EntityDataAccessor<Float> COLOR_GREEN;
    private static final EntityDataAccessor<Float> COLOR_BLUE;
    private boolean mustSit = false;

    public EntityFirefly(EntityType<? extends EntityFirefly> type, Level world) {
        super(type, world);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
        this.f_21365_ = new FreflyLookControl((Mob)this);
        this.m_21441_(BlockPathTypes.LAVA, -1.0f);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
        this.f_21364_ = 1;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.makeColor(this.f_19796_.m_188501_(), this.f_19796_.m_188501_() * 0.5f + 0.25f, 1.0f);
    }

    public static AttributeSupplier.Builder createMobAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 1.0).m_22268_(Attributes.f_22280_, 0.6).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22277_, 48.0);
    }

    protected PathNavigation m_6037_(final Level world) {
        FlyingPathNavigation birdNavigation = new FlyingPathNavigation((Mob)this, world){

            public boolean m_6342_(BlockPos pos) {
                boolean valid;
                BlockState state = this.f_26495_.m_8055_(pos.m_7495_());
                boolean bl = valid = !state.m_60795_() && !world.m_6425_(pos.m_7495_()).m_205070_(FluidTags.f_13132_);
                if (valid) {
                    state = this.f_26495_.m_8055_(pos);
                    valid = state.m_60795_() || !state.m_280555_();
                    valid = valid && state.m_60734_() != NetherBlocks.EGG_PLANT;
                    valid = valid && !state.m_280555_();
                }
                return valid;
            }

            public void m_7638_() {
                super.m_7638_();
            }
        };
        birdNavigation.m_26440_(false);
        birdNavigation.m_7008_(false);
        birdNavigation.m_26443_(true);
        return birdNavigation;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new FollowParentGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new SittingGoal());
        this.f_21345_.m_25352_(5, (Goal)new MoveToFlowersGoal());
        this.f_21345_.m_25352_(6, (Goal)new WanderAroundGoal());
        this.f_21345_.m_25352_(7, (Goal)new MoveRandomGoal());
    }

    public float m_5610_(BlockPos pos, LevelReader worldView) {
        return worldView.m_8055_(pos).m_60795_() ? 10.0f : 0.0f;
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_41720_() == Items.f_42525_;
    }

    protected boolean m_142039_() {
        return true;
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    protected void m_203347_(TagKey<Fluid> fluid) {
        this.m_20256_(this.m_20184_().m_82520_(0.0, 0.01, 0.0));
    }

    public float m_213856_() {
        return 1.0f;
    }

    public boolean m_142535_(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    protected void m_7840_(double heightDifference, boolean onGround, BlockState landedState, BlockPos landedPosition) {
    }

    public boolean m_20068_() {
        return true;
    }

    public float getRed() {
        return ((Float)this.f_19804_.m_135370_(COLOR_RED)).floatValue();
    }

    public float getGreen() {
        return ((Float)this.f_19804_.m_135370_(COLOR_GREEN)).floatValue();
    }

    public float getBlue() {
        return ((Float)this.f_19804_.m_135370_(COLOR_BLUE)).floatValue();
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128350_("ColorRed", this.getRed());
        tag.m_128350_("ColorGreen", this.getGreen());
        tag.m_128350_("ColorBlue", this.getBlue());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("ColorRed")) {
            this.f_19804_.m_135381_(COLOR_RED, (Object)Float.valueOf(tag.m_128457_("ColorRed")));
        }
        if (tag.m_128441_("ColorGreen")) {
            this.f_19804_.m_135381_(COLOR_GREEN, (Object)Float.valueOf(tag.m_128457_("ColorGreen")));
        }
        if (tag.m_128441_("ColorBlue")) {
            this.f_19804_.m_135381_(COLOR_BLUE, (Object)Float.valueOf(tag.m_128457_("ColorBlue")));
        }
    }

    public AgeableMob m_142606_(ServerLevel world, AgeableMob mate) {
        return (AgeableMob)NetherEntities.FIREFLY.type().m_20615_((Level)world);
    }

    public boolean m_29443_() {
        return !this.m_20096_();
    }

    private void checkMovement() {
        Vec3 vel = this.m_20184_();
        if (Math.abs(vel.f_82479_) > 0.1 || Math.abs(vel.f_82481_) > 0.1) {
            double d = Math.abs(this.f_19854_ - this.m_20185_());
            if ((d += Math.abs(this.f_19856_ - this.m_20189_())) < 0.1) {
                this.f_21344_.m_26573_();
            }
        }
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)SoundsRegistry.MOB_FIREFLY_FLY.m_203334_();
    }

    protected float m_6121_() {
        return MHelper.randRange(0.1f, 0.3f, this.f_19796_);
    }

    private void makeColor(float hue, float saturation, float brightness) {
        float red = 0.0f;
        float green = 0.0f;
        float blue = 0.0f;
        float f3 = (hue - (float)Math.floor(hue)) * 6.0f;
        float f4 = f3 - (float)Math.floor(f3);
        float f5 = brightness * (1.0f - saturation);
        float f6 = brightness * (1.0f - saturation * f4);
        float f7 = brightness * (1.0f - saturation * (1.0f - f4));
        switch ((int)f3) {
            case 0: {
                red = (byte)(brightness * 255.0f + 0.5f);
                green = (byte)(f7 * 255.0f + 0.5f);
                blue = (byte)(f5 * 255.0f + 0.5f);
                break;
            }
            case 1: {
                red = (byte)(f6 * 255.0f + 0.5f);
                green = (byte)(brightness * 255.0f + 0.5f);
                blue = (byte)(f5 * 255.0f + 0.5f);
                break;
            }
            case 2: {
                red = (byte)(f5 * 255.0f + 0.5f);
                green = (byte)(brightness * 255.0f + 0.5f);
                blue = (byte)(f7 * 255.0f + 0.5f);
                break;
            }
            case 3: {
                red = (byte)(f5 * 255.0f + 0.5f);
                green = (byte)(f6 * 255.0f + 0.5f);
                blue = (byte)(brightness * 255.0f + 0.5f);
                break;
            }
            case 4: {
                red = (byte)(f7 * 255.0f + 0.5f);
                green = (byte)(f5 * 255.0f + 0.5f);
                blue = (byte)(brightness * 255.0f + 0.5f);
                break;
            }
            case 5: {
                red = (byte)(brightness * 255.0f + 0.5f);
                green = (byte)(f5 * 255.0f + 0.5f);
                blue = (byte)(f6 * 255.0f + 0.5f);
            }
        }
        this.f_19804_.m_135372_(COLOR_RED, (Object)Float.valueOf(red / 255.0f));
        this.f_19804_.m_135372_(COLOR_GREEN, (Object)Float.valueOf(green / 255.0f));
        this.f_19804_.m_135372_(COLOR_BLUE, (Object)Float.valueOf(blue / 255.0f));
    }

    public int m_5792_() {
        return 5;
    }

    public static boolean canSpawn(EntityType<? extends EntityFirefly> type, LevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        if (pos.m_123342_() >= world.m_6042_().f_156647_()) {
            return false;
        }
        int h = BlocksHelper.downRay(world, pos, 10);
        if (h > 8) {
            return false;
        }
        for (int i = 1; i <= h; ++i) {
            if (!org.betterx.bclib.util.BlocksHelper.isLava((BlockState)world.m_8055_(pos.m_6625_(i)))) continue;
            return false;
        }
        return true;
    }

    public boolean m_6094_() {
        return false;
    }

    static {
        COLOR_RED = SynchedEntityData.m_135353_(EntityFirefly.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
        COLOR_GREEN = SynchedEntityData.m_135353_(EntityFirefly.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
        COLOR_BLUE = SynchedEntityData.m_135353_(EntityFirefly.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
        ArrayList<Vec3i> points = new ArrayList<Vec3i>();
        int radius = 6;
        int r2 = radius * radius;
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    if (x * x + y * y + z * z > r2) continue;
                    points.add(new Vec3i(x, y, z));
                }
            }
        }
        points.sort(new Comparator<Vec3i>(){

            @Override
            public int compare(Vec3i v1, Vec3i v2) {
                int d1 = v1.m_123341_() * v1.m_123341_() + v1.m_123342_() * v1.m_123342_() + v1.m_123343_() * v1.m_123343_();
                int d2 = v2.m_123341_() * v2.m_123341_() + v2.m_123342_() * v2.m_123342_() + v2.m_123343_() * v2.m_123343_();
                return d1 - d2;
            }
        });
        SEARCH = points.toArray(new Vec3i[0]);
    }

    class FreflyLookControl
    extends LookControl {
        FreflyLookControl(Mob entity) {
            super(entity);
        }

        protected boolean m_8106_() {
            return true;
        }
    }

    class SittingGoal
    extends Goal {
        int timer;
        int ammount;

        SittingGoal() {
        }

        public boolean m_8036_() {
            if (EntityFirefly.this.mustSit && EntityFirefly.this.f_21344_.m_26571_()) {
                BlockPos pos = new BlockPos((int)EntityFirefly.this.m_20185_(), (int)EntityFirefly.this.m_20186_(), (int)EntityFirefly.this.m_20189_());
                BlockState state = EntityFirefly.this.m_9236_().m_8055_(pos.m_7495_());
                return !state.m_60795_() && !state.m_278721_();
            }
            return false;
        }

        public boolean m_8045_() {
            return this.timer < this.ammount;
        }

        public void m_8056_() {
            this.timer = 0;
            this.ammount = EntityFirefly.this.f_19796_.m_188503_(21) + 20;
            EntityFirefly.this.mustSit = false;
            EntityFirefly.this.m_20334_(0.0, -0.1, 0.0);
            super.m_8056_();
        }

        public void m_8041_() {
            EntityFirefly.this.m_20334_(0.0, 0.1, 0.0);
            super.m_8041_();
        }

        public void m_8037_() {
            ++this.timer;
            super.m_8037_();
        }
    }

    class MoveToFlowersGoal
    extends Goal {
        MoveToFlowersGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return EntityFirefly.this.f_21344_.m_26571_() && EntityFirefly.this.f_19796_.m_188503_(30) == 0;
        }

        public boolean m_8045_() {
            return EntityFirefly.this.f_21344_.m_26572_();
        }

        public void m_8056_() {
            BlockPos pos = this.getFlowerLocation();
            if (pos != null) {
                Path path = EntityFirefly.this.f_21344_.m_7864_(new BlockPos((Vec3i)pos), 1);
                EntityFirefly.this.f_21344_.m_26536_(path, 1.0);
            }
            super.m_8056_();
        }

        public void m_8041_() {
            if (this.isFlower(EntityFirefly.this.m_146900_())) {
                EntityFirefly.this.mustSit = true;
            }
            super.m_8041_();
        }

        private BlockPos getFlowerLocation() {
            Level w = EntityFirefly.this.m_9236_();
            BlockPos.MutableBlockPos bpos = new BlockPos.MutableBlockPos();
            for (Vec3i offset : SEARCH) {
                bpos.m_122169_(EntityFirefly.this.m_20185_() + (double)offset.m_123341_(), EntityFirefly.this.m_20186_() + (double)offset.m_123342_(), EntityFirefly.this.m_20189_() + (double)offset.m_123343_());
                if (!this.isFlower(w.m_8055_((BlockPos)bpos))) continue;
                return bpos;
            }
            return null;
        }

        private boolean isFlower(BlockState state) {
            return state.m_204336_(NetherTags.FIREFLY_FLOWERS);
        }

        public void m_8037_() {
            EntityFirefly.this.checkMovement();
            super.m_8037_();
        }
    }

    class WanderAroundGoal
    extends Goal {
        WanderAroundGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return EntityFirefly.this.f_21344_.m_26571_() && EntityFirefly.this.f_19796_.m_188503_(10) == 0;
        }

        public boolean m_8045_() {
            return EntityFirefly.this.f_21344_.m_26572_();
        }

        public void m_8056_() {
            BlockPos pos = this.getRandomLocation();
            Path path = EntityFirefly.this.f_21344_.m_7864_(pos, 1);
            if (path != null) {
                EntityFirefly.this.f_21344_.m_26536_(path, 1.0);
            } else {
                EntityFirefly.this.m_20334_(0.0, -0.2, 0.0);
            }
            super.m_8056_();
        }

        private BlockPos getRandomLocation() {
            Level w = EntityFirefly.this.m_9236_();
            BlockPos.MutableBlockPos bpos = new BlockPos.MutableBlockPos();
            bpos.m_122169_(EntityFirefly.this.m_20185_(), EntityFirefly.this.m_20186_(), EntityFirefly.this.m_20189_());
            if (w.m_46859_(bpos.m_6625_(2)) && w.m_46859_(bpos.m_7495_())) {
                int y = bpos.m_123342_() - 1;
                while (w.m_46859_(bpos.m_6625_(2)) && y > 0) {
                    bpos.m_142448_(y--);
                }
                return bpos;
            }
            Vec3 angle = EntityFirefly.this.m_20252_(0.0f);
            Vec3 airTarget = HoverRandomPos.m_148465_((PathfinderMob)EntityFirefly.this, (int)8, (int)7, (double)angle.f_82479_, (double)angle.f_82481_, (float)1.5707964f, (int)2, (int)1);
            if (airTarget == null) {
                airTarget = HoverRandomPos.m_148465_((PathfinderMob)EntityFirefly.this, (int)16, (int)10, (double)angle.f_82479_, (double)angle.f_82481_, (float)1.5707964f, (int)3, (int)1);
            }
            if (airTarget == null) {
                bpos.m_142451_(bpos.m_123341_() + this.randomRange(8));
                bpos.m_142443_(bpos.m_123343_() + this.randomRange(8));
                bpos.m_142448_(bpos.m_123342_() + this.randomRange(2));
                return bpos;
            }
            bpos.m_122169_(airTarget.m_7096_(), airTarget.m_7098_(), airTarget.m_7094_());
            return bpos;
        }

        private int randomRange(int side) {
            RandomSource random = EntityFirefly.this.f_19796_;
            return random.m_188503_(side + 1) - (side >> 1);
        }

        public void m_8037_() {
            EntityFirefly.this.checkMovement();
            super.m_8037_();
        }
    }

    class MoveRandomGoal
    extends Goal {
        int timer;
        int ammount;

        MoveRandomGoal() {
        }

        public boolean m_8036_() {
            return EntityFirefly.this.f_21344_.m_26571_() && EntityFirefly.this.f_19796_.m_188503_(20) == 0;
        }

        public boolean m_8045_() {
            return this.timer < this.ammount;
        }

        public void m_8056_() {
            this.timer = 0;
            this.ammount = EntityFirefly.this.f_19796_.m_188503_(30) + 10;
            Vec3 velocity = new Vec3(EntityFirefly.this.f_19796_.m_188500_(), EntityFirefly.this.f_19796_.m_188500_(), EntityFirefly.this.f_19796_.m_188500_());
            if (velocity.m_82556_() == 0.0) {
                velocity = new Vec3(1.0, 0.0, 0.0);
            }
            EntityFirefly.this.m_20256_(velocity.m_82541_().m_82490_((double)EntityFirefly.this.m_274460_()));
            super.m_8056_();
        }

        public void m_8037_() {
            ++this.timer;
            super.m_8037_();
        }
    }
}

