/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.enchantments;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.betterx.betternether.BetterNether;
import org.betterx.betternether.MHelper;
import org.betterx.betternether.items.NetherArmor;
import org.betterx.betternether.items.materials.BNToolMaterial;
import org.betterx.betternether.registry.NetherEnchantments;
import org.betterx.worlds.together.tag.v3.CommonBlockTags;

public class RubyFire
extends Enchantment {
    private static final EquipmentSlot[] ARMOR_SLOTS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
    private static final Map<Item, BlastingRecipe> FIRE_CONVERSIONS = new HashMap<Item, BlastingRecipe>();
    public static final ThreadLocal<List<ItemStack>> convertedDrops = ThreadLocal.withInitial(ArrayList::new);

    public RubyFire() {
        super(Enchantment.Rarity.VERY_RARE, EnchantmentCategory.BREAKABLE, ARMOR_SLOTS);
    }

    public boolean m_6081_(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        Item i = itemStack.m_41720_();
        if (i instanceof TieredItem) {
            TieredItem t = (TieredItem)i;
            return t.m_43314_() == BNToolMaterial.FLAMING_RUBY;
        }
        return i instanceof NetherArmor;
    }

    public boolean m_6589_() {
        return true;
    }

    public boolean m_6591_() {
        return true;
    }

    public boolean m_6594_() {
        return false;
    }

    public boolean m_6592_() {
        return false;
    }

    public void m_7675_(LivingEntity player, Entity entity, int i) {
        RandomSource random = player.m_217043_();
        Map.Entry entry = EnchantmentHelper.m_44906_((Enchantment)NetherEnchantments.RUBY_FIRE, (LivingEntity)player);
        if (RubyFire.shouldHit(i, random)) {
            if (entity != null) {
                entity.m_6469_(player.m_269291_().m_269104_(entity, entity), (float)RubyFire.getDamage(i, random));
                entity.m_7311_(100 + 50 * random.m_188503_(3));
                if (entity instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)entity;
                    living.m_147240_((double)(1.0f + MHelper.nextFloat(random, 2.0f)), player.m_20185_() - living.m_20185_(), player.m_20189_() - living.m_20189_());
                }
            }
            if (entry != null) {
                ((ItemStack)entry.getValue()).m_41622_(1, player, livingEntity -> livingEntity.m_21166_((EquipmentSlot)entry.getKey()));
            }
        }
    }

    private static boolean shouldHit(int i, RandomSource random) {
        if (i <= 0) {
            return false;
        }
        return random.m_188501_() < 0.2f * (float)i;
    }

    private static int getDamage(int i, RandomSource random) {
        if (i > 10) {
            return i - 10;
        }
        return 2 + random.m_188503_(5);
    }

    public static boolean getDrops(BlockState brokenBlock, ServerLevel level, BlockPos blockPos, Player player, ItemStack breakingItem) {
        int fireLevel = EnchantmentHelper.m_44843_((Enchantment)NetherEnchantments.RUBY_FIRE, (ItemStack)breakingItem);
        if (fireLevel > 0) {
            if (FIRE_CONVERSIONS.isEmpty()) {
                RubyFire.buildConversionTable(level);
            }
            boolean didConvert = false;
            int xpDrop = 0;
            try {
                List drops = Block.m_49874_((BlockState)brokenBlock, (ServerLevel)level, (BlockPos)blockPos, null, (Entity)player, (ItemStack)breakingItem);
                convertedDrops.get().clear();
                for (ItemStack stack : drops) {
                    BlastingRecipe result = FIRE_CONVERSIONS.get(stack.m_41720_());
                    if (result != null) {
                        didConvert = true;
                        ItemStack resultStack = result.m_8043_(level.m_9598_());
                        xpDrop = (int)((float)xpDrop + result.m_43750_());
                        convertedDrops.get().add(new ItemStack((ItemLike)resultStack.m_41720_(), resultStack.m_41613_() * stack.m_41613_()));
                        continue;
                    }
                    convertedDrops.get().add(stack);
                }
            }
            catch (Exception e) {
                BetterNether.LOGGER.error("Unable to get Drops for " + breakingItem, e);
            }
            if (didConvert) {
                if (xpDrop > 0) {
                    RubyFire.popExperience(level, blockPos, xpDrop);
                }
                convertedDrops.get().forEach(itemStack -> Block.m_49840_((Level)level, (BlockPos)blockPos, (ItemStack)itemStack));
                brokenBlock.m_222967_(level, blockPos, breakingItem, true);
                convertedDrops.get().clear();
                return true;
            }
            convertedDrops.get().clear();
        }
        return false;
    }

    private static void popExperience(ServerLevel level, BlockPos blockPos, int amount) {
        if (level.m_46469_().m_46207_(GameRules.f_46136_)) {
            ExperienceOrb.m_147082_((ServerLevel)level, (Vec3)Vec3.m_82512_((Vec3i)blockPos), (int)amount);
        }
    }

    private static void buildConversionTable(ServerLevel level) {
        List recipes = level.m_7465_().m_44013_(RecipeType.f_44109_);
        for (BlastingRecipe r : recipes) {
            for (Ingredient ingredient : r.m_7527_()) {
                for (ItemStack stack : ingredient.m_43908_()) {
                    BlockItem blitem;
                    Item item = stack.m_41720_();
                    if (item instanceof BlockItem && (blitem = (BlockItem)item).m_40614_().m_49966_().m_204336_(CommonBlockTags.IS_OBSIDIAN)) continue;
                    FIRE_CONVERSIONS.put(stack.m_41720_(), r);
                }
            }
        }
    }
}

