/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.blocks;

import de.ambertation.wunderlib.math.Float3;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.behaviours.interfaces.BehaviourMetal;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.blocks.BNRenderLayer;
import org.betterx.betternether.blocks.BlockBaseNotFull;
import org.betterx.betternether.config.Configs;
import org.betterx.betternether.registry.NetherBlocks;

public class BlockStatueRespawner
extends BlockBaseNotFull
implements BehaviourMetal {
    private static final VoxelShape SHAPE = BlockStatueRespawner.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    private static final VoxelShape CULL_SHAPE = Shapes.m_83124_((VoxelShape)BlockStatueRespawner.m_49796_((double)9.0, (double)0.0, (double)4.0, (double)13.0, (double)12.0, (double)8.0), (VoxelShape[])new VoxelShape[]{BlockStatueRespawner.m_49796_((double)5.0, (double)0.0, (double)8.0, (double)7.0, (double)6.0, (double)10.0), BlockStatueRespawner.m_49796_((double)9.0, (double)0.0, (double)8.0, (double)13.0, (double)12.0, (double)122.0), BlockStatueRespawner.m_49796_((double)5.0, (double)0.0, (double)6.0, (double)7.0, (double)6.0, (double)8.0)});
    private static final DustParticleOptions EFFECT = new DustParticleOptions(Float3.X_AXIS.toVector3(), 1.0f);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty TOP = BooleanProperty.m_61465_((String)"top");
    private final ItemStack requiredItem;

    public BlockStatueRespawner() {
        super(FabricBlockSettings.copyOf((BlockBehaviour)NetherBlocks.CINCINNASITE_BLOCK).luminance(15).m_60955_());
        this.setRenderLayer(BNRenderLayer.CUTOUT);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)TOP, (Comparable)Boolean.valueOf(false)));
        this.setDropItself(false);
        String itemName = Configs.MAIN.getString("respawn_statue", "respawn_item", BuiltInRegistries.f_257033_.m_7981_((Object)Items.f_42054_).toString());
        Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(itemName));
        if (item == Items.f_41852_) {
            item = Items.f_42054_;
        }
        int count = Configs.MAIN.getInt("respawn_statue", "item_count", 4);
        this.requiredItem = new ItemStack((ItemLike)item, count);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.m_61104_(new Property[]{FACING, TOP});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return SHAPE;
    }

    public VoxelShape m_7952_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return CULL_SHAPE;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21205_();
        if (stack.m_41720_() == this.requiredItem.m_41720_() && stack.m_41613_() >= this.requiredItem.m_41613_()) {
            float y;
            float f = y = (Boolean)state.m_61143_((Property)TOP) != false ? 0.4f : 1.4f;
            if (!player.m_7500_()) {
                player.m_21205_().m_41774_(this.requiredItem.m_41613_());
            }
            for (int i = 0; i < 50; ++i) {
                world.m_7106_((ParticleOptions)EFFECT, (double)((float)pos.m_123341_() + world.f_46441_.m_188501_()), (double)((float)pos.m_123342_() + y) + (double)world.f_46441_.m_188501_() * 0.2, (double)((float)pos.m_123343_() + world.f_46441_.m_188501_()), 0.0, 0.0, 0.0);
            }
            player.m_5661_((Component)Component.m_237110_((String)"message.spawn_set", (Object[])new Object[0]), true);
            if (!world.f_46443_) {
                ((ServerPlayer)player).m_9158_(world.m_46472_(), pos, player.m_6080_(), false, true);
            }
            player.m_5496_(SoundEvents.f_12513_, 0.7f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        player.m_5661_((Component)Component.m_237110_((String)"message.spawn_help", (Object[])new Object[]{this.requiredItem}), true);
        return InteractionResult.SUCCESS;
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        if (((Boolean)state.m_61143_((Property)TOP)).booleanValue()) {
            return true;
        }
        BlockState up = world.m_8055_(pos.m_7494_());
        return up.m_60795_() || up.m_60734_() == this && (Boolean)up.m_61143_((Property)TOP) != false;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack itemStack) {
        if (!world.m_5776_()) {
            BlocksHelper.setWithUpdate((LevelAccessor)world, pos.m_7494_(), (BlockState)state.m_61124_((Property)TOP, (Comparable)Boolean.valueOf(true)));
        }
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)TOP)).booleanValue()) {
            return world.m_8055_(pos.m_7495_()).m_60734_() == this ? state : Blocks.f_50016_.m_49966_();
        }
        return world.m_8055_(pos.m_7494_()).m_60734_() == this ? state : Blocks.f_50016_.m_49966_();
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return BlocksHelper.rotateHorizontal(state, rotation, (Property<Direction>)FACING);
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return BlocksHelper.mirrorHorizontal(state, mirror, (Property<Direction>)FACING);
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        if (player.m_7500_() && ((Boolean)state.m_61143_((Property)TOP)).booleanValue() && world.m_8055_(pos.m_7495_()).m_60734_() == this) {
            world.m_46597_(pos.m_7495_(), Blocks.f_50016_.m_49966_());
        }
        super.m_5707_(world, pos, state, player);
    }
}

