/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.blocks;

import com.google.common.collect.Lists;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.interfaces.tools.AddMineableAxe;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.MHelper;
import org.betterx.betternether.blocks.BNRenderLayer;
import org.betterx.betternether.blocks.BlockBaseNotFull;
import org.betterx.betternether.blocks.materials.Materials;
import org.betterx.betternether.interfaces.SurvivesOnSoulGround;
import org.betterx.betternether.registry.NetherBlocks;
import org.betterx.betternether.world.features.SoulLilyFeature;

public class BlockSoulLily
extends BlockBaseNotFull
implements SurvivesOnSoulGround,
AddMineableAxe {
    public static final EnumProperty<SoulLilyShape> SHAPE = EnumProperty.m_61587_((String)"shape", SoulLilyShape.class);
    private static final VoxelShape SHAPE_SMALL = BlockSoulLily.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape SHAPE_MEDIUM_BOTTOM = BlockSoulLily.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final VoxelShape SHAPE_MEDIUM_TOP = BlockSoulLily.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);
    private static final VoxelShape SHAPE_BIG_BOTTOM = BlockSoulLily.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final VoxelShape SHAPE_BIG_MIDDLE = BlockSoulLily.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape SHAPE_BIG_TOP_CENTER = BlockSoulLily.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
    private static final VoxelShape SHAPE_BIG_TOP_SIDE_N = BlockSoulLily.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)6.0, (double)8.0);
    private static final VoxelShape SHAPE_BIG_TOP_SIDE_S = BlockSoulLily.m_49796_((double)0.0, (double)4.0, (double)8.0, (double)16.0, (double)6.0, (double)16.0);
    private static final VoxelShape SHAPE_BIG_TOP_SIDE_E = BlockSoulLily.m_49796_((double)8.0, (double)4.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0);
    private static final VoxelShape SHAPE_BIG_TOP_SIDE_W = BlockSoulLily.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)8.0, (double)6.0, (double)16.0);
    private static final SoulLilyFeature STRUCTURE = new SoulLilyFeature();
    private static final SoulLilyShape[] ROT = new SoulLilyShape[]{SoulLilyShape.BIG_TOP_SIDE_N, SoulLilyShape.BIG_TOP_SIDE_E, SoulLilyShape.BIG_TOP_SIDE_S, SoulLilyShape.BIG_TOP_SIDE_W};

    public BlockSoulLily() {
        super(Materials.makeNetherWood(MapColor.f_283750_).m_60978_(1.0f).m_60955_().m_60977_());
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_(SHAPE, (Comparable)((Object)SoulLilyShape.SMALL)));
        this.setRenderLayer(BNRenderLayer.CUTOUT);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.m_61104_(new Property[]{SHAPE});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        switch ((SoulLilyShape)((Object)state.m_61143_(SHAPE))) {
            case BIG_BOTTOM: {
                return SHAPE_BIG_BOTTOM;
            }
            case BIG_MIDDLE: {
                return SHAPE_BIG_MIDDLE;
            }
            case BIG_TOP_CENTER: {
                return SHAPE_BIG_TOP_CENTER;
            }
            case MEDIUM_BOTTOM: {
                return SHAPE_MEDIUM_BOTTOM;
            }
            case MEDIUM_TOP: {
                return SHAPE_MEDIUM_TOP;
            }
            case BIG_TOP_SIDE_N: {
                return SHAPE_BIG_TOP_SIDE_N;
            }
            case BIG_TOP_SIDE_S: {
                return SHAPE_BIG_TOP_SIDE_S;
            }
            case BIG_TOP_SIDE_E: {
                return SHAPE_BIG_TOP_SIDE_E;
            }
            case BIG_TOP_SIDE_W: {
                return SHAPE_BIG_TOP_SIDE_W;
            }
        }
        return SHAPE_SMALL;
    }

    public boolean canGrow(Level world, BlockPos pos, RandomSource random) {
        BlockState state = world.m_8055_(pos.m_7495_());
        if (state.m_60734_() == this || state.m_60734_() == Blocks.f_50135_ || BlocksHelper.isFertile(world.m_8055_(pos.m_7495_()))) {
            return BlocksHelper.isFertile(world.m_8055_(pos.m_7495_())) ? random.m_188503_(8) == 0 : random.m_188503_(16) == 0;
        }
        return false;
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        super.m_213897_(state, world, pos, random);
        if (this.canGrow((Level)world, pos, random)) {
            SoulLilyShape shape = (SoulLilyShape)((Object)state.m_61143_(SHAPE));
            if (shape == SoulLilyShape.SMALL && world.m_46859_(pos.m_7494_())) {
                STRUCTURE.growMedium((LevelAccessor)world, pos);
            } else if (shape == SoulLilyShape.MEDIUM_BOTTOM && world.m_46859_(pos.m_6630_(2)) && this.isAirSides((Level)world, pos.m_6630_(2))) {
                STRUCTURE.growBig((LevelAccessor)world, pos);
            }
        }
    }

    private boolean isAirSides(Level world, BlockPos pos) {
        return world.m_46859_(pos.m_122012_()) && world.m_46859_(pos.m_122019_()) && world.m_46859_(pos.m_122029_()) && world.m_46859_(pos.m_122024_());
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        SoulLilyShape shape = (SoulLilyShape)((Object)state.m_61143_(SHAPE));
        int index = this.getRotationIndex(shape);
        if (index < 0) {
            return state;
        }
        int offset = this.rotOffset(rotation);
        return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)ROT[index + offset & 3]));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        SoulLilyShape shape = (SoulLilyShape)((Object)state.m_61143_(SHAPE));
        int index = this.getRotationIndex(shape);
        if (index < 0) {
            return state;
        }
        if (mirror == Mirror.FRONT_BACK) {
            if (shape == SoulLilyShape.BIG_TOP_SIDE_E) {
                shape = SoulLilyShape.BIG_TOP_SIDE_W;
            } else if (shape == SoulLilyShape.BIG_TOP_SIDE_W) {
                shape = SoulLilyShape.BIG_TOP_SIDE_E;
            }
        } else if (mirror == Mirror.LEFT_RIGHT) {
            if (shape == SoulLilyShape.BIG_TOP_SIDE_N) {
                shape = SoulLilyShape.BIG_TOP_SIDE_S;
            } else if (shape == SoulLilyShape.BIG_TOP_SIDE_S) {
                shape = SoulLilyShape.BIG_TOP_SIDE_N;
            }
        }
        return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)shape));
    }

    private int getRotationIndex(SoulLilyShape shape) {
        for (int i = 0; i < 4; ++i) {
            if (shape != ROT[i]) continue;
            return i;
        }
        return -1;
    }

    private int rotOffset(Rotation rotation) {
        if (rotation == Rotation.NONE) {
            return 0;
        }
        if (rotation == Rotation.CLOCKWISE_90) {
            return 1;
        }
        if (rotation == Rotation.CLOCKWISE_180) {
            return 2;
        }
        return 3;
    }

    @Environment(value=EnvType.CLIENT)
    public ItemStack m_7397_(BlockGetter world, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)NetherBlocks.SOUL_LILY_SAPLING);
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        Comparable _shape = (Comparable)state.m_61148_().get(SHAPE);
        if (_shape == null) {
            return false;
        }
        SoulLilyShape shape = (SoulLilyShape)((Object)SHAPE.m_61709_().cast(_shape));
        if (shape == SoulLilyShape.BIG_TOP_SIDE_N) {
            return world.m_8055_(pos.m_122012_()).m_60734_() == this;
        }
        if (shape == SoulLilyShape.BIG_TOP_SIDE_S) {
            return world.m_8055_(pos.m_122019_()).m_60734_() == this;
        }
        if (shape == SoulLilyShape.BIG_TOP_SIDE_E) {
            return world.m_8055_(pos.m_122029_()).m_60734_() == this;
        }
        if (shape == SoulLilyShape.BIG_TOP_SIDE_W) {
            return world.m_8055_(pos.m_122024_()).m_60734_() == this;
        }
        BlockState down = world.m_8055_(pos.m_7495_());
        return down.m_60734_() == this || this.isSurvivable(down);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return this.m_7898_(state, (LevelReader)world, pos) ? state : Blocks.f_50016_.m_49966_();
    }

    @Override
    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        switch ((SoulLilyShape)((Object)state.m_61143_(SHAPE))) {
            case BIG_BOTTOM: 
            case BIG_MIDDLE: {
                return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)NetherBlocks.MAT_NETHER_MUSHROOM.getStem())});
            }
            case BIG_TOP_CENTER: {
                return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)NetherBlocks.MAT_NETHER_MUSHROOM.getStem()), new ItemStack((ItemLike)NetherBlocks.SOUL_LILY_SAPLING)});
            }
            case MEDIUM_BOTTOM: {
                return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)NetherBlocks.MAT_NETHER_MUSHROOM.getStem())});
            }
            case BIG_TOP_SIDE_N: 
            case BIG_TOP_SIDE_S: 
            case BIG_TOP_SIDE_E: 
            case BIG_TOP_SIDE_W: {
                return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)NetherBlocks.MAT_NETHER_MUSHROOM.getStem()), new ItemStack((ItemLike)NetherBlocks.SOUL_LILY_SAPLING, MHelper.randRange(0, 1, MHelper.RANDOM))});
            }
        }
        return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)NetherBlocks.MAT_NETHER_MUSHROOM.getStem()), new ItemStack((ItemLike)NetherBlocks.SOUL_LILY_SAPLING)});
    }

    public static enum SoulLilyShape implements StringRepresentable
    {
        SMALL("small"),
        MEDIUM_BOTTOM("medium_bottom"),
        MEDIUM_TOP("medium_top"),
        BIG_BOTTOM("big_bottom"),
        BIG_MIDDLE("big_middle"),
        BIG_TOP_CENTER("big_top_center"),
        BIG_TOP_SIDE_N("big_top_side_n"),
        BIG_TOP_SIDE_S("big_top_side_s"),
        BIG_TOP_SIDE_E("big_top_side_e"),
        BIG_TOP_SIDE_W("big_top_side_w");

        final String name;

        private SoulLilyShape(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

