/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.blocks;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.behaviours.interfaces.BehaviourSeed;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.blocks.BlockBaseNotFull;
import org.betterx.betternether.blocks.materials.Materials;
import org.betterx.betternether.registry.NetherBlocks;
import org.betterx.betternether.registry.features.configured.NetherVegetation;

public class BlockLucisSpore
extends BlockBaseNotFull
implements BonemealableBlock,
BehaviourSeed {
    private static final EnumMap<Direction, VoxelShape> BOUNDING_SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)BlockLucisSpore.m_49796_((double)4.0, (double)4.0, (double)8.0, (double)12.0, (double)12.0, (double)16.0), (Object)Direction.SOUTH, (Object)BlockLucisSpore.m_49796_((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)8.0), (Object)Direction.WEST, (Object)BlockLucisSpore.m_49796_((double)8.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0), (Object)Direction.EAST, (Object)BlockLucisSpore.m_49796_((double)0.0, (double)4.0, (double)4.0, (double)8.0, (double)12.0, (double)12.0)));
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;

    public BlockLucisSpore() {
        super(Materials.NETHER_SAPLING.m_284180_(MapColor.f_283916_).m_60953_(bs -> 7));
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.m_61104_(new Property[]{FACING});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return BOUNDING_SHAPES.get(state.m_61143_((Property)FACING));
    }

    public boolean m_7370_(LevelReader world, BlockPos pos, BlockState state, boolean isClient) {
        return true;
    }

    public boolean m_214167_(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return random.m_188503_(16) == 0;
    }

    public void m_214148_(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        NetherVegetation.WALL_LUCIS.placeInWorld(world, pos, random);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (this.m_7898_(state, (LevelReader)world, pos)) {
            return state;
        }
        return Blocks.f_50016_.m_49966_();
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        super.m_213897_(state, world, pos, random);
        if (this.m_214167_((Level)world, random, pos, state)) {
            this.m_214148_(world, random, pos, state);
        }
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return BlocksHelper.rotateHorizontal(state, rotation, (Property<Direction>)FACING);
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return BlocksHelper.mirrorHorizontal(state, mirror, (Property<Direction>)FACING);
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockPos blockPos = pos.m_121945_(direction.m_122424_());
        BlockState blockState = world.m_8055_(blockPos);
        return BlocksHelper.isNetherrack(blockState) || NetherBlocks.MAT_ANCHOR_TREE.isTreeLog(blockState.m_60734_());
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState blockState = this.m_49966_();
        Level worldView = ctx.m_43725_();
        BlockPos blockPos = ctx.m_8083_();
        Direction[] directions = ctx.m_6232_();
        for (int i = 0; i < directions.length; ++i) {
            Direction direction2;
            Direction direction = directions[i];
            if (!direction.m_122434_().m_122479_() || !(blockState = (BlockState)blockState.m_61124_((Property)FACING, (Comparable)(direction2 = direction.m_122424_()))).m_60710_((LevelReader)worldView, blockPos)) continue;
            return blockState;
        }
        return null;
    }
}

