/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.blocks;

import java.util.Collections;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.behaviours.interfaces.BehaviourPlant;
import org.betterx.bclib.util.LootUtil;
import org.betterx.betternether.blocks.BNBlockProperties;
import org.betterx.betternether.blocks.BlockCommonPlant;
import org.betterx.betternether.config.Configs;
import org.betterx.betternether.interfaces.SurvivesOnNetherGround;
import org.betterx.betternether.registry.NetherEntities;

public class BlockEggPlant
extends BlockCommonPlant
implements SurvivesOnNetherGround,
BehaviourPlant {
    private static final VoxelShape SHAPE = BlockEggPlant.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    public static final BooleanProperty DESTRUCTED = BNBlockProperties.DESTRUCTED;
    private boolean enableModDamage = Configs.MAIN.getBoolean("egg_plant", "mob_damage", true);
    private boolean enablePlayerDamage = Configs.MAIN.getBoolean("egg_plant", "player_damage", true);

    public BlockEggPlant() {
        super(MapColor.f_283919_);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)DESTRUCTED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateManager) {
        super.m_7926_(stateManager);
        stateManager.m_61104_(new Property[]{DESTRUCTED});
    }

    @Override
    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        return this.canSurviveOnTop(world, pos);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return SHAPE;
    }

    @Environment(value=EnvType.CLIENT)
    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (!((Boolean)state.m_61143_((Property)DESTRUCTED)).booleanValue()) {
            world.m_7106_((ParticleOptions)ParticleTypes.f_123811_, (double)pos.m_123341_() + random.m_188500_(), (double)pos.m_123342_() + 0.4, (double)pos.m_123343_() + random.m_188500_(), 0.46, 0.28, 0.55);
        }
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (!((Boolean)state.m_61143_((Property)DESTRUCTED)).booleanValue()) {
            if (this.enableModDamage && entity instanceof LivingEntity && !((LivingEntity)entity).m_21023_(MobEffects.f_19614_)) {
                if (!NetherEntities.isNetherEntity(entity)) {
                    ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19614_, 100, 3));
                }
            } else if (this.enablePlayerDamage && entity instanceof Player && !((Player)entity).m_21023_(MobEffects.f_19614_)) {
                ((Player)entity).m_7292_(new MobEffectInstance(MobEffects.f_19614_, 100, 3));
            }
            double px = (double)pos.m_123341_() + 0.5;
            double py = (double)pos.m_123342_() + 0.125;
            double pz = (double)pos.m_123343_() + 0.5;
            if (world.f_46443_) {
                world.m_7785_(px, py, pz, SoundType.f_56719_.m_56775_(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
                BlockParticleOption effect = new BlockParticleOption(ParticleTypes.f_123794_, state);
                RandomSource random = world.f_46441_;
                for (int i = 0; i < 24; ++i) {
                    world.m_7106_((ParticleOptions)effect, px + random.m_188583_() * 0.2, py + random.m_188583_() * 0.2, pz + random.m_188583_() * 0.2, random.m_188583_(), random.m_188583_(), random.m_188583_());
                }
            }
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)DESTRUCTED, (Comparable)Boolean.valueOf(true)));
        }
    }

    @Override
    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        ItemStack tool = (ItemStack)builder.m_287261_(LootContextParams.f_81463_);
        if (LootUtil.isCorrectTool((ItemLike)this, (BlockState)state, (ItemStack)tool)) {
            return Collections.singletonList(new ItemStack((ItemLike)this.m_5456_()));
        }
        return super.m_49635_(state, builder);
    }

    @Override
    public void m_214148_(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        if (((Boolean)state.m_61143_((Property)DESTRUCTED)).booleanValue()) {
            world.m_46597_(pos, this.m_49966_());
        }
    }
}

