/*
 * Decompiled with CFR 0.152.
 */
package dev.onyxstudios.cca.api.v3.entity;

import dev.onyxstudios.cca.api.v3.component.Component;
import dev.onyxstudios.cca.api.v3.component.ComponentKey;
import dev.onyxstudios.cca.api.v3.component.CopyableComponent;
import dev.onyxstudios.cca.internal.entity.CardinalEntityInternals;
import net.minecraft.class_2487;

@FunctionalInterface
public interface RespawnCopyStrategy<C extends Component> {
    public static final RespawnCopyStrategy<Component> ALWAYS_COPY = (from, to, lossless, keepInventory, sameCharacter) -> RespawnCopyStrategy.copy(from, to);
    public static final RespawnCopyStrategy<Component> CHARACTER = (from, to, lossless, keepInventory, sameCharacter) -> {
        if (sameCharacter) {
            RespawnCopyStrategy.copy(from, to);
        }
    };
    public static final RespawnCopyStrategy<Component> INVENTORY = (from, to, lossless, keepInventory, sameCharacter) -> {
        if (lossless || keepInventory) {
            RespawnCopyStrategy.copy(from, to);
        }
    };
    public static final RespawnCopyStrategy<Component> LOSSLESS_ONLY = (from, to, lossless, keepInventory, sameCharacter) -> {
        if (lossless) {
            RespawnCopyStrategy.copy(from, to);
        }
    };
    public static final RespawnCopyStrategy<Component> NEVER_COPY = (from, to, lossless, keepInventory, sameCharacter) -> {};

    public static <C extends Component> RespawnCopyStrategy<? super C> get(ComponentKey<C> key) {
        return CardinalEntityInternals.getRespawnCopyStrategy(key);
    }

    public static <C extends Component> void copy(C from, C to) {
        if (to instanceof CopyableComponent) {
            CardinalEntityInternals.copyAsCopyable(from, (CopyableComponent)to);
        } else {
            class_2487 tag = new class_2487();
            from.writeToNbt(tag);
            to.readFromNbt(tag);
        }
    }

    public void copyForRespawn(C var1, C var2, boolean var3, boolean var4, boolean var5);
}

