/*
 * Decompiled with CFR 0.152.
 */
package com.brass_amber.ba_bt.worldGen.structures;

import com.brass_amber.ba_bt.BABTMain;
import com.brass_amber.ba_bt.BattleTowersConfig;
import com.brass_amber.ba_bt.util.BTStatics;
import com.brass_amber.ba_bt.util.BTUtil;
import com.brass_amber.ba_bt.util.SaveTowers;
import com.brass_amber.ba_bt.worldGen.structures.TowerPieces;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DeadBushBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.jetbrains.annotations.NotNull;

public abstract class TowerStructure
extends Structure {
    protected final BTStructureSettings extraSettings;
    protected String towerName;
    protected final List<Integer> minimumSeperations;
    protected final List<Integer> averageSeperations;
    protected int towerType = 0;
    protected int towerId = -1;
    protected String[] towerTypeConversion;
    protected final Boolean buryTower = false;
    protected final Boolean randomBuryDepth = false;

    protected TowerStructure(Structure.StructureSettings structureSettings, BTStructureSettings extraSettings) {
        super(structureSettings);
        this.extraSettings = extraSettings;
        this.minimumSeperations = List.of((Integer)BattleTowersConfig.landMinimumSeperation.get(), (Integer)BattleTowersConfig.oceanMinimumSeperation.get());
        this.averageSeperations = List.of((Integer)BattleTowersConfig.landAverageSeperationModifier.get(), (Integer)BattleTowersConfig.oceanAverageSeperationModifier.get());
    }

    public static <S extends TowerStructure> RecordCodecBuilder<S, BTStructureSettings> extraSettingsCodec() {
        return BTStructureSettings.CODEC.forGetter(object -> new BTStructureSettings(null));
    }

    @NotNull
    public StructureStart m_226596_(RegistryAccess registryAccess, ChunkGenerator chunkGenerator, BiomeSource biomeSource, RandomState randomState, StructureTemplateManager templateManager, long seed, ChunkPos chunkPos, int i, LevelHeightAccessor heightAccessor, Predicate<Holder<Biome>> biomePredicate) {
        if (chunkGenerator instanceof FlatLevelSource) {
            return StructureStart.f_73561_;
        }
        Structure.GenerationContext structure$generationcontext = new Structure.GenerationContext(registryAccess, chunkGenerator, biomeSource, randomState, templateManager, seed, chunkPos, heightAccessor, biomePredicate);
        Optional<Structure.GenerationStub> optional = this.m_214086_(structure$generationcontext);
        if (optional.isPresent()) {
            StructurePiecesBuilder structurepiecesbuilder = optional.get().m_226677_();
            StructureStart structurestart = new StructureStart((Structure)this, new ChunkPos(optional.get().f_226669_()), i, structurepiecesbuilder.m_192780_());
            if (structurestart.m_73603_()) {
                return structurestart;
            }
        }
        return StructureStart.f_73561_;
    }

    @NotNull
    public Optional<Structure.GenerationStub> m_262864_(Structure.GenerationContext generationContext) {
        boolean canSpawn = false;
        ChunkPos checkPos = generationContext.f_226628_();
        for (Pair<ChunkPos, Rotation> towerPosRotation : SaveTowers.towers.get(this.towerId)) {
            ChunkPos towerPos = (ChunkPos)towerPosRotation.getFirst();
            if (towerPos.f_45578_ != checkPos.f_45578_ || towerPos.f_45579_ != checkPos.f_45579_) continue;
            canSpawn = true;
            break;
        }
        if (canSpawn) {
            return Optional.of(new Structure.GenerationStub(checkPos.m_45615_(), structurePiecesBuilder -> new StructurePiecesBuilder()));
        }
        return Optional.empty();
    }

    @NotNull
    protected Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext generationContext) {
        ChunkPos chunkPos = generationContext.f_226628_();
        if (BTUtil.chunkDistanceTo(ChunkPos.f_186419_, chunkPos) < (Integer)BattleTowersConfig.firstTowerDistance.get()) {
            return Optional.empty();
        }
        int minimumSeparation = this.minimumSeperations.get(this.towerId);
        int seperationRange = this.averageSeperations.get(this.towerId);
        int nextSeperation = minimumSeparation + generationContext.f_226626_().m_188503_(seperationRange * 2);
        int closestDistance = 2000;
        if (!SaveTowers.towers.get(this.towerId).isEmpty()) {
            for (Pair<ChunkPos, Rotation> towerPosRotation : SaveTowers.towers.get(this.towerId)) {
                closestDistance = Math.min(closestDistance, BTUtil.chunkDistanceTo(chunkPos, (ChunkPos)towerPosRotation.getFirst()));
            }
        }
        if (closestDistance <= nextSeperation) {
            return Optional.empty();
        }
        Pair<Boolean, BlockPos> canSpawn = this.isSpawnableChunk(generationContext);
        Rotation rotation = Rotation.m_221990_((RandomSource)generationContext.f_226626_());
        if (((Boolean)canSpawn.getFirst()).booleanValue()) {
            this.saveTower((BlockPos)canSpawn.getSecond(), rotation);
            return Optional.of(new Structure.GenerationStub((BlockPos)canSpawn.getSecond(), piecesBuilder -> this.generatePieces((StructurePiecesBuilder)piecesBuilder, generationContext, (BlockPos)canSpawn.getSecond(), rotation)));
        }
        return Optional.empty();
    }

    protected void generatePieces(StructurePiecesBuilder piecesBuilder, Structure.GenerationContext generationContext, BlockPos blockPos, Rotation rotation) {
        String variant;
        LinkedList list = Lists.newLinkedList();
        try {
            variant = this.towerTypeConversion[this.towerType];
        }
        catch (IndexOutOfBoundsException e) {
            variant = "normal";
        }
        TowerPieces.generateTower(generationContext.f_226625_(), blockPos, rotation, list, (RandomSource)generationContext.f_226626_(), this.towerName, variant);
        list.forEach(arg_0 -> ((StructurePiecesBuilder)piecesBuilder).m_142679_(arg_0));
    }

    protected abstract Pair<Boolean, BlockPos> isSpawnableChunk(Structure.GenerationContext var1);

    public void saveTower(BlockPos spawnPos, Rotation rotation) {
        BABTMain.LOGGER.info("{} Tower at {} {}", new Object[]{this.towerName, spawnPos, new ChunkPos(spawnPos)});
        BABTMain.SAVE_TOWERS.addTower(new ChunkPos(spawnPos), rotation, this.towerId);
    }

    public void m_214110_(WorldGenLevel worldGenLevel, StructureManager structureManager, ChunkGenerator chunkGenerator, RandomSource randomSource, BoundingBox boundingBox, ChunkPos chunkPos, PiecesContainer piecesContainer) {
        super.m_214110_(worldGenLevel, structureManager, chunkGenerator, randomSource, boundingBox, chunkPos, piecesContainer);
        BoundingBox boundingbox = piecesContainer.m_192756_();
        int bbYStart = boundingbox.m_162396_();
        BlockPos chunckCenter = chunkPos.m_151394_(bbYStart);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        blockpos$mutableblockpos.m_142448_(bbYStart);
        int startX = chunckCenter.m_123341_() - 15;
        int endX = chunckCenter.m_123341_() + 15;
        int startZ = chunckCenter.m_123343_() - 15;
        int endZ = chunckCenter.m_123343_() + 15;
        List<BlockState> towerBlocks = BTStatics.towerBlocks.get(this.towerId);
        BlockState baseBlock = BTStatics.towerBaseBlocks.get(this.towerId);
        ArrayList<BlockPos> startPositions = new ArrayList<BlockPos>();
        for (int x = startX; x <= endX; ++x) {
            for (int z = startZ; z <= endZ; ++z) {
                blockpos$mutableblockpos.m_122178_(x, bbYStart, z);
                if (!towerBlocks.contains(worldGenLevel.m_8055_((BlockPos)blockpos$mutableblockpos))) continue;
                startPositions.add(new BlockPos(x, bbYStart - 1, z));
            }
        }
        block2: for (BlockPos startPos : startPositions) {
            for (int y = startPos.m_123342_(); y > worldGenLevel.m_141937_(); --y) {
                blockpos$mutableblockpos.m_122178_(startPos.m_123341_(), y, startPos.m_123343_());
                if (!(worldGenLevel.m_46859_((BlockPos)blockpos$mutableblockpos) || worldGenLevel.m_46801_((BlockPos)blockpos$mutableblockpos) || worldGenLevel.m_8055_((BlockPos)blockpos$mutableblockpos).m_60734_() instanceof TallGrassBlock || worldGenLevel.m_8055_((BlockPos)blockpos$mutableblockpos).m_60734_() instanceof FlowerBlock || worldGenLevel.m_8055_((BlockPos)blockpos$mutableblockpos).m_60734_() instanceof DeadBushBlock)) {
                    worldGenLevel.m_7731_((BlockPos)blockpos$mutableblockpos, baseBlock, 2);
                    worldGenLevel.m_7731_(blockpos$mutableblockpos.m_7495_(), baseBlock, 2);
                    continue block2;
                }
                worldGenLevel.m_7731_((BlockPos)blockpos$mutableblockpos, baseBlock, 2);
            }
        }
        startPositions.clear();
        List<BlockState> acceptableDirtBlocks = List.of(Blocks.f_50493_.m_49966_(), Blocks.f_152481_.m_49966_(), Blocks.f_50546_.m_49966_(), Blocks.f_152549_.m_49966_(), Blocks.f_49994_.m_49966_(), Blocks.f_50440_.m_49966_());
        List<BlockState> acceptableStoneBlocks = List.of(Blocks.f_50069_.m_49966_(), Blocks.f_49996_.m_49966_(), Blocks.f_49997_.m_49966_(), Blocks.f_50334_.m_49966_(), Blocks.f_50122_.m_49966_(), Blocks.f_50228_.m_49966_());
        for (int x = startX; x <= endX; ++x) {
            for (int z = startZ; z <= endZ; ++z) {
                blockpos$mutableblockpos.m_122178_(x, bbYStart + 3, z);
                BlockState state = worldGenLevel.m_8055_((BlockPos)blockpos$mutableblockpos);
                if (!acceptableDirtBlocks.contains(state) && !acceptableStoneBlocks.contains(state)) continue;
                startPositions.add(new BlockPos(x, bbYStart + 2, z));
            }
        }
        for (BlockPos startPos : startPositions) {
            for (int y = startPos.m_123342_(); y > worldGenLevel.m_141937_(); --y) {
                blockpos$mutableblockpos.m_122178_(startPos.m_123341_(), y, startPos.m_123343_());
                BlockState state = worldGenLevel.m_8055_(blockpos$mutableblockpos.m_7494_());
                if (!worldGenLevel.m_46859_((BlockPos)blockpos$mutableblockpos) && !worldGenLevel.m_46801_((BlockPos)blockpos$mutableblockpos)) continue;
                if (acceptableDirtBlocks.contains(state)) {
                    worldGenLevel.m_7731_((BlockPos)blockpos$mutableblockpos, Blocks.f_50493_.m_49966_(), 2);
                    continue;
                }
                worldGenLevel.m_7731_((BlockPos)blockpos$mutableblockpos, Blocks.f_50069_.m_49966_(), 2);
            }
        }
    }

    protected abstract boolean isValidBiome(Structure.GenerationContext var1, BlockPos var2, Holder<Biome> var3);

    public record BTStructureSettings(HolderSet<Structure> avoidStructures) {
        public static final MapCodec<BTStructureSettings> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)RegistryCodecs.m_206277_((ResourceKey)Registries.f_256944_).fieldOf("avoid_structures").forGetter(btStructureSettings -> btStructureSettings.avoidStructures)).apply((Applicative)instance, BTStructureSettings::new));
    }
}

