/*
 * Decompiled with CFR 0.152.
 */
package com.brass_amber.ba_bt.worldGen.structures;

import com.brass_amber.ba_bt.init.BTStructurePieces;
import com.brass_amber.ba_bt.worldGen.structures.TowerGenInfo;
import com.brass_amber.ba_bt.worldGen.structures.TowerProcessors;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraftforge.common.world.PieceBeardifierModifier;
import org.slf4j.Logger;

public class TowerPieces {
    static final Logger LOGGER = LogUtils.getLogger();

    public static void generateTower(StructureTemplateManager templateManager, BlockPos blockPos, Rotation rotation, List<TowerPiece> towerPieces, RandomSource randomSource, String towerName, String variant) {
        LOGGER.debug("Tower name: {} Variant: {}", (Object)towerName, (Object)variant);
        TowerGenInfo towerGenInfo = TowerGenInfo.getTypeForName(towerName);
        List<StructureProcessor> shellProcessors = TowerGenInfo.getShellProcessors(towerGenInfo, variant);
        List<StructureProcessor> variantProcessors = TowerGenInfo.getVariantProcessors(towerGenInfo, variant);
        ArrayList<StructureProcessor> oddFloorProcessors = new ArrayList<StructureProcessor>(shellProcessors);
        blockPos = blockPos.m_7918_(-14, 0, -14);
        towerPieces.add(new StartPiece(templateManager, "start", towerName, blockPos, rotation, ""));
        int floorHeight = TowerGenInfo.getFloorHeight(towerGenInfo);
        int doubledFloorHeight = floorHeight * 2;
        blockPos = switch (towerGenInfo) {
            case TowerGenInfo.OCEAN -> blockPos.m_7918_(0, floorHeight, 0);
            default -> blockPos.m_7918_(0, towerPieces.get(0).getHeight(), 0);
        };
        for (int i = 0; i < 4; ++i) {
            towerPieces.add(new ShellPiece(templateManager, "shell", towerName, blockPos.m_7918_(0, i * doubledFloorHeight, 0), rotation.m_55952_(Rotation.CLOCKWISE_180), "", shellProcessors, variantProcessors));
            towerPieces.add(new ShellPiece(templateManager, "shell", towerName, blockPos.m_7918_(0, floorHeight + i * doubledFloorHeight, 0), rotation, "", oddFloorProcessors, variantProcessors));
        }
        towerPieces.add(new TowerPiece(templateManager, "end", towerName, blockPos.m_7918_(0, floorHeight * 8, 0), rotation, ""));
        LOGGER.debug("{} placed shell", (Object)towerName);
        if (!variant.equals("normal")) {
            // empty if block
        }
        HashMap<String, Integer> usedRooms = new HashMap<String, Integer>();
        List<StructureProcessor> startFloorProcessors = switch (towerGenInfo) {
            case TowerGenInfo.LAND -> List.of(TowerProcessors.NORMAL_FLOOR_LAND);
            case TowerGenInfo.OCEAN -> List.of(TowerProcessors.WATERLOGGED);
            default -> List.of();
        };
        switch (towerGenInfo) {
            case OCEAN: {
                towerPieces.add(new RoomPiece(templateManager, "start_floor", towerName, blockPos, rotation.m_55952_(Rotation.CLOCKWISE_180), startFloorProcessors, 0));
                break;
            }
            default: {
                towerPieces.add(new RoomPiece(templateManager, "start_floor", towerName, blockPos, rotation, startFloorProcessors, 0));
            }
        }
        for (int i = 1; i < 7; ++i) {
            String roomName;
            int failSafe = 0;
            do {
                roomName = TowerGenInfo.getRandomRoom(towerGenInfo, randomSource);
                if (++failSafe > 80) {
                    roomName = towerGenInfo.getRooms().get(0);
                    break;
                }
                if (!usedRooms.isEmpty()) continue;
                usedRooms.put(roomName, 1);
            } while (usedRooms.getOrDefault(roomName, 0) == 2);
            if (usedRooms.getOrDefault(roomName, 0) < 2) {
                usedRooms.put(roomName, usedRooms.getOrDefault(roomName, 0) + 1);
            }
            Rotation roomRotation = (i & 1) == 0 ? rotation.m_55952_(Rotation.CLOCKWISE_180) : rotation;
            BlockPos roomPos = blockPos;
            towerPieces.add(new RoomPiece(templateManager, roomName, towerName, roomPos.m_7918_(0, i * floorHeight, 0), roomRotation, TowerGenInfo.getRoomProcessors(towerGenInfo, roomName), i));
        }
        List<StructureProcessor> endFloorProcessors = switch (towerGenInfo) {
            case TowerGenInfo.LAND -> List.of(TowerProcessors.CARPET_PLACER);
            case TowerGenInfo.OCEAN -> List.of(TowerProcessors.NORMAL_FLOOR_OCEAN);
            default -> List.of();
        };
        towerPieces.add(new RoomPiece(templateManager, "end_floor", towerName, blockPos.m_7918_(0, floorHeight * 7, 0), rotation, endFloorProcessors, 8));
        LOGGER.debug("{} placed floors", (Object)towerName);
    }

    public static class StartPiece
    extends TowerPiece
    implements PieceBeardifierModifier {
        public StartPiece(StructureTemplateManager templateManager, String templateName, String towerName, BlockPos blockPos, Rotation rotation, String variant) {
            super(templateManager, templateName, towerName, blockPos, rotation, variant);
            this.f_73657_.m_74383_(TowerProcessors.BASE_PROTECTED);
            switch (TowerGenInfo.getTypeForName(towerName)) {
                case OCEAN: {
                    this.f_73657_.m_74383_(TowerProcessors.NORMAL_OCEAN);
                    break;
                }
                default: {
                    this.f_73657_.m_74383_(TowerProcessors.NORMAL_LAND);
                }
            }
        }

        public BoundingBox getBeardifierBox() {
            return switch (TowerGenInfo.getTypeForName(this.towerName)) {
                case TowerGenInfo.LAND -> this.m_73547_();
                default -> this.m_73547_();
            };
        }

        public TerrainAdjustment getTerrainAdjustment() {
            return switch (TowerGenInfo.getTypeForName(this.towerName)) {
                case TowerGenInfo.LAND -> TerrainAdjustment.BURY;
                default -> TerrainAdjustment.NONE;
            };
        }

        public int getGroundLevelDelta() {
            Random rand = new Random();
            return switch (TowerGenInfo.getTypeForName(this.towerName)) {
                case TowerGenInfo.LAND -> rand.nextInt(0, 3);
                default -> 0;
            };
        }
    }

    public static class TowerPiece
    extends TemplateStructurePiece {
        protected String towerName;
        protected String variant;

        public TowerPiece(StructureTemplateManager templateManager, String templateName, String towerName, BlockPos blockPos, Rotation rotation, String variant) {
            super((StructurePieceType)BTStructurePieces.TOWER_PIECE.get(), 0, templateManager, TowerPiece.makeLocation(towerName, templateName, variant), templateName, TowerPiece.makeSettings(rotation), blockPos);
            this.towerName = towerName;
            this.variant = variant;
        }

        public TowerPiece(StructureTemplateManager templateManager, CompoundTag compoundTag) {
            super((StructurePieceType)BTStructurePieces.TOWER_PIECE.get(), compoundTag, templateManager, resourceLocation -> TowerPiece.makeSettings(Rotation.valueOf((String)compoundTag.m_128461_("Rotation"))));
            this.towerName = compoundTag.m_128461_("TowerName");
            this.variant = compoundTag.m_128461_("Variant");
        }

        public int getHeight() {
            return this.f_73656_.m_74633_(this.m_226913_(), this.f_73658_).m_71057_();
        }

        protected ResourceLocation m_142415_() {
            return TowerPiece.makeLocation(this.towerName, this.f_163658_, this.variant);
        }

        protected static ResourceLocation makeLocation(String towerName, String templateName, String variant) {
            if (variant == null || variant.isEmpty()) {
                return new ResourceLocation("ba_bt", towerName + "/" + templateName);
            }
            return new ResourceLocation("ba_bt", towerName + "/" + variant + "/" + templateName);
        }

        protected static StructurePlaceSettings makeSettings(Rotation rotation) {
            return new StructurePlaceSettings().m_74385_(new BlockPos(14, 0, 14)).m_74392_(false).m_74379_(rotation).m_74377_(Mirror.NONE).m_74383_((StructureProcessor)BlockIgnoreProcessor.f_74046_).m_74405_(true);
        }

        protected void m_183620_(StructurePieceSerializationContext serializationContext, CompoundTag compoundTag) {
            super.m_183620_(serializationContext, compoundTag);
            compoundTag.m_128359_("Rotation", this.f_73657_.m_74404_().name());
            compoundTag.m_128359_("TowerName", this.towerName);
            compoundTag.m_128359_("Variant", this.variant);
        }

        protected void m_213704_(String string, BlockPos blockPos, ServerLevelAccessor serverLevelAccessor, RandomSource randomSource, BoundingBox boundingBox) {
        }
    }

    public static class ShellPiece
    extends TowerPiece {
        public ShellPiece(StructureTemplateManager templateManager, String templateName, String towerName, BlockPos blockPos, Rotation rotation, String variant, List<StructureProcessor> shellProcessors, List<StructureProcessor> variantProcessors) {
            super(templateManager, templateName, towerName, blockPos, rotation, variant);
            for (StructureProcessor processor : shellProcessors) {
                this.f_73657_.m_74383_(processor);
            }
            for (StructureProcessor processor : variantProcessors) {
                this.f_73657_.m_74383_(processor);
            }
        }
    }

    public static class RoomPiece
    extends TowerPiece {
        public int towerlayer;

        public RoomPiece(StructureTemplateManager templateManager, String templateName, String towerName, BlockPos blockPos, Rotation rotation, List<StructureProcessor> proccessors, int towerLayer) {
            super(templateManager, templateName, towerName, blockPos, rotation, "normal");
            for (StructureProcessor processor : proccessors) {
                this.f_73657_.m_74383_(processor);
            }
            this.towerlayer = towerLayer;
        }

        public RoomPiece(StructureTemplateManager templateManager, CompoundTag compoundTag) {
            super(templateManager, compoundTag);
            this.towerlayer = compoundTag.m_128451_("TowerLayer");
        }
    }
}

