/*
 * Decompiled with CFR 0.152.
 */
package com.brass_amber.ba_bt.worldGen.structures;

import com.brass_amber.ba_bt.worldGen.structures.TowerProcessors;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;

public enum TowerGenInfo implements StringRepresentable
{
    EMPTY("", new String[0], List.of(new String[0], new String[0]), Collections.emptyList(), Collections.emptyList(), new String[0], new float[0], Collections.emptyList()),
    LAND("land_tower", new String[]{"normal", "overgrown", "sandy", "icy", "ruined"}, List.of(new String[0], new String[0], new String[0], new String[0], new String[0]), List.of(TowerProcessors.NORMAL_LAND, TowerProcessors.NORMAL_STAIRS_LAND, TowerProcessors.NORMAL_FLOOR_LAND), List.of(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList()), new String[]{"barracks_abandoned", "barracks_open", "barracks", "kitchen", "library"}, new float[]{0.05f, 0.15f, 0.15f, 0.3f, 0.2f}, List.of(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), List.of(TowerProcessors.CARPET_PLACER))),
    OCEAN("ocean_tower", new String[]{"normal", "gilded", "island"}, List.of(new String[0], new String[0], new String[0]), List.of(TowerProcessors.NORMAL_OCEAN, TowerProcessors.NORMAL_STAIRS_OCEAN, TowerProcessors.NORMAL_FLOOR_OCEAN, TowerProcessors.WATERLOGGED), List.of(Collections.emptyList(), Collections.emptyList(), Collections.emptyList()), new String[]{"garden", "guardian_nest", "shark_pens"}, new float[]{0.3f, 0.3f, 0.3f}, List.of(Collections.emptyList(), Collections.emptyList(), Collections.emptyList())),
    CORE("core_tower", new String[]{"normal", "frozen", "colossal"}, List.of(new String[0], new String[0], new String[0]), Collections.emptyList(), List.of(Collections.emptyList(), Collections.emptyList(), Collections.emptyList()), new String[0], new float[0], Collections.emptyList()),
    NETHER("nether_tower", new String[]{"normal", "crimson", "blue", "anomaly"}, List.of(new String[0], new String[0], new String[0], new String[0]), Collections.emptyList(), List.of(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList()), new String[0], new float[0], Collections.emptyList()),
    END("end_tower", new String[]{"normal", "disturbance", "city"}, List.of(new String[0], new String[0], new String[0]), Collections.emptyList(), List.of(Collections.emptyList(), Collections.emptyList(), Collections.emptyList()), new String[0], new float[0], Collections.emptyList()),
    SKY("sky_tower", new String[]{"normal", "village", "hanging_gardens"}, List.of(new String[0], new String[0], new String[0]), Collections.emptyList(), List.of(Collections.emptyList(), Collections.emptyList(), Collections.emptyList()), new String[0], new float[0], Collections.emptyList());

    private final String towerName;
    private final String[] variants;
    private final HashMap<String, String[]> shellOverwritePieces = new HashMap();
    private final List<StructureProcessor> shellProcessors;
    private final HashMap<String, List<StructureProcessor>> extraProcessors = new HashMap();
    private final ArrayList<String> rooms = new ArrayList();
    private final HashMap<String, List<StructureProcessor>> roomProcessors = new HashMap();

    private TowerGenInfo(String towerName, String[] variants, List<String[]> shellOverwritePieces, List<StructureProcessor> shellProcessors, List<List<StructureProcessor>> extraProcessors, String[] roomNames, float[] room_chances, List<List<StructureProcessor>> roomProcessors) {
        this.towerName = towerName;
        this.variants = variants;
        this.shellProcessors = shellProcessors;
        for (int i = 0; i < variants.length; ++i) {
            this.shellOverwritePieces.put(variants[i], shellOverwritePieces.get(i));
            this.extraProcessors.put(variants[i], extraProcessors.get(i));
        }
        int amount = 0;
        for (int i = 0; i < roomNames.length; ++i) {
            float percent = room_chances[i];
            amount = (int)(percent * 20.0f);
            for (int e = 0; e < amount; ++e) {
                this.rooms.add(roomNames[i]);
            }
            this.roomProcessors.put(roomNames[i], roomProcessors.get(i));
        }
    }

    public static String[] getShellOverwritePieces(TowerGenInfo towerGenInfo, String variant) {
        return towerGenInfo.shellOverwritePieces.get(variant);
    }

    public static ResourceLocation getRandomVariantShellPiece(TowerGenInfo towerGenInfo, String variant, RandomSource randomSource) {
        return new ResourceLocation("ba_bt", towerGenInfo.towerName + "/" + variant + "_" + TowerGenInfo.getShellOverwritePieces(towerGenInfo, variant)[randomSource.m_188503_(towerGenInfo.shellOverwritePieces.size())]);
    }

    public ArrayList<String> getRooms() {
        return this.rooms;
    }

    public static TowerGenInfo getTypeForName(String name) {
        return switch (name) {
            default -> EMPTY;
            case "land_tower" -> LAND;
            case "ocean_tower" -> OCEAN;
            case "core_tower" -> CORE;
            case "nether_tower" -> NETHER;
            case "end_tower" -> END;
            case "sky_tower" -> SKY;
        };
    }

    public static String getRandomRoom(TowerGenInfo towerGenInfo, RandomSource randomSource) {
        return towerGenInfo.rooms.get(randomSource.m_188503_(towerGenInfo.rooms.size()));
    }

    public static List<StructureProcessor> getRoomProcessors(TowerGenInfo towerGenInfo, String roomName) {
        return towerGenInfo.roomProcessors.get(roomName);
    }

    public static List<StructureProcessor> getShellProcessors(TowerGenInfo towerGenInfo, String variant) {
        return towerGenInfo.shellProcessors;
    }

    public static List<StructureProcessor> getVariantProcessors(TowerGenInfo towerGenInfo, String variant) {
        return towerGenInfo.extraProcessors.get(variant);
    }

    public static int getFloorHeight(TowerGenInfo towerGenInfo) {
        return switch (towerGenInfo) {
            case OCEAN -> -12;
            case CORE -> 9;
            case NETHER -> 10;
            case SKY -> 12;
            default -> 11;
        };
    }

    public String m_7912_() {
        return this.towerName;
    }

    public String[] getVariants() {
        return this.variants;
    }
}

