/*
 * Decompiled with CFR 0.152.
 */
package com.brass_amber.ba_bt.worldGen.structures;

import com.brass_amber.ba_bt.init.BTStructures;
import com.brass_amber.ba_bt.util.SaveTowers;
import com.brass_amber.ba_bt.worldGen.structures.TowerStructure;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraftforge.registries.ObjectHolder;

public class OceanTower
extends TowerStructure {
    @ObjectHolder(registryName="minecraft:configured_feature", value="minecraft:freeze_top_layer")
    public static final PlacedFeature freezeTopLayer = null;
    public static final Codec<OceanTower> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TowerStructure.m_226567_((RecordCodecBuilder.Instance)instance), TowerStructure.extraSettingsCodec()).apply((Applicative)instance, OceanTower::new)).codec();

    protected OceanTower(Structure.StructureSettings structureSettings, TowerStructure.BTStructureSettings extraSettings) {
        super(structureSettings, extraSettings);
        this.towerId = 1;
        this.towerName = "ocean_tower";
        this.towerTypeConversion = new String[]{"normal", "gilded", "island"};
    }

    @Override
    protected Pair<Boolean, BlockPos> isSpawnableChunk(Structure.GenerationContext generationContext) {
        ChunkPos chunkPos = generationContext.f_226628_();
        ChunkGenerator chunkGen = generationContext.f_226622_();
        int seaLevel = chunkGen.m_6337_();
        Pair pair = chunkGen.m_223037_(SaveTowers.server.m_129880_(Level.f_46428_), this.extraSettings.avoidStructures(), chunkPos.m_151394_(0), 3, false);
        if (pair != null) {
            return Pair.of((Object)false, (Object)BlockPos.f_121853_);
        }
        ArrayList<ChunkPos> testable = new ArrayList<ChunkPos>(List.of(new ChunkPos(chunkPos.f_45578_ + 4, chunkPos.f_45579_ + 2), new ChunkPos(chunkPos.f_45578_ + 3, chunkPos.f_45579_ + 3), new ChunkPos(chunkPos.f_45578_ + 2, chunkPos.f_45579_ + 4), new ChunkPos(chunkPos.f_45578_ - 2, chunkPos.f_45579_ + 4), new ChunkPos(chunkPos.f_45578_ - 3, chunkPos.f_45579_ + 3), new ChunkPos(chunkPos.f_45578_ - 4, chunkPos.f_45579_ + 2), new ChunkPos(chunkPos.f_45578_ - 4, chunkPos.f_45579_ - 2), new ChunkPos(chunkPos.f_45578_ - 3, chunkPos.f_45579_ - 3), new ChunkPos(chunkPos.f_45578_ - 2, chunkPos.f_45579_ - 4), new ChunkPos(chunkPos.f_45578_ + 2, chunkPos.f_45579_ - 4), new ChunkPos(chunkPos.f_45578_ + 3, chunkPos.f_45579_ - 3), new ChunkPos(chunkPos.f_45578_ + 4, chunkPos.f_45579_ - 2), new ChunkPos(chunkPos.f_45578_ + 3, chunkPos.f_45579_ + 1), new ChunkPos(chunkPos.f_45578_ + 2, chunkPos.f_45579_ + 2), new ChunkPos(chunkPos.f_45578_ + 1, chunkPos.f_45579_ + 3), new ChunkPos(chunkPos.f_45578_ - 1, chunkPos.f_45579_ + 3), new ChunkPos(chunkPos.f_45578_ - 2, chunkPos.f_45579_ + 2), new ChunkPos(chunkPos.f_45578_ - 3, chunkPos.f_45579_ + 1), new ChunkPos(chunkPos.f_45578_ - 3, chunkPos.f_45579_ - 1), new ChunkPos(chunkPos.f_45578_ - 2, chunkPos.f_45579_ - 2), new ChunkPos(chunkPos.f_45578_ - 1, chunkPos.f_45579_ - 3), new ChunkPos(chunkPos.f_45578_ + 1, chunkPos.f_45579_ - 3), new ChunkPos(chunkPos.f_45578_ + 2, chunkPos.f_45579_ - 2), new ChunkPos(chunkPos.f_45578_ + 3, chunkPos.f_45579_ - 1)));
        for (ChunkPos pos : testable) {
            Holder biome = generationContext.f_226623_().m_203407_(QuartPos.m_175400_((int)pos.m_151390_()), QuartPos.m_175400_((int)seaLevel), QuartPos.m_175400_((int)pos.m_151393_()), generationContext.f_226624_().m_224579_());
            if (this.isValidBiome(generationContext, chunkPos.m_151394_(seaLevel), (Holder<Biome>)biome)) continue;
            return Pair.of((Object)false, (Object)BlockPos.f_121853_);
        }
        return Pair.of((Object)true, (Object)chunkPos.m_151394_(seaLevel));
    }

    @Override
    protected boolean isValidBiome(Structure.GenerationContext context, BlockPos blockpos, Holder<Biome> biomeHolder) {
        if (context.f_226626_().m_188501_() < 25.0f) {
            this.towerType = (double)context.f_226626_().m_188501_() > 0.6 ? 2 : 1;
        }
        return context.f_226630_().test(biomeHolder);
    }

    public StructureType<?> m_213658_() {
        return (StructureType)BTStructures.OCEAN_TOWER.get();
    }
}

