/*
 * Decompiled with CFR 0.152.
 */
package com.brass_amber.ba_bt.worldGen.structures;

import com.brass_amber.ba_bt.BABTMain;
import com.brass_amber.ba_bt.init.BTStructures;
import com.brass_amber.ba_bt.util.SaveTowers;
import com.brass_amber.ba_bt.worldGen.structures.TowerStructure;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraftforge.registries.ObjectHolder;

public class LandTower
extends TowerStructure {
    @ObjectHolder(registryName="minecraft:configured_feature", value="minecraft:freeze_top_layer")
    public static final PlacedFeature freezeTopLayer = null;
    public static final Codec<LandTower> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TowerStructure.m_226567_((RecordCodecBuilder.Instance)instance), TowerStructure.extraSettingsCodec()).apply((Applicative)instance, LandTower::new)).codec();

    protected LandTower(Structure.StructureSettings structureSettings, TowerStructure.BTStructureSettings extraSettings) {
        super(structureSettings, extraSettings);
        this.towerId = 0;
        this.towerName = "land_tower";
        this.towerTypeConversion = new String[]{"normal", "overgrown", "sandy", "icy", "ruined"};
    }

    @Override
    protected Pair<Boolean, BlockPos> isSpawnableChunk(Structure.GenerationContext generationContext) {
        WorldgenRandom worldgenRandom = generationContext.f_226626_();
        ChunkPos chunkPos = generationContext.f_226628_();
        ChunkGenerator chunkGen = generationContext.f_226622_();
        Pair pair = chunkGen.m_223037_(SaveTowers.server.m_129880_(Level.f_46428_), this.extraSettings.avoidStructures(), chunkPos.m_151394_(0), 3, false);
        if (pair != null) {
            return Pair.of((Object)false, (Object)BlockPos.f_121853_);
        }
        ArrayList<ChunkPos> testables = new ArrayList<ChunkPos>(List.of(chunkPos, new ChunkPos(chunkPos.f_45578_ + 1, chunkPos.f_45579_ + 1), new ChunkPos(chunkPos.f_45578_ + 1, chunkPos.f_45579_ - 1), new ChunkPos(chunkPos.f_45578_ - 1, chunkPos.f_45579_ - 1), new ChunkPos(chunkPos.f_45578_ - 1, chunkPos.f_45579_ + 1)));
        ArrayList<ChunkPos> usablePositions = new ArrayList<ChunkPos>();
        ArrayList<Integer> usableHeights = new ArrayList<Integer>();
        ArrayList<Boolean> hasLiquid = new ArrayList<Boolean>();
        ArrayList<Integer> towerTypes = new ArrayList<Integer>();
        for (ChunkPos pos : testables) {
            boolean watered;
            int middleHieght = chunkGen.m_223235_(pos.m_151390_(), pos.m_151393_(), Heightmap.Types.WORLD_SURFACE_WG, generationContext.f_226629_(), generationContext.f_226624_());
            Holder biome = generationContext.f_226623_().m_203407_(QuartPos.m_175400_((int)pos.m_151390_()), QuartPos.m_175400_((int)middleHieght), QuartPos.m_175400_((int)pos.m_151393_()), generationContext.f_226624_().m_224579_());
            if (!this.isValidBiome(generationContext, chunkPos.m_151394_(middleHieght), (Holder<Biome>)biome)) continue;
            int lowestY = 215;
            int highestY = 0;
            hasLiquid.clear();
            int minX = pos.m_45604_();
            int minZ = pos.m_45605_();
            for (int x = 0; x < 6; ++x) {
                for (int z = 0; z < 6; ++z) {
                    int newX = minX + x * 3;
                    int newZ = minZ + z * 3;
                    int newLandHeight = chunkGen.m_223235_(newX, newZ, Heightmap.Types.WORLD_SURFACE_WG, generationContext.f_226629_(), generationContext.f_226624_());
                    lowestY = Math.min(newLandHeight, lowestY);
                    highestY = Math.max(newLandHeight, highestY);
                    NoiseColumn columnOfBlocks = chunkGen.m_214184_(newX, newZ, generationContext.f_226629_(), generationContext.f_226624_());
                    BlockState topBlock = columnOfBlocks.m_183556_(newLandHeight);
                    if (!(topBlock.m_60734_() instanceof LiquidBlock)) continue;
                    hasLiquid.add(Boolean.TRUE);
                }
            }
            if (highestY > 215) {
                BABTMain.LOGGER.info("Terrain to high for Land Tower");
                continue;
            }
            boolean isFlat = highestY - lowestY <= 12;
            boolean bl = watered = hasLiquid.size() >= 16;
            if (watered && this.towerType != 1) {
                return Pair.of((Object)false, (Object)BlockPos.f_121853_);
            }
            int usableHeight = lowestY + (highestY - lowestY) / 4;
            if (!isFlat) continue;
            usablePositions.add(pos);
            towerTypes.add(this.towerType);
            usableHeights.add(usableHeight);
        }
        if (!usablePositions.isEmpty()) {
            int i = worldgenRandom.m_188503_(usablePositions.size());
            this.towerType = (Integer)towerTypes.get(i);
            return Pair.of((Object)true, (Object)((ChunkPos)usablePositions.get(i)).m_151394_(((Integer)usableHeights.get(i)).intValue()));
        }
        return Pair.of((Object)false, (Object)BlockPos.f_121853_);
    }

    @Override
    protected boolean isValidBiome(Structure.GenerationContext context, BlockPos blockpos, Holder<Biome> biomeHolder) {
        Biome biome = (Biome)biomeHolder.get();
        boolean coldEnoughToSnow = biome.m_198904_(blockpos);
        float temperature = biome.m_47554_();
        BlockState topblock = context.f_226622_().m_214184_(blockpos.m_123341_(), blockpos.m_123343_(), context.f_226629_(), context.f_226624_()).m_183556_(blockpos.m_123342_());
        this.towerType = (double)temperature > 0.8 && (double)biome.getModifiedClimateSettings().f_47683_() >= 0.8 && biome.m_264473_() ? 1 : ((double)temperature > 1.8 && !biome.m_264473_() && topblock.m_60734_() instanceof FallingBlock ? 2 : (coldEnoughToSnow && biome.m_264473_() && biome.m_47536_().m_186658_(freezeTopLayer) ? 3 : (context.f_226626_().m_188503_(50) > 7 ? 0 : 4)));
        return true;
    }

    public StructureType<?> m_213658_() {
        return (StructureType)BTStructures.LAND_TOWER.get();
    }
}

