/*
 * Decompiled with CFR 0.152.
 */
package com.brass_amber.ba_bt.util;

import com.brass_amber.ba_bt.util.GolemType;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;

public enum TowerSpecs implements StringRepresentable
{
    EMPTY(null, 0, 0, ""),
    LAND("land", 101, 2, "#9BDAE7"),
    OCEAN("ocean", 114, 2, "#EAE78A"),
    NETHER("core", 112, 2, "#88EB63"),
    CORE("nether", 112, 1, "#F79B3A"),
    END("end", 112, 1, "#BA49EF"),
    SKY("sky", 112, 1, "#FBC1EB");

    private final Component name;
    private final int height;
    private final int crumbleSpeed;
    private final String colorCode;
    private final Component defeat1 = Component.m_237115_((String)"title.ba_bt.guardian_defeated_1");
    private final Component defeat2;
    private final Component defeat3;

    private TowerSpecs(String baseName, int height, int crumbleSpeed, String colorCode) {
        this.name = Component.m_237115_((String)("title.ba_bt." + baseName));
        this.height = height;
        this.crumbleSpeed = crumbleSpeed;
        this.colorCode = colorCode;
        this.defeat2 = Component.m_237115_((String)("title.ba_bt." + baseName + "_defeated_2"));
        this.defeat3 = Component.m_237115_((String)("title.ba_bt." + baseName + "_defeated_3"));
    }

    public int getCrumbleSpeed() {
        return this.crumbleSpeed;
    }

    public int getHeight() {
        return this.height;
    }

    public String getColorCode() {
        return this.colorCode;
    }

    public String getTitleText1() {
        return this.name.getString() + " " + this.defeat1.getString();
    }

    public String getTitleText2() {
        return this.defeat2.getString();
    }

    public String getTitleText3() {
        return this.defeat3.getString();
    }

    public static TowerSpecs getTowerFromGolem(GolemType golemType) {
        if (golemType != null) {
            if (golemType.equals((Object)GolemType.LAND)) {
                return LAND;
            }
            if (golemType.equals((Object)GolemType.OCEAN)) {
                return OCEAN;
            }
            if (golemType.equals((Object)GolemType.NETHER)) {
                return NETHER;
            }
            if (golemType.equals((Object)GolemType.CORE)) {
                return CORE;
            }
            if (golemType.equals((Object)GolemType.END)) {
                return END;
            }
            if (golemType.equals((Object)GolemType.SKY)) {
                return SKY;
            }
        }
        return EMPTY;
    }

    @NotNull
    public String m_7912_() {
        return this.name.getString();
    }
}

