/*
 * Decompiled with CFR 0.152.
 */
package com.brass_amber.ba_bt.util;

import com.brass_amber.ba_bt.BABTMain;
import com.mojang.datafixers.util.Pair;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.io.FileUtils;

public class SaveTowers {
    public static ArrayList<Pair<ChunkPos, Rotation>> landTowers = new ArrayList();
    public static ArrayList<Pair<ChunkPos, Rotation>> oceanTowers = new ArrayList();
    public static List<List<Pair<ChunkPos, Rotation>>> towers = List.of(landTowers, oceanTowers);
    public static List<String> towerNames = List.of("land_tower", "ocean_tower");
    public static MinecraftServer server;
    public static Path levelPath;

    public void setServer(MinecraftServer newServer) {
        BABTMain.LOGGER.info("Server: {}", (Object)newServer);
        server = newServer;
        towers.get(0).clear();
        towers.get(1).clear();
        this.getTowers();
    }

    public void serverClosed() {
        this.writeData();
    }

    private void writeData() {
        for (int i = 0; i < towerNames.size(); ++i) {
            String name = towerNames.get(i);
            File towerFile = levelPath.resolve(name).toFile();
            ArrayList<CallSite> towerStrings = new ArrayList<CallSite>();
            for (Pair<ChunkPos, Rotation> xzr : towers.get(towerNames.indexOf(name))) {
                ChunkPos xz = (ChunkPos)xzr.getFirst();
                Rotation r = (Rotation)xzr.getSecond();
                towerStrings.add((CallSite)((Object)(xz.f_45578_ + "," + xz.f_45579_ + "," + r.name())));
            }
            try {
                FileUtils.writeLines((File)towerFile, towerStrings);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void getTowers() {
        levelPath = FMLPaths.getOrCreateGameRelativePath((Path)server.m_129843_(LevelResource.f_78182_).resolve("battletowers"));
        for (int i = 0; i < towerNames.size(); ++i) {
            Path towerPath = levelPath.resolve(towerNames.get(i));
            List<Object> lines = new ArrayList();
            try {
                lines = Files.readAllLines(towerPath, StandardCharsets.UTF_8);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            for (String line : lines) {
                String[] xzr = line.split(",");
                towers.get(i).add((Pair<ChunkPos, Rotation>)Pair.of((Object)new ChunkPos(Integer.parseInt(xzr[0]), Integer.parseInt(xzr[1])), (Object)Rotation.valueOf((String)xzr[2])));
            }
        }
    }

    public Rotation getTowerRotation(int towerId, ChunkPos pos) {
        for (Pair<ChunkPos, Rotation> xzr : towers.get(towerId)) {
            ChunkPos xz = (ChunkPos)xzr.getFirst();
            Rotation r = (Rotation)xzr.getSecond();
            if (xz.f_45578_ != pos.f_45578_ || xz.f_45579_ != pos.f_45579_) continue;
            return r;
        }
        return Rotation.NONE;
    }

    public void addTower(ChunkPos pos, Rotation rotation, int towerId) {
        towers.get(towerId).add((Pair<ChunkPos, Rotation>)Pair.of((Object)pos, (Object)rotation));
        this.writeData();
    }

    static {
        levelPath = Path.of("", new String[0]);
    }
}

