/*
 * Decompiled with CFR 0.152.
 */
package com.brass_amber.ba_bt.util;

import com.brass_amber.ba_bt.BattleTowersConfig;
import com.brass_amber.ba_bt.block.blockentity.BTChestBlockEntity;
import com.brass_amber.ba_bt.entity.LandDestructionEntity;
import com.brass_amber.ba_bt.entity.OceanDestructionEntity;
import com.brass_amber.ba_bt.entity.block.BTAbstractObelisk;
import com.brass_amber.ba_bt.entity.block.BTMonolith;
import com.brass_amber.ba_bt.entity.hostile.BTCultist;
import com.brass_amber.ba_bt.init.BTBlockEntityType;
import com.brass_amber.ba_bt.init.BTBlocks;
import com.brass_amber.ba_bt.init.BTEntityType;
import com.brass_amber.ba_bt.init.BTItems;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.entity.monster.MagmaCube;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.jetbrains.annotations.NotNull;

public enum GolemType implements StringRepresentable
{
    EMPTY("empty", (Component)Component.m_237113_((String)"Empty")),
    LAND("land", (Component)Component.m_237115_((String)"entity.ba_bt.land_golem")),
    OCEAN("ocean", (Component)Component.m_237115_((String)"entity.ba_bt.ocean_golem")),
    CORE("core", (Component)Component.m_237115_((String)"entity.ba_bt.core_golem")),
    NETHER("nether", (Component)Component.m_237115_((String)"entity.ba_bt.nether_golem")),
    END("end", (Component)Component.m_237115_((String)"entity.ba_bt.end_golem")),
    SKY("sky", (Component)Component.m_237115_((String)"entity.ba_bt.sky_golem")),
    CITY("city", (Component)Component.m_237113_((String)"~"));

    private final String name;
    private final Component displayName;
    public static final GolemType[] VALUES;

    private GolemType(String name, Component displayName) {
        this.name = name;
        this.displayName = displayName;
    }

    @NotNull
    public static EntityType<?> getGolemFor(GolemType golemType) {
        return switch (golemType) {
            default -> throw new IncompatibleClassChangeError();
            case EMPTY, CITY, LAND -> (EntityType)BTEntityType.LAND_GOLEM.get();
            case OCEAN -> (EntityType)BTEntityType.OCEAN_GOLEM.get();
            case CORE -> (EntityType)BTEntityType.CORE_GOLEM.get();
            case NETHER -> (EntityType)BTEntityType.NETHER_GOLEM.get();
            case END -> (EntityType)BTEntityType.END_GOLEM.get();
            case SKY -> (EntityType)BTEntityType.SKY_GOLEM.get();
        };
    }

    @NotNull
    public static EntityType<BTMonolith> getMonolithFor(GolemType golemType) {
        return switch (golemType) {
            default -> throw new IncompatibleClassChangeError();
            case EMPTY, CITY, LAND -> (EntityType)BTEntityType.LAND_MONOLITH.get();
            case OCEAN -> (EntityType)BTEntityType.OCEAN_MONOLITH.get();
            case CORE -> (EntityType)BTEntityType.CORE_MONOLITH.get();
            case NETHER -> (EntityType)BTEntityType.NETHER_MONOLITH.get();
            case END -> (EntityType)BTEntityType.END_MONOLITH.get();
            case SKY -> (EntityType)BTEntityType.SKY_MONOLITH.get();
        };
    }

    @NotNull
    public static EntityType<BTAbstractObelisk> getObeliskFor(GolemType golemType) {
        return switch (golemType) {
            default -> throw new IncompatibleClassChangeError();
            case EMPTY, CITY, LAND -> (EntityType)BTEntityType.LAND_OBELISK.get();
            case OCEAN -> (EntityType)BTEntityType.OCEAN_OBELISK.get();
            case CORE -> (EntityType)BTEntityType.CORE_OBELISK.get();
            case NETHER -> (EntityType)BTEntityType.NETHER_OBELISK.get();
            case END -> (EntityType)BTEntityType.END_OBELISK.get();
            case SKY -> (EntityType)BTEntityType.SKY_OBELISK.get();
        };
    }

    @NotNull
    public static GolemType getTypeForObelisk(BTAbstractObelisk entity) {
        EntityType entityType = entity.m_6095_();
        if (entityType.equals(BTEntityType.LAND_OBELISK.get())) {
            return LAND;
        }
        if (entityType.equals(BTEntityType.OCEAN_OBELISK.get())) {
            return OCEAN;
        }
        if (entityType.equals(BTEntityType.CORE_OBELISK.get())) {
            return CORE;
        }
        if (entityType.equals(BTEntityType.NETHER_OBELISK.get())) {
            return NETHER;
        }
        if (entityType.equals(BTEntityType.END_OBELISK.get())) {
            return END;
        }
        if (entityType.equals(BTEntityType.SKY_OBELISK.get())) {
            return SKY;
        }
        return EMPTY;
    }

    public static Item getMonolithItemFor(GolemType golemType) {
        return switch (golemType) {
            default -> (Item)BTItems.LAND_MONOLITH.get();
            case OCEAN -> (Item)BTItems.OCEAN_MONOLITH.get();
            case CORE -> (Item)BTItems.CORE_MONOLITH.get();
            case NETHER -> (Item)BTItems.NETHER_MONOLITH.get();
            case END -> (Item)BTItems.END_MONOLITH.get();
            case SKY -> (Item)BTItems.SKY_MONOLITH.get();
        };
    }

    public static GolemType getTypeForMonolith(BTMonolith BTMonolithEntity) {
        EntityType<?> entityType = BTMonolithEntity.getMonolithType();
        if (entityType != null) {
            if (entityType.equals(BTEntityType.LAND_MONOLITH.get())) {
                return LAND;
            }
            if (entityType.equals(BTEntityType.OCEAN_MONOLITH.get())) {
                return OCEAN;
            }
            if (entityType.equals(BTEntityType.CORE_MONOLITH.get())) {
                return CORE;
            }
            if (entityType.equals(BTEntityType.NETHER_MONOLITH.get())) {
                return NETHER;
            }
            if (entityType.equals(BTEntityType.END_MONOLITH.get())) {
                return END;
            }
            if (entityType.equals(BTEntityType.SKY_MONOLITH.get())) {
                return SKY;
            }
        }
        return EMPTY;
    }

    public static GolemType getTypeForChest(BlockEntityType<? extends BTChestBlockEntity> blockEntityType) {
        if (((BlockEntityType)BTBlockEntityType.LAND_CHEST.get()).equals(blockEntityType) || ((BlockEntityType)BTBlockEntityType.LAND_GOLEM_CHEST.get()).equals(blockEntityType)) {
            return LAND;
        }
        if (((BlockEntityType)BTBlockEntityType.OCEAN_CHEST.get()).equals(blockEntityType) || ((BlockEntityType)BTBlockEntityType.OCEAN_GOLEM_CHEST.get()).equals(blockEntityType)) {
            return OCEAN;
        }
        if (((BlockEntityType)BTBlockEntityType.CORE_CHEST.get()).equals(blockEntityType) || ((BlockEntityType)BTBlockEntityType.CORE_GOLEM_CHEST.get()).equals(blockEntityType)) {
            return CORE;
        }
        if (((BlockEntityType)BTBlockEntityType.NETHER_CHEST.get()).equals(blockEntityType) || ((BlockEntityType)BTBlockEntityType.NETHER_GOLEM_CHEST.get()).equals(blockEntityType)) {
            return NETHER;
        }
        if (((BlockEntityType)BTBlockEntityType.END_CHEST.get()).equals(blockEntityType) || ((BlockEntityType)BTBlockEntityType.END_GOLEM_CHEST.get()).equals(blockEntityType)) {
            return END;
        }
        if (((BlockEntityType)BTBlockEntityType.SKY_CHEST.get()).equals(blockEntityType) || ((BlockEntityType)BTBlockEntityType.SKY_GOLEM_CHEST.get()).equals(blockEntityType)) {
            return SKY;
        }
        return EMPTY;
    }

    public static GolemType getTypeForChest(Block block) {
        if (((Block)BTBlocks.LAND_CHEST.get()).equals(block) || ((Block)BTBlocks.LAND_GOLEM_CHEST.get()).equals(block)) {
            return LAND;
        }
        if (((Block)BTBlocks.OCEAN_CHEST.get()).equals(block) || ((Block)BTBlocks.OCEAN_GOLEM_CHEST.get()).equals(block)) {
            return OCEAN;
        }
        if (((Block)BTBlocks.CORE_CHEST.get()).equals(block) || ((Block)BTBlocks.CORE_GOLEM_CHEST.get()).equals(block)) {
            return CORE;
        }
        if (((Block)BTBlocks.NETHER_CHEST.get()).equals(block) || ((Block)BTBlocks.NETHER_GOLEM_CHEST.get()).equals(block)) {
            return NETHER;
        }
        if (((Block)BTBlocks.END_CHEST.get()).equals(block) || ((Block)BTBlocks.END_GOLEM_CHEST.get()).equals(block)) {
            return END;
        }
        if (((Block)BTBlocks.SKY_CHEST.get()).equals(block) || ((Block)BTBlocks.SKY_GOLEM_CHEST.get()).equals(block)) {
            return SKY;
        }
        return EMPTY;
    }

    public static BlockEntityType<? extends BTChestBlockEntity> getChestForType(GolemType golemType, boolean golemChest) {
        if (golemChest) {
            return switch (golemType) {
                case OCEAN -> (BlockEntityType)BTBlockEntityType.OCEAN_GOLEM_CHEST.get();
                case CORE -> (BlockEntityType)BTBlockEntityType.CORE_GOLEM_CHEST.get();
                case NETHER -> (BlockEntityType)BTBlockEntityType.NETHER_GOLEM_CHEST.get();
                case END -> (BlockEntityType)BTBlockEntityType.END_GOLEM_CHEST.get();
                case SKY -> (BlockEntityType)BTBlockEntityType.SKY_GOLEM_CHEST.get();
                default -> (BlockEntityType)BTBlockEntityType.LAND_GOLEM_CHEST.get();
            };
        }
        return switch (golemType) {
            case OCEAN -> (BlockEntityType)BTBlockEntityType.OCEAN_CHEST.get();
            case CORE -> (BlockEntityType)BTBlockEntityType.CORE_CHEST.get();
            case NETHER -> (BlockEntityType)BTBlockEntityType.NETHER_CHEST.get();
            case END -> (BlockEntityType)BTBlockEntityType.END_CHEST.get();
            case SKY -> (BlockEntityType)BTBlockEntityType.SKY_CHEST.get();
            default -> (BlockEntityType)BTBlockEntityType.LAND_CHEST.get();
        };
    }

    public static boolean isGolemChest(BlockEntityType<?> blockEntityType) {
        return ((BlockEntityType)BTBlockEntityType.LAND_GOLEM_CHEST.get()).equals(blockEntityType) || ((BlockEntityType)BTBlockEntityType.OCEAN_GOLEM_CHEST.get()).equals(blockEntityType) || ((BlockEntityType)BTBlockEntityType.CORE_GOLEM_CHEST.get()).equals(blockEntityType) || ((BlockEntityType)BTBlockEntityType.NETHER_GOLEM_CHEST.get()).equals(blockEntityType) || ((BlockEntityType)BTBlockEntityType.END_GOLEM_CHEST.get()).equals(blockEntityType) || ((BlockEntityType)BTBlockEntityType.SKY_GOLEM_CHEST.get()).equals(blockEntityType);
    }

    public static boolean isGolemChest(Block block) {
        return ((Block)BTBlocks.LAND_GOLEM_CHEST.get()).equals(block) || ((Block)BTBlocks.OCEAN_GOLEM_CHEST.get()).equals(block) || ((Block)BTBlocks.CORE_GOLEM_CHEST.get()).equals(block) || ((Block)BTBlocks.NETHER_GOLEM_CHEST.get()).equals(block) || ((Block)BTBlocks.END_GOLEM_CHEST.get()).equals(block) || ((Block)BTBlocks.SKY_GOLEM_CHEST.get()).equals(block);
    }

    public static Block getChestBlockForType(GolemType golemType, boolean golemChest) {
        if (golemChest) {
            return switch (golemType) {
                case OCEAN -> (Block)BTBlocks.OCEAN_GOLEM_CHEST.get();
                case CORE -> (Block)BTBlocks.CORE_GOLEM_CHEST.get();
                case NETHER -> (Block)BTBlocks.NETHER_GOLEM_CHEST.get();
                case END -> (Block)BTBlocks.END_GOLEM_CHEST.get();
                case SKY -> (Block)BTBlocks.SKY_GOLEM_CHEST.get();
                default -> (Block)BTBlocks.LAND_GOLEM_CHEST.get();
            };
        }
        return switch (golemType) {
            case OCEAN -> (Block)BTBlocks.OCEAN_CHEST.get();
            case CORE -> (Block)BTBlocks.CORE_CHEST.get();
            case NETHER -> (Block)BTBlocks.NETHER_CHEST.get();
            case END -> (Block)BTBlocks.END_CHEST.get();
            case SKY -> (Block)BTBlocks.SKY_CHEST.get();
            default -> (Block)BTBlocks.LAND_CHEST.get();
        };
    }

    @Nullable
    public static Item getEyeFor(GolemType golemType) {
        return switch (golemType) {
            default -> throw new IncompatibleClassChangeError();
            case EMPTY, CITY -> null;
            case LAND -> (Item)BTItems.LAND_GUARDIAN_EYE.get();
            case OCEAN -> (Item)BTItems.OCEAN_GUARDIAN_EYE.get();
            case CORE -> (Item)BTItems.CORE_GUARDIAN_EYE.get();
            case NETHER -> (Item)BTItems.NETHER_GUARDIAN_EYE.get();
            case END -> (Item)BTItems.END_GUARDIAN_EYE.get();
            case SKY -> (Item)BTItems.SKY_GUARDIAN_EYE.get();
        };
    }

    public static GolemType getPreviousGolemType(GolemType golemType) {
        return switch (golemType) {
            case OCEAN -> LAND;
            case CORE -> OCEAN;
            case NETHER -> CORE;
            case END -> NETHER;
            case SKY -> END;
            default -> EMPTY;
        };
    }

    @Nullable
    public static Item getKeyFor(GolemType golemType) {
        return switch (golemType) {
            case LAND -> (Item)BTItems.LAND_MONOLITH_KEY.get();
            case OCEAN -> (Item)BTItems.OCEAN_MONOLITH_KEY.get();
            case CORE -> (Item)BTItems.CORE_MONOLITH_KEY.get();
            case NETHER -> (Item)BTItems.NETHER_MONOLITH_KEY.get();
            case END -> (Item)BTItems.END_MONOLITH_KEY.get();
            case SKY -> (Item)BTItems.SKY_MONOLITH_KEY.get();
            default -> null;
        };
    }

    public static GolemType getTypeForName(String name) {
        return switch (name) {
            case "land" -> LAND;
            case "ocean" -> OCEAN;
            case "core" -> CORE;
            case "nether" -> NETHER;
            case "end" -> END;
            case "sky" -> SKY;
            case "city" -> CITY;
            default -> EMPTY;
        };
    }

    public static Entity getDestructionEntity(GolemType golemType, Level level, BlockPos blockPos) {
        Entity destruction = null;
        switch (golemType) {
            case LAND: {
                destruction = new LandDestructionEntity(blockPos, level);
                blockPos = blockPos.m_6630_(6);
                break;
            }
            case OCEAN: {
                destruction = new OceanDestructionEntity(level);
                blockPos = blockPos.m_175288_(level.m_5736_() - 88);
                break;
            }
        }
        if (destruction != null) {
            destruction.m_6034_((double)blockPos.m_123341_() + 0.25, (double)blockPos.m_123342_(), (double)blockPos.m_123343_() + 0.25);
        }
        return destruction;
    }

    public static String getTowerChestPool(GolemType golemType, int index) {
        return switch (golemType) {
            case LAND -> (String)((List)BattleTowersConfig.landTowerChestPools.get()).get(index);
            case OCEAN -> (String)((List)BattleTowersConfig.oceanTowerChestPools.get()).get(index);
            case CORE -> (String)((List)BattleTowersConfig.coreTowerChestPools.get()).get(index);
            case NETHER -> (String)((List)BattleTowersConfig.netherTowerChestPools.get()).get(index);
            case END -> (String)((List)BattleTowersConfig.endTowerChestPools.get()).get(index);
            case SKY -> (String)((List)BattleTowersConfig.skyTowerChestPools.get()).get(index);
            default -> "";
        };
    }

    public static Entity getSpecialEnemy(GolemType golemType, ServerLevel serverLevel) {
        return switch (golemType) {
            case LAND -> (BTCultist)((EntityType)BTEntityType.BT_CULTIST.get()).m_20615_((Level)serverLevel);
            case OCEAN -> (Guardian)EntityType.f_20455_.m_20615_((Level)serverLevel);
            case CORE -> (MagmaCube)EntityType.f_20468_.m_20615_((Level)serverLevel);
            case NETHER -> (WitherSkeleton)EntityType.f_20497_.m_20615_((Level)serverLevel);
            case END -> (EnderMan)EntityType.f_20566_.m_20615_((Level)serverLevel);
            case SKY -> (Skeleton)EntityType.f_20524_.m_20615_((Level)serverLevel);
            default -> null;
        };
    }

    public static EntityType<?> getSpecialEnemyType(GolemType golemType) {
        return switch (golemType) {
            case LAND -> (EntityType)BTEntityType.BT_CULTIST.get();
            case OCEAN -> EntityType.f_20455_;
            case CORE -> EntityType.f_20468_;
            case NETHER -> EntityType.f_20497_;
            case END -> EntityType.f_20566_;
            case SKY -> EntityType.f_20524_;
            default -> null;
        };
    }

    public static Class<? extends Entity> getSpecialEnemyClass(GolemType golemType) {
        return switch (golemType) {
            case LAND -> BTCultist.class;
            case OCEAN -> Guardian.class;
            case CORE -> MagmaCube.class;
            case NETHER -> WitherSkeleton.class;
            case END -> EnderMan.class;
            case SKY -> Skeleton.class;
            default -> null;
        };
    }

    public static Integer getNumForType(GolemType golemType) {
        return switch (golemType) {
            case LAND -> 0;
            case OCEAN -> 1;
            case CORE -> 2;
            case NETHER -> 3;
            case END -> 4;
            case SKY -> 5;
            case CITY -> 6;
            default -> null;
        };
    }

    public static Item getResonanceCrystalForType(GolemType golemType) {
        return switch (golemType) {
            case LAND -> (Item)BTItems.LAND_RESONANCE_CRYSTAL.get();
            case OCEAN -> (Item)BTItems.OCEAN_RESONANCE_CRYSTAL.get();
            case CORE -> (Item)BTItems.CORE_RESONANCE_CRYSTAL.get();
            case NETHER -> (Item)BTItems.NETHER_RESONANCE_CRYSTAL.get();
            case END -> (Item)BTItems.END_RESONANCE_CRYSTAL.get();
            case SKY -> (Item)BTItems.SKY_RESONANCE_CRYSTAL.get();
            case CITY -> (Item)BTItems.CITY_RESONANCE_CRYSTAL.get();
            default -> null;
        };
    }

    @NotNull
    public String m_7912_() {
        return this.name;
    }

    public Component getDisplayName() {
        return this.displayName;
    }

    static {
        VALUES = GolemType.values();
    }
}

