/*
 * Decompiled with CFR 0.152.
 */
package com.brass_amber.ba_bt.util;

import com.brass_amber.ba_bt.util.BTStatics;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;

public class BTUtil {
    static final Logger LOGGER = LogUtils.getLogger();

    public static ListTag newIntList(int ... ints) {
        ListTag listtag = new ListTag();
        for (int d0 : ints) {
            listtag.add((Object)IntTag.m_128679_((int)d0));
        }
        return listtag;
    }

    public static CompoundTag newStringList(ArrayList<String> strings) {
        CompoundTag listtag = new CompoundTag();
        for (int i = 0; i < strings.size(); ++i) {
            listtag.m_128359_(String.valueOf(i), strings.get(i) != null ? strings.get(i) : "");
        }
        return listtag;
    }

    public static ArrayList<String> listFromTag(CompoundTag tag, List<String> checkFrom) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < tag.m_128431_().size(); ++i) {
            String value = tag.m_128461_(String.valueOf(i));
            list.add(checkFrom.contains(value) ? value : "Invalid");
        }
        return list;
    }

    public static int median(ArrayList<Integer> nums) {
        Collections.sort(nums);
        if (nums.size() % 2 == 1) {
            return nums.get((nums.size() + 1) / 2 - 1);
        }
        double lower = nums.get(nums.size() / 2 - 1).intValue();
        double upper = nums.get(nums.size() / 2).intValue();
        return (int)((lower + upper) / 2.0);
    }

    public static double sqrDistanceTo2D(Entity self, double targetX, double targetZ) {
        double dX = self.m_20185_() - targetX;
        double dZ = self.m_20189_() - targetZ;
        return Math.abs(dX * dX + dZ * dZ);
    }

    public static double sqrDistanceTo2D(Entity self, Entity target) {
        double dX = self.m_20185_() - target.m_20185_();
        double dZ = self.m_20189_() - target.m_20189_();
        return Math.abs(dX * dX + dZ * dZ);
    }

    public static int chunkDistanceTo(ChunkPos start, ChunkPos end) {
        return Mth.m_14107_((double)BTUtil.distanceTo2D(start.f_45578_ - end.f_45578_, start.f_45579_ - end.f_45579_));
    }

    public static double distanceTo2D(Entity self, double targetX, double targetZ) {
        double dX = self.m_20185_() - targetX;
        double dZ = self.m_20189_() - targetZ;
        return Math.sqrt(Math.abs(dX * dX + dZ * dZ));
    }

    public static double distanceTo2D(Entity self, Entity entity) {
        double dX = Math.abs(self.m_20185_() - entity.m_20185_());
        double dZ = Math.abs(self.m_20189_() - entity.m_20189_());
        return Math.sqrt(dX * dX + dZ * dZ);
    }

    public static double distanceTo2D(Entity self, BlockPos end) {
        double dX = Math.abs(self.m_20185_() - (double)end.m_123341_());
        double dZ = Math.abs(self.m_20189_() - (double)end.m_123343_());
        return Math.sqrt(dX * dX + dZ * dZ);
    }

    public static double distanceTo2D(BlockPos origin, BlockPos end) {
        double dX = Math.abs(origin.m_123341_() - end.m_123341_());
        double dZ = Math.abs(origin.m_123343_() - end.m_123343_());
        return Math.sqrt(dX * dX + dZ * dZ);
    }

    public static double distanceTo2D(double side, double side2) {
        return Math.sqrt(side * side + side2 * side2);
    }

    public static double distanceTo3D(Entity self, double targetX, double targetY, double targetZ) {
        double dXZ = BTUtil.distanceTo2D(self, targetX, targetZ);
        double dY = self.m_20186_() - targetY;
        return Math.sqrt(Math.abs(dXZ * dXZ + dY * dY));
    }

    public static double distanceTo3D(Entity self, Entity entity) {
        double dXZ = BTUtil.distanceTo2D(self, entity);
        double dY = self.m_20186_() - entity.m_20186_();
        return Math.sqrt(Math.abs(dXZ * dXZ + dY * dY));
    }

    public static double distanceTo3D(Entity self, BlockPos end) {
        double dXZ = BTUtil.distanceTo2D(self, end);
        double dY = self.m_20186_() - (double)end.m_123342_();
        return Math.sqrt(Math.abs(dXZ * dXZ + dY * dY));
    }

    public static double distanceTo3D(BlockPos origin, BlockPos end) {
        double dXZ = BTUtil.distanceTo2D(origin, end);
        double dY = origin.m_123342_() - end.m_123342_();
        return Math.sqrt(Math.abs(dXZ * dXZ + dY * dY));
    }

    public static void removeBodyOfWater(BlockPos start, Level level) {
        HashSet<BlockPos> waterPositions = new HashSet<BlockPos>();
        int recursion = 0;
        BTUtil.removeBodyOWater(waterPositions, start, recursion, level);
        waterPositions.forEach(pos -> level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 0));
    }

    public static void removeBodyOWater(Set<BlockPos> storage, BlockPos position, int recursion, Level level) {
        if (!level.m_46801_(position) || recursion == 250) {
            return;
        }
        if (storage.contains(position)) {
            return;
        }
        storage.add(position);
        BTUtil.removeBodyOWater(storage, position.m_122012_(), recursion + 1, level);
        BTUtil.removeBodyOWater(storage, position.m_122029_(), recursion + 1, level);
        BTUtil.removeBodyOWater(storage, position.m_122019_(), recursion + 1, level);
        BTUtil.removeBodyOWater(storage, position.m_122024_(), recursion + 1, level);
        BTUtil.removeBodyOWater(storage, position.m_7495_(), recursion + 1, level);
    }

    public static Pair<List<Item>, List<Integer>> createItems(int rarity, ArrayList<String> pools, RandomSource randomSource, boolean isExtra) {
        ArrayList<Item> items = new ArrayList<Item>();
        ArrayList poolItems = new ArrayList();
        ArrayList<Integer> amounts = new ArrayList<Integer>();
        ArrayList<Integer> poolMins = new ArrayList<Integer>();
        ArrayList<Integer> poolMaxes = new ArrayList<Integer>();
        rarity = isExtra ? rarity - 1 : rarity;
        for (String pool : pools) {
            Pair<List<List<Item>>, List<List<Float>>> itemPoolAndAmounts = BTStatics.lootMap.getOrDefault(pool, BTStatics.lootMap.get("Building Block"));
            for (int i = Math.max(rarity - 4, 0); i < Math.max(Math.min(rarity + 1, 4), 1); ++i) {
                int timesAdded = i == rarity ? 3 : (i == rarity - 1 ? 2 : 1);
                for (int j = 0; j < timesAdded; ++j) {
                    poolItems.addAll((Collection)((List)itemPoolAndAmounts.getFirst()).get(i));
                    List floats = (List)((List)itemPoolAndAmounts.getSecond()).get(i);
                    Iterator iterator = floats.iterator();
                    while (iterator.hasNext()) {
                        float amount = ((Float)iterator.next()).floatValue();
                        poolMins.add((int)amount);
                        poolMaxes.add((int)((amount - (float)((int)amount)) * 10.0f));
                    }
                }
            }
        }
        int itemAmount = isExtra ? 4 + randomSource.m_188503_(4) : 10 + randomSource.m_188503_(5);
        for (int i = 0; i < itemAmount; ++i) {
            int index = randomSource.m_188503_(Math.max(0, poolItems.size() - 1));
            items.add((Item)poolItems.get(index));
            int min = (Integer)poolMins.get(index);
            int max = (Integer)poolMaxes.get(index);
            if (min < max) {
                amounts.add(randomSource.m_216332_(min, max));
                continue;
            }
            amounts.add(min);
        }
        return Pair.of(items, amounts);
    }

    public static void btListFill(List<Item> loot, List<Integer> amounts, Container container, LootContext lootContext) {
        Random random = new Random();
        List<Integer> possibleSlots = BTUtil.btGetAvailableSlots(container, random);
        ArrayList<ItemStack> chestLoot = new ArrayList<ItemStack>();
        for (int i = 0; i < loot.size(); ++i) {
            Item item;
            ItemStack itemStack = (item = loot.get(i)) instanceof PotionItem ? BTUtil.getRandomPotion(lootContext.m_230907_()) : (item instanceof DyeItem ? BTUtil.getRandomDye(lootContext.m_230907_()) : new ItemStack((ItemLike)item));
            if (item.getMaxStackSize(itemStack) == 1) {
                for (int j = 0; j < amounts.get(i); ++j) {
                    chestLoot.add(itemStack);
                }
                continue;
            }
            itemStack.m_41764_(amounts.get(i).intValue());
            chestLoot.add(itemStack);
        }
        BTUtil.btSplitItems(chestLoot, possibleSlots.size(), lootContext.m_230907_());
        for (ItemStack itemStack : chestLoot) {
            container.m_6836_(possibleSlots.remove(random.nextInt(possibleSlots.size())).intValue(), itemStack);
            if (!possibleSlots.isEmpty()) continue;
            break;
        }
    }

    public static void btFill(LootTable loot, Container container, LootContext lootContext, LootParams lootparams) {
        ObjectArrayList list = loot.m_287195_(lootparams);
        RandomSource random = lootContext.m_230907_();
        List<Integer> list1 = BTUtil.btGetAvailableSlots(container, new Random());
        BTUtil.btShuffleAndSplitItems((List<ItemStack>)list, list1.size(), random);
        for (ItemStack itemstack : list) {
            if (list1.isEmpty()) {
                LOGGER.warn("Tried to over-fill a container");
                return;
            }
            if (itemstack.m_41619_()) {
                container.m_6836_(list1.remove(list1.size() - 1).intValue(), ItemStack.f_41583_);
                continue;
            }
            container.m_6836_(list1.remove(list1.size() - 1).intValue(), itemstack);
        }
    }

    private static List<Integer> btGetAvailableSlots(Container container, Random random) {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < container.m_6643_(); ++i) {
            if (!container.m_8020_(i).m_41619_()) continue;
            list.add(i);
        }
        Collections.shuffle(list, random);
        return list;
    }

    private static void btShuffleAndSplitItems(List<ItemStack> itemStackList, int listSize, RandomSource random) {
        ArrayList list = Lists.newArrayList();
        Iterator<ItemStack> iterator = itemStackList.iterator();
        while (iterator.hasNext()) {
            ItemStack itemstack = iterator.next();
            if (itemstack.m_41619_()) {
                iterator.remove();
                continue;
            }
            if (itemstack.m_41613_() <= 1) continue;
            list.add(itemstack);
            iterator.remove();
        }
        while (listSize - itemStackList.size() - list.size() > 0 && !list.isEmpty()) {
            ItemStack itemstack2 = (ItemStack)list.remove(Mth.m_216271_((RandomSource)random, (int)0, (int)(list.size() - 1)));
            int i = Mth.m_216271_((RandomSource)random, (int)1, (int)(itemstack2.m_41613_() / 2));
            ItemStack itemstack1 = itemstack2.m_41620_(i);
            if (itemstack2.m_41613_() > 1 && random.m_188499_()) {
                list.add(itemstack2);
            } else {
                itemStackList.add(itemstack2);
            }
            if (itemstack1.m_41613_() > 1 && random.m_188499_()) {
                list.add(itemstack1);
                continue;
            }
            itemStackList.add(itemstack1);
        }
        itemStackList.addAll(list);
        Collections.shuffle(itemStackList, new Random());
    }

    private static void btSplitItems(List<ItemStack> itemStackList, int listSize, RandomSource random) {
        ArrayList list = Lists.newArrayList();
        Iterator<ItemStack> iterator = itemStackList.iterator();
        while (iterator.hasNext()) {
            ItemStack itemstack = iterator.next();
            if (itemstack.m_41619_()) {
                iterator.remove();
                continue;
            }
            if (itemstack.m_41613_() <= 2) continue;
            list.add(itemstack);
            iterator.remove();
        }
        while (!list.isEmpty() && list.size() + itemStackList.size() < listSize - 1) {
            ItemStack itemstack2 = (ItemStack)list.remove(Mth.m_216271_((RandomSource)random, (int)0, (int)(list.size() - 1)));
            int i = Mth.m_216271_((RandomSource)random, (int)1, (int)(itemstack2.m_41613_() / 2));
            ItemStack itemstack1 = itemstack2.m_41620_(i);
            if (itemstack2.m_41613_() > 3) {
                list.add(itemstack2);
            } else {
                itemStackList.add(itemstack2);
            }
            if (itemstack1.m_41613_() > 3) {
                list.add(itemstack1);
                continue;
            }
            itemStackList.add(itemstack1);
        }
        itemStackList.addAll(list);
    }

    public static ItemStack getRandomPotion(RandomSource randomSource) {
        return PotionUtils.m_43549_((ItemStack)Items.f_42589_.m_7968_(), (Potion)BTStatics.potions.get(randomSource.m_188503_(BTStatics.potions.size())));
    }

    public static ItemStack getRandomDye(RandomSource randomSource) {
        return new ItemStack((ItemLike)BTStatics.dyes.get(randomSource.m_188503_(BTStatics.dyes.size())));
    }

    public static void doCommand(Entity self, String command) {
        Commands commands = self.m_9236_().m_7654_().m_129892_();
        commands.m_230957_(self.m_20203_().m_81325_(4).m_81324_(), command);
    }

    public static void doNoOutputCommand(Entity self, String command) {
        Commands commands = self.m_9236_().m_7654_().m_129892_();
        commands.m_230957_(self.m_20203_().m_81325_(4).m_81324_(), command);
    }

    public static void doNoOutputPostionedCommand(Entity self, String command, Vec3 vec) {
        Commands commands = self.m_9236_().m_7654_().m_129892_();
        commands.m_230957_(self.m_20203_().m_81325_(4).m_81324_().m_81348_(vec), command);
    }
}

