/*
 * Decompiled with CFR 0.152.
 */
package com.brass_amber.ba_bt.item.item;

import com.brass_amber.ba_bt.init.BTExtras;
import com.brass_amber.ba_bt.util.GolemType;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;

public class ResonanceStoneItem
extends RecordItem {
    public Enchantment enchantment;
    public MobEffect effect;
    private final GolemType golemType;
    public boolean effectOn;
    private boolean initialized;

    public ResonanceStoneItem(String golemName, Supplier<SoundEvent> soundSupplier, Item.Properties properties, int length) {
        super(4, soundSupplier, properties, length);
        this.golemType = GolemType.getTypeForName(golemName);
        this.effectOn = false;
        this.initialized = false;
    }

    public boolean m_8120_(ItemStack itemStack) {
        return itemStack.m_41613_() == 1;
    }

    public void addEnchantment(ItemStack stackInUse) {
        if (this.enchantment != null) {
            Map<Enchantment, Integer> map = Map.of(this.enchantment, 1);
            EnchantmentHelper.m_44865_(map, (ItemStack)stackInUse);
        }
    }

    public void m_6883_(ItemStack itemStack, Level level, Entity entity, int i, boolean b) {
        super.m_6883_(itemStack, level, entity, i, b);
        if (!this.initialized) {
            switch (this.golemType) {
                case OCEAN: {
                    this.enchantment = (Enchantment)BTExtras.DEPTH_DROPPER.get();
                    this.effect = (MobEffect)BTExtras.DEPTH_DROPPER_EFFECT.get();
                    break;
                }
                default: {
                    this.enchantment = null;
                    this.effect = null;
                }
            }
            this.initialized = true;
        }
        if (this.enchantment != null && EnchantmentHelper.m_44831_((ItemStack)itemStack).containsKey(this.enchantment) && !level.m_5776_() && entity instanceof LivingEntity) {
            LivingEntity player = (LivingEntity)entity;
            if (this.effectOn) {
                player.m_147215_(new MobEffectInstance((MobEffect)BTExtras.DEPTH_DROPPER_EFFECT.get(), 80, 3), null);
            }
        }
    }
}

