/*
 * Decompiled with CFR 0.152.
 */
package com.brass_amber.ba_bt.item.item;

import com.brass_amber.ba_bt.BABTMain;
import com.brass_amber.ba_bt.entity.block.BTMonolith;
import com.brass_amber.ba_bt.util.GolemType;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class MonolithItem
extends Item {
    private final GolemType monolithType;

    public MonolithItem(GolemType type, Item.Properties builder) {
        super(builder);
        this.monolithType = type;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        double z;
        double y;
        BlockPos newPlacementPos;
        Level level = context.m_43725_();
        BlockPos clickedPos = context.m_8083_();
        Direction clickedBlockFace = context.m_43719_();
        BlockPos blockPos = newPlacementPos = clickedBlockFace.equals((Object)Direction.DOWN) ? clickedPos.m_5484_(clickedBlockFace, 3) : clickedPos.m_121945_(clickedBlockFace);
        if (!this.hasEnoughSpace(level, newPlacementPos, clickedBlockFace)) {
            return InteractionResult.FAIL;
        }
        double x = newPlacementPos.m_123341_();
        List list = level.m_45933_((Entity)null, new AABB(x, y = (double)newPlacementPos.m_123342_(), z = (double)newPlacementPos.m_123343_(), x + 1.0, y + 3.0, z + 1.0));
        if (!list.isEmpty()) {
            return InteractionResult.FAIL;
        }
        if (level instanceof ServerLevel) {
            double centerOnBlock = 0.5;
            BTMonolith newBTMonolithEntity = new BTMonolith(GolemType.getMonolithFor(this.monolithType), level, x + centerOnBlock, y, z + centerOnBlock, level.m_8055_(newPlacementPos.m_7495_()));
            newBTMonolithEntity.m_146922_(this.getPlacementDirection(context));
            level.m_7967_((Entity)newBTMonolithEntity);
        }
        level.m_5594_(null, newPlacementPos, SoundEvents.f_12010_, SoundSource.BLOCKS, this.getSoundVolume() + 2.0f, this.getSoundPitch() + 1.0f);
        level.m_5594_(null, newPlacementPos, SoundEvents.f_11669_, SoundSource.BLOCKS, this.getSoundVolume() - 0.7f, this.getSoundPitch());
        level.m_5594_(null, newPlacementPos, SoundEvents.f_12376_, SoundSource.BLOCKS, this.getSoundVolume() - 0.25f, this.getSoundPitch());
        context.m_43722_().m_41774_(1);
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    private float getPlacementDirection(UseOnContext context) {
        float angle = context.m_8125_().m_122435_();
        return angle == 90.0f ? 270.0f : (angle == 270.0f ? 90.0f : angle);
    }

    private boolean hasEnoughSpace(Level world, BlockPos pos, Direction clickedBlockFace) {
        for (int height = 0; height < 3; ++height) {
            if (world.m_46859_(pos.m_7918_(0, height, 0)) || world.m_46801_(pos.m_7918_(0, height, 0))) continue;
            return false;
        }
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237115_((String)("tooltip.ba_bt.monolith_" + this.monolithType.m_7912_())).m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY));
        } else {
            tooltip.add(BABTMain.HOLD_SHIFT_TOOLTIP);
        }
    }

    private float getSoundVolume() {
        return 0.8f;
    }

    private float getSoundPitch() {
        Random random = new Random();
        float avaragePitch = 0.0f;
        return (random.nextFloat() - random.nextFloat()) * 0.2f + avaragePitch;
    }
}

