/*
 * Decompiled with CFR 0.152.
 */
package com.brass_amber.ba_bt.entity.hostile.golem;

import com.brass_amber.ba_bt.BattleTowersConfig;
import com.brass_amber.ba_bt.entity.hostile.golem.BTAbstractGolem;
import com.brass_amber.ba_bt.sound.BTMusic;
import com.brass_amber.ba_bt.util.GolemType;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import org.jetbrains.annotations.NotNull;

public class BTOceanGolem
extends BTAbstractGolem {
    private int drowned;

    public BTOceanGolem(EntityType<? extends BTOceanGolem> type, Level levelIn) {
        super(type, levelIn, BossEvent.BossBarColor.YELLOW);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.setGolemName(GolemType.OCEAN.getDisplayName());
        this.setBossBarName();
        this.BOSS_MUSIC = BTMusic.OCEAN_GOLEM_FIGHT_MUSIC;
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.f_21342_ = new SmoothSwimmingMoveControl((Mob)this, 90, 90, 0.08f, 0.5f, false);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 90);
        this.f_21364_ = 910;
        this.drowned = 0;
        this.golemType = GolemType.OCEAN;
    }

    public static AttributeSupplier.Builder createBattleGolemAttributes() {
        return BTAbstractGolem.createBattleGolemAttributes().m_22268_(Attributes.f_22276_, 250.0).m_22268_(Attributes.f_22279_, 1.0).m_22268_(Attributes.f_22278_, 2.0).m_22268_(Attributes.f_22281_, 12.0).m_22268_(Attributes.f_22277_, 60.0).m_22268_(Attributes.f_22284_, 4.0);
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level level) {
        return new WaterBoundPathNavigation((Mob)this, level);
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        spawnDataIn = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.m_21051_(Attributes.f_22276_).m_22100_(((Double)BattleTowersConfig.oceanGolemHP.get()).doubleValue());
        this.m_21153_(this.m_21233_());
        return spawnDataIn;
    }

    @Override
    protected void addBehaviorGoals() {
        super.addBehaviorGoals();
    }

    @Override
    protected float m_6108_() {
        return 0.0f;
    }

    @Override
    public void m_8119_() {
        LivingEntity target;
        super.m_8119_();
        if (this.m_5448_() != null && !this.m_9236_().m_5776_() && this.m_20270_((Entity)(target = this.m_5448_())) > 16.0f && this.f_19796_.m_188503_(500) == 1) {
            this.playRoarSound();
            target.m_147207_(new MobEffectInstance(MobEffects.f_19610_, 60, 1), (Entity)target);
            this.playRoarSound();
        }
    }

    @Override
    public int getAllowedTowerRange() {
        return 56;
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("drowned", this.drowned);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.drowned = compound.m_128451_("drowned");
    }

    @Override
    public boolean m_6469_(DamageSource source, float damage) {
        if (!this.m_9236_().m_5776_() && this.drowned < 4) {
            if ((double)this.m_21223_() < (double)this.m_21233_() * 0.7 && this.drowned == 0) {
                this.spawnDrowned((ServerLevel)this.m_9236_());
                this.drowned = 1;
            } else if ((double)this.m_21223_() < (double)this.m_21233_() * 0.5 && this.drowned == 1) {
                this.spawnDrowned((ServerLevel)this.m_9236_());
                this.drowned = 2;
            } else if ((double)this.m_21223_() < (double)this.m_21233_() * 0.3 && this.drowned == 2) {
                this.spawnDrowned((ServerLevel)this.m_9236_());
                this.drowned = 3;
            }
        }
        return super.m_6469_(source, damage);
    }

    public void m_6845_(boolean p_20313_) {
    }

    public void m_20321_(boolean p_20322_) {
        this.m_183634_();
    }

    public void spawnDrowned(ServerLevel level) {
        List<Entity> drownedList = List.of(EntityType.f_20562_.m_20615_((Level)level), EntityType.f_20562_.m_20615_((Level)level), EntityType.f_20562_.m_20615_((Level)level), EntityType.f_20562_.m_20615_((Level)level));
        int x = this.m_146903_() - 1;
        int z = this.m_146907_() - 1;
        for (Entity drowned : drownedList) {
            if (!(drowned instanceof Mob)) continue;
            Mob mob = (Mob)drowned;
            mob.m_6034_((double)x, this.m_20186_(), (double)z);
            mob.m_6518_((ServerLevelAccessor)level, level.m_6436_(this.m_20183_()), MobSpawnType.TRIGGERED, null, null);
            level.m_7967_(drowned);
            if (x < this.m_146903_()) {
                x += 2;
                continue;
            }
            if (z >= this.m_146907_()) continue;
            z += 2;
        }
    }

    protected void playRoarSound() {
        this.playSoundEvent(SoundEvents.f_11894_, 1.6f);
    }
}

