/*
 * Decompiled with CFR 0.152.
 */
package com.brass_amber.ba_bt.entity.hostile.golem;

import com.brass_amber.ba_bt.BattleTowersConfig;
import com.brass_amber.ba_bt.entity.ai.goal.GolemFireballAttackGoal;
import com.brass_amber.ba_bt.entity.ai.goal.GolemStompAttackGoal;
import com.brass_amber.ba_bt.entity.hostile.golem.BTAbstractGolem;
import com.brass_amber.ba_bt.sound.BTMusic;
import com.brass_amber.ba_bt.util.GolemType;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;

public class BTLandGolem
extends BTAbstractGolem {
    private boolean leap;

    public BTLandGolem(EntityType<? extends BTLandGolem> type, Level levelIn) {
        super(type, levelIn, BossEvent.BossBarColor.BLUE);
        this.setGolemName(GolemType.LAND.getDisplayName());
        this.setBossBarName();
        this.f_21364_ = 315;
        this.golemType = GolemType.LAND;
        this.leap = false;
        this.BOSS_MUSIC = BTMusic.LAND_GOLEM_FIGHT_MUSIC;
        this.m_21441_(BlockPathTypes.LAVA, 8.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public static AttributeSupplier.Builder createBattleGolemAttributes() {
        return BTAbstractGolem.createBattleGolemAttributes().m_22268_(Attributes.f_22276_, 200.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22278_, 2.0).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22277_, 60.0).m_22268_(Attributes.f_22284_, 4.0);
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        spawnDataIn = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.m_21051_(Attributes.f_22276_).m_22100_(((Double)BattleTowersConfig.landGolemHP.get()).doubleValue());
        this.m_21153_(this.m_21233_());
        return spawnDataIn;
    }

    protected float m_6118_() {
        if (this.leap) {
            return 8.0f;
        }
        return 0.45f * this.m_20098_();
    }

    public void bigLeap() {
        this.leap = true;
        this.m_6135_();
        this.leap = false;
    }

    @Override
    protected void addBehaviorGoals() {
        super.addBehaviorGoals();
        this.f_21345_.m_25352_(1, (Goal)new GolemStompAttackGoal(this, 4.0f, 6.0));
        this.f_21345_.m_25352_(6, (Goal)new GolemFireballAttackGoal(this));
    }
}

