/*
 * Decompiled with CFR 0.152.
 */
package com.brass_amber.ba_bt.entity.block;

import com.brass_amber.ba_bt.BABTMain;
import com.brass_amber.ba_bt.BattleTowersConfig;
import com.brass_amber.ba_bt.entity.block.BTAbstractObelisk;
import com.brass_amber.ba_bt.entity.hostile.golem.BTAbstractGolem;
import com.brass_amber.ba_bt.init.BTBlocks;
import com.brass_amber.ba_bt.init.BTExtras;
import com.brass_amber.ba_bt.sound.BTMusic;
import com.brass_amber.ba_bt.util.BTStatics;
import com.brass_amber.ba_bt.util.BTUtil;
import com.brass_amber.ba_bt.util.GolemType;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class BTOceanObelisk
extends BTAbstractObelisk {
    private final List<BlockState> avoidBlocks = BTStatics.towerBlocks.get(GolemType.getNumForType(GolemType.OCEAN));
    private final List<BlockState> corals = List.of(Blocks.f_50595_.m_49966_(), Blocks.f_50596_.m_49966_(), Blocks.f_50597_.m_49966_(), Blocks.f_50598_.m_49966_(), Blocks.f_50594_.m_49966_());
    private int noise;
    private int westWall;
    private int northWall;
    private int eastWall;
    private int southWall;
    private int top;
    private int bottom;
    private int currentCarveLayer;
    private double wallDistance;
    private int nextStep;
    private int distanceChange;
    private boolean oceanCarved = false;
    private final String oceanCarvedName = "OceanCarved";
    private boolean golemDead = false;

    public BTOceanObelisk(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public BTOceanObelisk(Level level) {
        super(GolemType.OCEAN, level);
    }

    @Override
    public void initialize() {
        this.musicDistance = 58;
        this.towerRange = 62;
        super.initialize();
        this.enemySpawnRange = 15;
    }

    @Override
    public void clientInitialize() {
        this.BOSS_MUSIC = BTMusic.OCEAN_GOLEM_FIGHT_MUSIC;
        this.TOWER_MUSIC = BTMusic.OCEAN_TOWER_MUSIC;
        super.clientInitialize();
    }

    @Override
    public void serverInitialize() {
        this.floorDistance = -12;
        this.chestBlock = (Block)BTBlocks.OCEAN_CHEST.get();
        this.golemChestBlock = (Block)BTBlocks.OCEAN_GOLEM_CHEST.get();
        this.spawnerBlock = (Block)BTBlocks.OCEAN_SPAWNER.get();
        this.spawnerFillBlock = Blocks.f_50378_;
        this.golemChestLootTypes = List.of("Weapon", "Armor", "Gem");
        this.towerChestLootTypes = List.of("Weapon", "Armor", "Gem", "Water Plant", "Water Plant");
        this.golemLoot = new ItemStack[]{Items.f_42193_.m_7968_(), Items.f_42192_.m_7968_(), Items.f_42716_.m_7968_()};
        this.noise = (Boolean)BattleTowersConfig.minimalOceanCarving.get() != false ? 30 + (this.f_19796_.m_188503_(2) + 1) * 4 : 60 + (this.f_19796_.m_188503_(2) + 1) * 4;
        this.top = this.m_146904_() - 2;
        this.bottom = this.m_146904_() - 110;
        this.currentFloorY = this.m_146904_() - 2;
        this.currentCarveLayer = this.top;
        this.wallDistance = (double)this.noise - 0.5;
        this.nextStep = this.f_19796_.m_188503_(4) + 8;
        this.distanceChange = this.f_19796_.m_188503_(3);
        this.westWall = this.m_146903_() - this.noise;
        this.northWall = this.m_146907_() - this.noise;
        this.eastWall = this.m_146903_() + this.noise;
        this.southWall = this.m_146907_() + this.noise;
        super.serverInitialize();
    }

    @Override
    protected void m_7380_(@NotNull CompoundTag tag) {
        tag.m_128379_("OceanCarved", this.oceanCarved);
        super.m_7380_(tag);
    }

    @Override
    protected void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.oceanCarved = tag.m_128471_("OceanCarved");
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            return;
        }
        if (!this.oceanCarved && this.serverInitialized && this.f_19797_ % 120 <= 5) {
            this.carveOcean();
            BTUtil.doNoOutputCommand(this, "/kill @e[distance=0..100,type=item,nbt={Item:{id:'minecraft:kelp'}}]");
            return;
        }
        try {
            List list2 = this.m_9236_().m_45976_(BTAbstractGolem.class, this.m_20191_().m_82377_(15.0, 115.0, 15.0));
            this.golemDead = list2.isEmpty() && this.golemSpawned;
        }
        catch (Exception f) {
            BABTMain.LOGGER.error("Exception finding Golem: " + f);
        }
        if (this.f_19797_ % 100 <= 5 && this.hasPlayer && !this.golemDead) {
            List players = Objects.requireNonNull(this.m_9236_().m_7654_()).m_6846_().m_11314_();
            for (ServerPlayer player : players) {
                boolean acceptableY;
                boolean bl = acceptableY = player.m_146904_() < this.m_146904_() - 1 && player.m_146904_() > this.bottom;
                if (BTUtil.distanceTo2D((Entity)this, (Entity)player) < (double)this.towerRange && player.m_20069_() && acceptableY) {
                    player.m_147215_(new MobEffectInstance(MobEffects.f_19608_, 100, 0, true, true), (Entity)player);
                    player.m_147215_(new MobEffectInstance(MobEffects.f_19596_, 100, 1, true, true), (Entity)player);
                    continue;
                }
                if (!player.m_21023_((MobEffect)BTExtras.DEPTH_DROPPER_EFFECT.get())) continue;
                player.m_21195_((MobEffect)BTExtras.DEPTH_DROPPER_EFFECT.get());
                player.m_21195_(MobEffects.f_19611_);
            }
            for (Entity entity2 : this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82377_(60.0, 115.0, 60.0), entity -> entity.m_6084_() && entity.m_20069_())) {
                if (!(BTUtil.distanceTo2D((Entity)this, entity2) < (double)this.towerRange) || !(entity2 instanceof LivingEntity)) continue;
                ((LivingEntity)entity2).m_147215_(new MobEffectInstance((MobEffect)BTExtras.DEPTH_DROPPER_EFFECT.get(), 100, 1, true, true), entity2);
            }
        }
    }

    public void carveOcean() {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        if (this.currentCarveLayer >= this.bottom) {
            int bottomRange = this.currentCarveLayer + this.floorDistance;
            if (this.currentCarveLayer - this.bottom < 25) {
                bottomRange = this.bottom;
            }
            for (int y = this.currentCarveLayer; y >= bottomRange; --y) {
                if (y == this.bottom + 37 || y == this.bottom + 73) {
                    this.wallDistance = ((Boolean)BattleTowersConfig.minimalOceanCarving.get()).booleanValue() ? (this.wallDistance -= 2.0) : (this.wallDistance -= 8.0);
                } else if ((this.top - y) % this.nextStep == 0) {
                    this.wallDistance -= (double)this.distanceChange;
                    this.nextStep = this.f_19796_.m_188503_(4) + 8;
                    this.distanceChange = y > this.bottom + 33 ? this.f_19796_.m_188503_(2) + 1 : 1;
                }
                if (y > this.bottom) {
                    for (int x = this.westWall; x <= this.eastWall; ++x) {
                        for (int z = this.northWall; z <= this.southWall; ++z) {
                            blockpos$mutableblockpos.m_122178_(x, y, z);
                            Block block = this.m_9236_().m_8055_((BlockPos)blockpos$mutableblockpos).m_60734_();
                            double distance2d = BTUtil.distanceTo2D((Entity)this, (BlockPos)blockpos$mutableblockpos);
                            if (y <= this.bottom) continue;
                            if (distance2d > 15.5) {
                                if (this.m_9236_().m_8055_((BlockPos)blockpos$mutableblockpos).m_60734_() == Blocks.f_50576_) {
                                    this.m_9236_().m_7731_((BlockPos)blockpos$mutableblockpos, Blocks.f_49990_.m_49966_(), 3);
                                    continue;
                                }
                                if (this.m_9236_().m_46801_((BlockPos)blockpos$mutableblockpos) || this.avoidBlocks.contains(this.m_9236_().m_8055_((BlockPos)blockpos$mutableblockpos))) continue;
                                if (distance2d < this.wallDistance - 2.0) {
                                    this.m_9236_().m_7731_((BlockPos)blockpos$mutableblockpos, Blocks.f_49990_.m_49966_(), 2);
                                    continue;
                                }
                                if (distance2d < this.wallDistance - 1.0) {
                                    if (this.f_19796_.m_188503_(50) > 30) {
                                        this.m_9236_().m_7731_((BlockPos)blockpos$mutableblockpos, Blocks.f_50493_.m_49966_(), 2);
                                        continue;
                                    }
                                    this.m_9236_().m_7731_((BlockPos)blockpos$mutableblockpos, Blocks.f_49994_.m_49966_(), 2);
                                    continue;
                                }
                                if (!(distance2d < this.wallDistance) || this.avoidBlocks.contains(block.m_49966_())) continue;
                                this.m_9236_().m_7731_((BlockPos)blockpos$mutableblockpos, Blocks.f_50493_.m_49966_(), 2);
                                continue;
                            }
                            if (this.avoidBlocks.contains(block.m_49966_())) continue;
                            this.m_9236_().m_7731_((BlockPos)blockpos$mutableblockpos, Blocks.f_49990_.m_49966_(), 2);
                        }
                    }
                    continue;
                }
                if (y != this.bottom) continue;
                this.addVegetation();
            }
            this.currentCarveLayer = bottomRange;
        }
        if (this.currentCarveLayer == this.bottom) {
            this.oceanCarved = true;
        }
        BABTMain.LOGGER.info("Ocean Carved : " + this.oceanCarved);
    }

    public void addVegetation() {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int y = this.top; y > this.bottom - 1; --y) {
            for (int x = this.westWall; x <= this.eastWall; ++x) {
                for (int z = this.northWall; z <= this.southWall; ++z) {
                    blockpos$mutableblockpos.m_122178_(x, y, z);
                    BlockPos blockAbove = blockpos$mutableblockpos.m_7494_();
                    if (this.m_9236_().m_46801_((BlockPos)blockpos$mutableblockpos) || !this.m_9236_().m_46801_(blockAbove) || !(BTUtil.distanceTo2D((Entity)this, (BlockPos)blockpos$mutableblockpos) < (double)(this.noise + 5)) || this.avoidBlocks.contains(this.m_9236_().m_8055_(blockAbove).m_60734_().m_49966_())) continue;
                    float vegetation = this.f_19796_.m_188501_();
                    if ((double)vegetation > 0.8) {
                        if ((double)vegetation > 0.85) {
                            this.m_9236_().m_7731_(blockAbove, Blocks.f_50037_.m_49966_(), 2);
                            continue;
                        }
                        this.m_9236_().m_7731_(blockAbove, Blocks.f_50038_.m_49966_(), 2);
                        continue;
                    }
                    if ((double)vegetation > 0.7) {
                        this.m_9236_().m_7731_(blockAbove, Blocks.f_50576_.m_49966_(), 2);
                        continue;
                    }
                    if (!((double)vegetation > 0.6)) continue;
                    this.m_9236_().m_7731_(blockAbove, this.corals.get(this.f_19796_.m_188503_(5)), 2);
                }
            }
        }
    }
}

