/*
 * Decompiled with CFR 0.152.
 */
package com.brass_amber.ba_bt.entity.block;

import com.brass_amber.ba_bt.BABTMain;
import com.brass_amber.ba_bt.entity.block.BTAbstractObelisk;
import com.brass_amber.ba_bt.entity.block.BTLandObelisk;
import com.brass_amber.ba_bt.entity.block.BTOceanObelisk;
import com.brass_amber.ba_bt.entity.hostile.golem.BTAbstractGolem;
import com.brass_amber.ba_bt.init.BTEntityType;
import com.brass_amber.ba_bt.sound.BTSoundEvents;
import com.brass_amber.ba_bt.util.GolemType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class BTMonolith
extends Entity {
    public static final EntityDataAccessor<Integer> KEYS = SynchedEntityData.m_135353_(BTMonolith.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final EntityType<?> monolithType;
    private final GolemType golemType;
    private final Item correctMonolithKey;
    private final Item correctGuardianEye;
    private boolean displayEye = false;
    private int nextStageCounter = 0;
    private int livingSoundTime;
    private int floatingRotation;
    private boolean playedSpawnSound = false;
    private boolean spawnedObelisk = false;
    private boolean fromItem;

    public BTMonolith(EntityType<? extends BTMonolith> type, Level level) {
        super(type, level);
        this.f_19850_ = true;
        this.floatingRotation = this.f_19796_.m_188503_(100000);
        this.monolithType = this.m_6095_();
        this.golemType = GolemType.getTypeForMonolith(this);
        this.correctMonolithKey = GolemType.getKeyFor(this.golemType);
        this.correctGuardianEye = GolemType.getEyeFor(GolemType.getPreviousGolemType(this.golemType));
        this.fromItem = true;
    }

    public BTMonolith(EntityType<BTMonolith> monolithEntityType, Level levelIn, double x, double y, double z, BlockState placedOnState) {
        this(monolithEntityType, levelIn);
        this.m_6034_(x, y, z);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(KEYS, (Object)0);
    }

    protected void m_7378_(CompoundTag compound) {
        this.setKeyCountInEntity(compound.m_128451_("Keys"));
        this.spawnedObelisk = compound.m_128471_("Obelisk");
        this.fromItem = compound.m_128471_("FromItem");
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128405_("Keys", this.getKeyCountInEntity());
        compound.m_128379_("Obelisk", this.spawnedObelisk);
        compound.m_128379_("FromItem", this.fromItem);
    }

    public void m_6075_() {
        super.m_6075_();
        if (!(this.m_9236_().m_5776_() || this.spawnedObelisk || this.fromItem)) {
            ServerLevel serverworld = (ServerLevel)this.m_9236_();
            this.spawnObelisk(serverworld);
            this.spawnedObelisk = true;
        }
        boolean isLandMonolith = this.monolithType.equals(BTEntityType.LAND_MONOLITH.get());
        if (this.getKeyCountInEntity() == 2 && !isLandMonolith) {
            ++this.nextStageCounter;
            int seconds = 2;
            if (this.nextStageCounter >= seconds * 20) {
                this.setEyeSlotDisplayed();
                this.nextStageCounter = 0;
            }
        } else if (this.getKeyCountInEntity() >= 3 && (this.isEyeSlotDisplayed() || isLandMonolith)) {
            int seconds;
            if (!this.playedSpawnSound) {
                this.playSpawnSound();
                this.playedSpawnSound = true;
            }
            if (this.nextStageCounter >= (seconds = 5) * 20) {
                this.spawnGolem();
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            ++this.nextStageCounter;
        }
        this.checkBlocksInEntity();
        ++this.floatingRotation;
        if (this.m_9236_().m_5776_()) {
            this.animateTick();
        }
        if (this.m_6084_() && this.f_19796_.m_188503_(1000) < this.livingSoundTime++) {
            this.resetMinSoundInterval();
            this.playAmbientSound();
        }
    }

    @NotNull
    public InteractionResult m_6096_(@NotNull Player player, @NotNull InteractionHand hand) {
        if (this.monolithType != null) {
            Item itemInHand = player.m_21120_(hand).m_41720_();
            if (itemInHand.equals(this.correctMonolithKey)) {
                int keysNeeded;
                int n = keysNeeded = this.monolithType.equals(BTEntityType.LAND_MONOLITH.get()) ? 3 : 2;
                if (this.getKeyCountInEntity() < keysNeeded) {
                    this.increaseKeyCount(player, hand);
                    return InteractionResult.m_19078_((boolean)this.m_20193_().m_5776_());
                }
            } else if (itemInHand.equals(this.correctGuardianEye) && this.getKeyCountInEntity() == 2 && !this.monolithType.equals(BTEntityType.LAND_MONOLITH.get()) && this.isEyeSlotDisplayed()) {
                this.increaseKeyCount(player, hand);
                return InteractionResult.m_19078_((boolean)this.m_20193_().m_5776_());
            }
        }
        return super.m_6096_(player, hand);
    }

    private void increaseKeyCount(Player player, InteractionHand hand) {
        this.setKeyCountInEntity(this.getKeyCountInEntity() + 1);
        this.playKeyInteractionSound();
        if (!player.m_7500_()) {
            player.m_21120_(hand).m_41774_(1);
        }
    }

    private void spawnGolem() {
        if (!this.m_9236_().m_5776_()) {
            ServerLevel serverworld = (ServerLevel)this.m_9236_();
            LightningBolt lightningbolt = (LightningBolt)EntityType.f_20465_.m_20615_((Level)serverworld);
            lightningbolt.m_6027_(this.m_20185_(), this.m_20186_(), this.m_20189_());
            lightningbolt.m_20874_(true);
            serverworld.m_7967_((Entity)lightningbolt);
            this.m_9236_().m_254849_(null, this.m_20185_(), this.m_20186_() + 2.0, this.m_20189_(), 1.6f, Level.ExplosionInteraction.BLOCK);
            this.m_9236_().m_254849_(null, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 1.4f, Level.ExplosionInteraction.BLOCK);
            EntityType<?> golemEntityType = GolemType.getGolemFor(this.golemType);
            Entity entity = golemEntityType.m_20615_(this.m_9236_());
            if (entity instanceof BTAbstractGolem) {
                BTAbstractGolem newGolemEntity = (BTAbstractGolem)entity;
                newGolemEntity.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                newGolemEntity.f_19802_ = 60;
                newGolemEntity.setGolemState((byte)0);
                newGolemEntity.faceDirection(this.getGolemSpawnDirection(this.m_146908_()));
                newGolemEntity.setBossBarName();
                newGolemEntity.golemType = this.golemType;
                newGolemEntity.m_6518_((ServerLevelAccessor)serverworld, serverworld.m_6436_(this.m_20183_()), MobSpawnType.TRIGGERED, null, null);
                serverworld.m_7967_((Entity)newGolemEntity);
            }
            if (!this.fromItem) {
                this.createDestroyTowerEntity(serverworld);
            }
        }
    }

    protected void createDestroyTowerEntity(ServerLevel serverWorld) {
        Entity destroyTowerEntity = GolemType.getDestructionEntity(this.golemType, this.m_9236_(), this.m_20183_());
        destroyTowerEntity.m_20331_(true);
        destroyTowerEntity.f_19802_ = 999999999;
        serverWorld.m_7967_(destroyTowerEntity);
    }

    protected void spawnObelisk(ServerLevel serverWorld) {
        BTAbstractObelisk obelisk;
        switch (this.golemType) {
            case OCEAN: {
                obelisk = new BTOceanObelisk(this.m_9236_());
                obelisk.m_6034_(this.m_20185_(), this.m_20186_() + 106.0, this.m_20189_());
                break;
            }
            default: {
                obelisk = new BTLandObelisk(this.m_9236_());
                obelisk.m_6034_(this.m_20185_(), this.m_20186_() - 90.0, this.m_20189_());
            }
        }
        obelisk.m_20331_(true);
        obelisk.f_19802_ = 999999999;
        serverWorld.m_7967_((Entity)obelisk);
    }

    private float getGolemSpawnDirection(float monolithRotation) {
        return monolithRotation == 0.0f ? 180.0f : (monolithRotation == 180.0f ? 0.0f : monolithRotation);
    }

    private void checkBlocksInEntity() {
        for (int height = 0; height < 3; ++height) {
            BlockPos monolithPos = this.m_20183_().m_7918_(0, height, 0);
            BlockState testBlock = this.m_9236_().m_8055_(monolithPos);
            if (!testBlock.m_60795_() && this.golemType != GolemType.OCEAN) {
                this.m_9236_().m_46597_(monolithPos, Blocks.f_50016_.m_49966_());
                continue;
            }
            if (this.m_9236_().m_46801_(monolithPos) || this.golemType != GolemType.OCEAN) continue;
            this.m_9236_().m_7731_(monolithPos, Blocks.f_49990_.m_49966_(), 2);
        }
    }

    public final int getKeyCountInEntity() {
        return Mth.m_14045_((int)((Integer)this.f_19804_.m_135370_(KEYS)), (int)0, (int)3);
    }

    public final void setKeyCountInEntity(int count) {
        this.f_19804_.m_135381_(KEYS, (Object)count);
    }

    public EntityType<?> getMonolithType() {
        return this.monolithType;
    }

    public void setEyeSlotDisplayed() {
        this.displayEye = true;
    }

    public boolean isEyeSlotDisplayed() {
        return this.displayEye;
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)GolemType.getMonolithItemFor(this.golemType));
    }

    @NotNull
    public PushReaction m_7752_() {
        return PushReaction.BLOCK;
    }

    public boolean m_6087_() {
        return this.m_6084_();
    }

    public boolean m_5829_() {
        return this.m_6084_();
    }

    public void m_6074_() {
        BABTMain.LOGGER.info("Used the /kill command. However, a Monolith has been saved at: " + Math.round(this.m_20185_()) + "X " + Math.round(this.m_20186_()) + "Y " + Math.round(this.m_20189_()) + "Z.");
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (!source.m_19385_().equals("player")) {
            return false;
        }
        if (this.m_6084_() && !this.m_9236_().m_5776_() && source.m_19390_()) {
            this.playDestroySound();
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getFloatingRotation() {
        return this.floatingRotation;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void animateTick() {
        if (this.f_19796_.m_188501_() < 0.2f) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123809_, this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 1.5, this.m_20186_() + 1.0 + this.f_19796_.m_188500_(), this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 1.5, this.f_19796_.m_188500_() - 0.5, this.f_19796_.m_188500_(), this.f_19796_.m_188500_() - 0.5);
        }
    }

    @NotNull
    public SoundSource m_5720_() {
        return SoundSource.BLOCKS;
    }

    private float getSoundVolume() {
        return 0.6f;
    }

    private float getSoundPitch() {
        return 0.5f;
    }

    private int getAmbientSoundInterval() {
        return 400;
    }

    private void resetMinSoundInterval() {
        this.livingSoundTime = -this.getAmbientSoundInterval();
    }

    private void playAmbientSound() {
        this.m_5496_(SoundEvents.f_12375_, this.getSoundVolume() - 0.2f, this.getSoundPitch());
    }

    private void playKeyInteractionSound() {
        if (this.getKeyCountInEntity() == 3) {
            this.m_5496_(SoundEvents.f_12326_, this.getSoundVolume() - 0.5f, this.getSoundPitch());
        }
        float pitchModifier = (float)this.getKeyCountInEntity() / 6.5f;
        this.m_5496_(SoundEvents.f_12376_, this.getSoundVolume(), this.getSoundPitch() + pitchModifier);
    }

    private void playDestroySound() {
        this.m_5496_(SoundEvents.f_12010_, this.getSoundVolume() + 2.0f, this.getSoundPitch() + 1.0f);
        this.m_5496_((SoundEvent)SoundEvents.f_12377_.m_203334_(), this.getSoundVolume(), this.getSoundPitch() + 1.5f);
    }

    private void playSpawnSound() {
        this.m_5496_((SoundEvent)BTSoundEvents.MONOLITH_SPAWN_GOLEM.get(), this.getSoundVolume() - 0.4f, 1.0f);
    }

    public void m_5496_(@NotNull SoundEvent p_19938_, float p_19939_, float p_19940_) {
        if (!this.m_20067_()) {
            this.m_9236_().m_6269_(null, (Entity)this, p_19938_, this.m_5720_(), p_19939_, p_19940_);
        }
    }
}

