/*
 * Decompiled with CFR 0.152.
 */
package com.brass_amber.ba_bt.entity.block;

import com.brass_amber.ba_bt.BABTMain;
import com.brass_amber.ba_bt.block.block.BTSpawnerBlock;
import com.brass_amber.ba_bt.block.blockentity.BTChestBlockEntity;
import com.brass_amber.ba_bt.block.blockentity.DataMarkerBlockEntity;
import com.brass_amber.ba_bt.block.blockentity.spawner.BTAbstractSpawnerBlockEntity;
import com.brass_amber.ba_bt.entity.block.BTMonolith;
import com.brass_amber.ba_bt.entity.hostile.golem.BTAbstractGolem;
import com.brass_amber.ba_bt.init.BTBlocks;
import com.brass_amber.ba_bt.item.item.ResonanceStoneItem;
import com.brass_amber.ba_bt.util.BTStatics;
import com.brass_amber.ba_bt.util.BTUtil;
import com.brass_amber.ba_bt.util.GolemType;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.sounds.MusicManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;

public class BTAbstractObelisk
extends Entity {
    private static final EntityDataAccessor<Integer> SPAWNERS_DESTROYED = SynchedEntityData.m_135353_(BTAbstractObelisk.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private List<BlockPos> CHESTS = new ArrayList<BlockPos>(9);
    private List<List<BlockPos>> SPAWNERS;
    private List<Integer> spawnerAmounts;
    private List<Integer> keySpawnerAmounts;
    protected List<EntityType<?>> towerMobs;
    private boolean initialized = false;
    protected boolean clientInitialized = false;
    protected boolean serverInitialized = false;
    protected int checkLayer = 1;
    protected int currentFloorY;
    private boolean doCheck;
    protected MusicManager music;
    protected int musicDistance;
    protected int towerRange;
    protected int enemySpawnRange;
    protected GolemType golemType;
    private boolean justSpawnedKey;
    public Music TOWER_MUSIC;
    public Music BOSS_MUSIC;
    private final String towerName = "Tower";
    private final String spawnersDestroyedName = "SpawnersDestroyed";
    private final String crystalSpawnedName = "CrystalSpawned";
    protected boolean musicPlaying;
    protected boolean canCheck;
    protected boolean golemSpawned = false;
    private Class<? extends Entity> specialEnemy;
    private boolean chestsFound;
    public boolean hasPlayer;
    public EntityType<?> lastSpawnerType;
    protected int floorDistance;
    protected boolean floorChestFound;
    protected Block chestBlock;
    protected Block golemChestBlock;
    protected Block spawnerBlock;
    protected Block spawnerFillBlock;
    protected Block spawnerMarker;
    protected List<List<Integer>> perFloorData;
    protected List<Integer> floorData;
    protected BTChestBlockEntity golemChest;
    protected List<String> golemChestLootTypes;
    protected List<String> towerChestLootTypes;
    protected ItemStack[] golemLoot;
    public boolean displayCrystal = true;
    private boolean crystalSpawned = false;

    public BTAbstractObelisk(EntityType<?> entityType, Level level) {
        super(entityType, level);
        this.f_19850_ = true;
        this.musicPlaying = false;
        this.doCheck = true;
        this.hasPlayer = false;
        this.canCheck = true;
        this.musicDistance = 0;
        this.towerRange = 0;
        this.floorChestFound = false;
        this.lastSpawnerType = EntityType.f_20460_;
    }

    public BTAbstractObelisk(GolemType golemType, Level level) {
        this(GolemType.getObeliskFor(golemType), level);
        this.golemType = golemType;
        this.chestsFound = false;
    }

    public void initialize() {
        this.initialized = true;
        this.enemySpawnRange = 12;
    }

    public void clientInitialize() {
        this.music = Minecraft.m_91087_().m_91397_();
        this.clientInitialized = true;
        this.golemType = GolemType.getTypeForObelisk(this);
    }

    public void serverInitialize() {
        int golemNum = GolemType.getNumForType(this.golemType);
        this.keySpawnerAmounts = BTStatics.towerChestUnlocking.get(golemNum);
        this.spawnerAmounts = BTStatics.towerSpawnerAmounts.get(golemNum);
        if (!this.chestsFound) {
            this.SPAWNERS = Arrays.asList(new ArrayList(this.spawnerAmounts.get(0)), new ArrayList(this.spawnerAmounts.get(1)), new ArrayList(this.spawnerAmounts.get(2)), new ArrayList(this.spawnerAmounts.get(3)), new ArrayList(this.spawnerAmounts.get(4)), new ArrayList(this.spawnerAmounts.get(5)), new ArrayList(this.spawnerAmounts.get(6)), new ArrayList(this.spawnerAmounts.get(7)));
        }
        this.specialEnemy = GolemType.getSpecialEnemyClass(this.golemType);
        this.towerMobs = BTStatics.towerMobs.get(golemNum);
        this.perFloorData = BTStatics.towerSpawnerData.get(golemNum);
        this.floorData = this.perFloorData.get(0);
        this.spawnerMarker = (Block)BTBlocks.SPAWNER_MARKER.get();
        this.serverInitialized = true;
    }

    public void findChestsAndSpawners(Level level) {
        BlockPos center = this.m_20097_();
        int nextFloorY = this.checkLayer == 8 ? this.currentFloorY + this.floorDistance + this.floorDistance : this.currentFloorY + this.floorDistance;
        BlockPos corner = center.m_7918_(-15, 0, -15);
        BlockPos oppositeCorner = center.m_7918_(15, 0, 15);
        int spawnersSet = 0;
        int bottomOfFloor = Math.min(this.currentFloorY, nextFloorY);
        int topOfFloor = Math.max(this.currentFloorY, nextFloorY);
        for (int x = corner.m_123341_(); x < oppositeCorner.m_123341_(); ++x) {
            for (int z = corner.m_123343_(); z < oppositeCorner.m_123343_(); ++z) {
                for (int y = bottomOfFloor; y <= topOfFloor; ++y) {
                    BlockPos toCheck = new BlockPos(x, y, z);
                    if (level.m_8055_(toCheck).m_60734_() == this.spawnerMarker) {
                        spawnersSet = this.setSpawnerBlock(toCheck, this.checkLayer, level, spawnersSet);
                    }
                    this.checkPos(toCheck, level);
                    this.extraCheck(toCheck, level);
                }
            }
        }
        if (this.CHESTS.size() != this.checkLayer) {
            this.CHESTS.add(null);
        }
        while (this.SPAWNERS.get(this.checkLayer - 1).size() < this.spawnerAmounts.get(this.checkLayer - 1)) {
            this.SPAWNERS.get(this.checkLayer - 1).add(null);
        }
        if (this.checkLayer == 8) {
            this.chestsFound = true;
        } else {
            ++this.checkLayer;
            if (this.checkLayer % 2 == 0 && this.checkLayer < 8) {
                this.floorData = this.perFloorData.get(this.checkLayer / 2);
            }
            this.currentFloorY = nextFloorY;
            this.floorChestFound = false;
        }
    }

    protected int setSpawnerBlock(BlockPos pos, int floor, Level level, int spawnersSet) {
        if (spawnersSet < this.spawnerAmounts.get(floor - 1)) {
            level.m_7731_(pos, this.spawnerBlock.m_49966_(), 2);
            return spawnersSet + 1;
        }
        level.m_7731_(pos, this.spawnerFillBlock.m_49966_(), 2);
        return spawnersSet;
    }

    public void checkPos(BlockPos toCheck, Level level) {
        try {
            Block block = level.m_8055_(toCheck).m_60734_();
            if (block == this.chestBlock && !this.floorChestFound) {
                this.CHESTS.add(toCheck);
                this.floorChestFound = true;
            } else if (block == this.spawnerBlock || block == Blocks.f_50085_) {
                this.SPAWNERS.get(this.checkLayer - 1).add(toCheck);
                BlockEntity entity = level.m_7702_(toCheck);
                if (entity instanceof BTAbstractSpawnerBlockEntity) {
                    EntityType<?> nextSpawnerEntity;
                    BTAbstractSpawnerBlockEntity btspawnerEntity = (BTAbstractSpawnerBlockEntity)entity;
                    while ((nextSpawnerEntity = this.towerMobs.get(this.f_19796_.m_188503_(this.towerMobs.size()))) == this.lastSpawnerType && this.towerMobs.size() > 1) {
                    }
                    btspawnerEntity.getSpawner().m_253197_(nextSpawnerEntity, level, level.m_213780_(), toCheck);
                    btspawnerEntity.getSpawner().setBtSpawnData(this.floorData.get(0), this.floorData.get(1), this.floorData.get(2), this.floorData.get(3), this.floorData.get(4), this.floorData.get(5), this.m_20183_(), this.enemySpawnRange);
                }
            } else if (block == this.golemChestBlock) {
                this.golemChest = (BTChestBlockEntity)level.m_7702_(toCheck);
            } else if (block == BTBlocks.DATA_MARKER.get()) {
                this.processDataMarker(toCheck, level);
            }
        }
        catch (Exception e) {
            BABTMain.LOGGER.info("Exception in Obelisk class, not a chest or spawner: " + level.m_8055_(toCheck).m_60734_());
            e.printStackTrace();
        }
    }

    private void processDataMarker(BlockPos toProcess, Level level) {
        BaseContainerBlockEntity placedEntity;
        DataMarkerBlockEntity dataMarker = (DataMarkerBlockEntity)level.m_7702_(toProcess);
        Rotation rotation = BABTMain.SAVE_TOWERS.getTowerRotation(GolemType.getNumForType(this.golemType), level.m_46865_(this.m_20183_()).m_7697_());
        BlockState placeState = dataMarker.getPlaceBlockState();
        placeState = placeState.rotate((LevelAccessor)level, toProcess, rotation);
        ArrayList<String> lootTypes = dataMarker.getLootTypes();
        lootTypes.removeIf(type -> type.equals("Invalid"));
        lootTypes.removeIf(String::isEmpty);
        int rarity = dataMarker.getRarity();
        if (rarity <= -1) {
            rarity = rarity + 1 + this.checkLayer - 1 < 2 ? 0 : this.checkLayer / 2;
        }
        level.m_46597_(toProcess, placeState);
        BlockEntity blockEntity = level.m_7702_(toProcess);
        if (blockEntity == null) {
            return;
        }
        blockEntity.m_142466_(dataMarker.getNbt());
        if (lootTypes.isEmpty()) {
            return;
        }
        try {
            placedEntity = (BaseContainerBlockEntity)level.m_7702_(toProcess);
        }
        catch (ClassCastException e) {
            return;
        }
        LootParams lootparams = new LootParams.Builder((ServerLevel)this.m_9236_()).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)toProcess)).m_287235_(LootContextParamSets.f_81411_);
        LootContext lootcontext = new LootContext.Builder(lootparams).m_287259_(null);
        Pair<List<Item>, List<Integer>> itemsAmounts = BTUtil.createItems(rarity, lootTypes, this.f_19796_, true);
        BTUtil.btListFill((List)itemsAmounts.getFirst(), (List)itemsAmounts.getSecond(), (Container)placedEntity, lootcontext);
    }

    public void extraCheck(BlockPos toUpdate, Level level) {
    }

    public void m_8119_() {
        block29: {
            super.m_8119_();
            if (!this.initialized) {
                this.initialize();
                return;
            }
            if (this.m_9236_().m_5776_()) {
                this.clientTick();
                return;
            }
            if (!this.serverInitialized) {
                this.serverInitialize();
                return;
            }
            if (!this.displayCrystal && !this.crystalSpawned) {
                this.m_20000_((ItemLike)GolemType.getResonanceCrystalForType(this.golemType), 1);
                this.crystalSpawned = true;
            }
            if (!this.chestsFound) {
                this.findChestsAndSpawners(this.m_9236_());
            }
            if (this.doCheck) {
                try {
                    List list = this.m_9236_().m_45976_(BTMonolith.class, this.m_20191_().m_82377_(15.0, 115.0, 15.0));
                    boolean bl = this.canCheck = !list.isEmpty();
                    if (this.canCheck) break block29;
                    try {
                        List list2 = this.m_9236_().m_45976_(BTAbstractGolem.class, this.m_20191_().m_82377_(15.0, 115.0, 15.0));
                        boolean bl2 = this.canCheck = !list2.isEmpty();
                        if (!this.golemSpawned) {
                            this.golemSpawned = true;
                        }
                    }
                    catch (Exception f) {
                        BABTMain.LOGGER.error("Exception finding Golem: " + f);
                    }
                }
                catch (Exception e) {
                    BABTMain.LOGGER.error("Exception finding Monolith: " + e);
                }
            }
        }
        if (this.canCheck) {
            List specialEnemies;
            List players = Objects.requireNonNull(this.m_9236_().m_7654_()).m_6846_().m_11314_();
            ArrayList<Boolean> playersClose = new ArrayList<Boolean>();
            for (ServerPlayer player : players) {
                if (BTUtil.distanceTo2D((Entity)this, (Entity)player) < (double)this.towerRange) {
                    playersClose.add(Boolean.TRUE);
                    continue;
                }
                playersClose.add(Boolean.FALSE);
            }
            this.hasPlayer = Collections.frequency(playersClose, Boolean.TRUE) > 0;
            int timeCheck = (this.f_19796_.m_188503_(2) + 4) * 40;
            if (this.f_19797_ % timeCheck == 0 && (specialEnemies = this.m_9236_().m_45976_(this.specialEnemy, this.m_20191_().m_82377_(15.0, 110.0, 15.0))).size() < 10) {
                int floor = this.m_20183_().m_123342_() + this.f_19796_.m_188503_(8) * 11;
                int x = this.m_20183_().m_123341_() + this.f_19796_.m_188503_(24) - 12;
                int y = floor + this.f_19796_.m_188503_(9);
                int z = this.m_20183_().m_123343_() + this.f_19796_.m_188503_(24) - 12;
                ServerLevel serverWorld = (ServerLevel)this.m_9236_();
                switch (this.golemType) {
                    case LAND: {
                        this.spawnSpecialEnemy(serverWorld, new BlockPos(x, y, z), 0.0, 11.5, true);
                        break;
                    }
                    case OCEAN: {
                        this.spawnSpecialEnemy(serverWorld, new BlockPos(x, y, z), 12.5, 17.5, false);
                        break;
                    }
                    case CORE: {
                        this.spawnSpecialEnemy(serverWorld, new BlockPos(x, y, z), 12.5, 17.5, true);
                    }
                }
            }
            if (this.f_19797_ % 20 == 0 && this.hasPlayer) {
                this.checkSpawners(this.m_9236_());
            }
        }
        if (!this.canCheck && this.golemChest != null && this.chestsFound && this.initialized && this.f_19797_ > 40 && !this.golemChest.isUnlocked()) {
            try {
                int i;
                this.golemChest.setUnlocked(true);
                for (i = 2; i < 7; ++i) {
                    this.golemChest.m_6836_(i, this.golemLoot[0]);
                }
                for (i = 19; i < 24; ++i) {
                    this.golemChest.m_6836_(i, this.golemLoot[1]);
                }
                for (i = 10; i < 17; ++i) {
                    this.golemChest.m_6836_(i, this.golemLoot[0]);
                }
                this.golemChest.m_6836_(13, this.golemLoot[2]);
                LootParams lootparams = new LootParams.Builder((ServerLevel)this.m_9236_()).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)this.golemChest.m_58899_())).m_287235_(LootContextParamSets.f_81411_);
                LootContext lootcontext = new LootContext.Builder(lootparams).m_287259_(null);
                String lootPath = GolemType.getTowerChestPool(this.golemType, 8);
                if (!lootPath.equals("")) {
                    BTUtil.btFill(this.m_20194_().m_278653_().m_278676_(new ResourceLocation(lootPath)), (Container)this.golemChest, lootcontext, lootparams);
                } else {
                    Pair<List<Item>, List<Integer>> itemsAmounts = BTUtil.createItems(4, new ArrayList<String>(this.golemChestLootTypes), this.f_19796_, false);
                    BTUtil.btListFill((List)itemsAmounts.getFirst(), (List)itemsAmounts.getSecond(), (Container)this.golemChest, lootcontext);
                }
                this.chestUnlockingSound(this.m_9236_());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void clientTick() {
        boolean playerInMusicRange;
        boolean playerInTowerRange;
        boolean hasClientPlayer;
        ClientLevel client;
        block17: {
            client = (ClientLevel)this.m_9236_();
            if (!this.clientInitialized) {
                this.clientInitialize();
            }
            if (client.m_6907_().isEmpty()) {
                return;
            }
            if (this.doCheck) {
                try {
                    List list = client.m_45976_(BTMonolith.class, this.m_20191_().m_82377_(15.0, 110.0, 15.0));
                    boolean bl = this.canCheck = !list.isEmpty();
                    if (this.canCheck) break block17;
                    try {
                        List list2 = this.m_9236_().m_45976_(BTAbstractGolem.class, this.m_20191_().m_82377_(15.0, 110.0, 15.0));
                        boolean bl2 = this.canCheck = !list2.isEmpty();
                        if (!this.golemSpawned) {
                            this.golemSpawned = true;
                        }
                    }
                    catch (Exception f) {
                        BABTMain.LOGGER.error("Exception finding Golem: " + f);
                    }
                }
                catch (Exception e) {
                    BABTMain.LOGGER.error("Exception finding Monolith: " + e);
                }
            }
        }
        if ((hasClientPlayer = client.m_45914_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 200.0)) && !this.golemSpawned) {
            Player player = client.m_45930_((Entity)this, 200.0);
            double distanceTo = BTUtil.distanceTo2D((Entity)this, (Entity)player);
            playerInTowerRange = distanceTo <= (double)this.towerRange;
            playerInMusicRange = distanceTo < (double)this.musicDistance;
        } else {
            playerInTowerRange = false;
            playerInMusicRange = false;
        }
        boolean tryPlayMusic = false;
        if (this.BOSS_MUSIC == null) {
            tryPlayMusic = playerInTowerRange;
        } else if (!this.music.m_120187_(this.BOSS_MUSIC)) {
            tryPlayMusic = playerInTowerRange;
        }
        if (tryPlayMusic) {
            if (playerInMusicRange && !this.music.m_120187_(this.TOWER_MUSIC)) {
                this.music.m_120186_();
                this.music.m_120184_(this.TOWER_MUSIC);
                this.musicPlaying = true;
            }
        } else if (this.musicPlaying) {
            this.music.m_120186_();
            this.musicPlaying = false;
        }
    }

    protected void spawnSpecialEnemy(ServerLevel serverWorld, BlockPos spawn, double lowerRadiusBound, double upperRadiusBound, boolean checkOnGround) {
        Entity entity;
        boolean specialEnemyCap;
        double distance = BTUtil.distanceTo2D(this, spawn.m_123341_(), spawn.m_123343_());
        boolean canSpawn = SpawnPlacements.m_217074_(GolemType.getSpecialEnemyType(this.golemType), (ServerLevelAccessor)serverWorld, (MobSpawnType)MobSpawnType.STRUCTURE, (BlockPos)spawn, (RandomSource)this.f_19796_);
        boolean acceptableDistance = lowerRadiusBound < distance && distance < upperRadiusBound;
        List nearby = serverWorld.m_45976_(GolemType.getSpecialEnemyClass(this.golemType), this.m_20191_().m_82377_(15.0, 110.0, 15.0));
        boolean bl = specialEnemyCap = nearby.size() > 4;
        boolean onGround = checkOnGround ? !serverWorld.m_8055_(spawn.m_7495_()).m_60795_() && serverWorld.m_8055_(spawn).m_60795_() : true;
        if (!specialEnemyCap && canSpawn && acceptableDistance && onGround && serverWorld.m_8055_(spawn.m_7494_()).m_60795_() && (entity = GolemType.getSpecialEnemy(this.golemType, serverWorld)) instanceof Mob) {
            Mob mob = (Mob)entity;
            mob.m_6034_((double)spawn.m_123341_() + 0.5, (double)spawn.m_123342_(), (double)spawn.m_123343_() + 0.5);
            ForgeEventFactory.onFinalizeSpawn((Mob)mob, (ServerLevelAccessor)serverWorld, (DifficultyInstance)serverWorld.m_6436_(this.m_20183_()), (MobSpawnType)MobSpawnType.TRIGGERED, null, null);
            serverWorld.m_7967_(entity);
        }
    }

    private void checkSpawners(Level level) {
        ArrayList<BlockPos> chests = new ArrayList<BlockPos>(this.CHESTS);
        chests.removeIf(Objects::isNull);
        ArrayList<List<BlockPos>> spawners = new ArrayList<List<BlockPos>>(this.SPAWNERS);
        spawners.removeIf(Objects::isNull);
        if (spawners.isEmpty() || chests.isEmpty()) {
            this.doCheck = false;
            this.canCheck = false;
        } else {
            for (int i = 0; i < this.SPAWNERS.size(); ++i) {
                List<BlockPos> positions = this.SPAWNERS.get(i);
                if (positions == null) continue;
                positions.removeIf(Objects::isNull);
                if (positions.isEmpty()) {
                    BTChestBlockEntity chest;
                    BlockEntity blockEntity;
                    BlockPos chestPos = this.CHESTS.get(i);
                    if (chestPos != null && (blockEntity = level.m_7702_(chestPos)) instanceof BTChestBlockEntity && !(chest = (BTChestBlockEntity)blockEntity).isUnlocked()) {
                        int rarity;
                        chest.setUnlocked(true);
                        LootParams lootparams = new LootParams.Builder((ServerLevel)this.m_9236_()).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)chestPos)).m_287235_(LootContextParamSets.f_81411_);
                        LootContext lootcontext = new LootContext.Builder(lootparams).m_287259_(null);
                        assert (chest != null) : "BTObelisk: Not a BTChest";
                        String lootPath = GolemType.getTowerChestPool(this.golemType, i);
                        int n = rarity = i < 2 ? 0 : i / 2;
                        if (!lootPath.isEmpty()) {
                            BTUtil.btFill(this.m_20194_().m_278653_().m_278676_(new ResourceLocation(lootPath)), (Container)chest, lootcontext, lootparams);
                        } else {
                            Pair<List<Item>, List<Integer>> itemsAmounts = BTUtil.createItems(rarity, new ArrayList<String>(this.towerChestLootTypes), this.f_19796_, false);
                            BTUtil.btListFill((List)itemsAmounts.getFirst(), (List)itemsAmounts.getSecond(), (Container)chest, lootcontext);
                        }
                        this.chestUnlockingSound(level);
                        this.CHESTS.set(i, null);
                    }
                    this.SPAWNERS.set(i, null);
                    continue;
                }
                positions = this.SPAWNERS.get(i);
                for (int x = 0; x < positions.size(); ++x) {
                    BlockEntity blockEntity;
                    BlockPos blockPos;
                    if (positions.get(x) != null && !(level.m_8055_(blockPos = positions.get(x)).m_60734_() instanceof BTSpawnerBlock)) {
                        this.SPAWNERS.get(i).set(x, null);
                        this.setSpawnersDestroyed(this.getSpawnersDestroyed() + 1);
                        BABTMain.LOGGER.info("Spawners Destroyed: {}", (Object)this.getSpawnersDestroyed());
                    }
                    if (!this.keySpawnerAmounts.contains(this.getSpawnersDestroyed()) || this.justSpawnedKey) continue;
                    if (this.CHESTS.get(i) != null && (blockEntity = level.m_7702_(this.CHESTS.get(i))) instanceof BTChestBlockEntity) {
                        BTChestBlockEntity chest = (BTChestBlockEntity)blockEntity;
                        chest.m_6836_(13, GolemType.getKeyFor(this.golemType).m_7968_());
                    } else if (this.CHESTS.get(i) == null) {
                        BTUtil.doNoOutputPostionedCommand(this, "/give @p ba_bt:" + GolemType.getKeyFor(this.golemType).m_5524_(), new Vec3((double)this.m_20183_().m_123341_(), (double)(this.m_20183_().m_123342_() + 11 * i), (double)this.m_20183_().m_123343_()));
                    }
                    this.justSpawnedKey = true;
                }
            }
        }
    }

    private void chestUnlockingSound(Level level) {
        List players = Objects.requireNonNull(level.m_7654_()).m_6846_().m_11314_();
        for (ServerPlayer player : players) {
            if (!(BTUtil.distanceTo2D((Entity)this, (Entity)player) < 30.0)) continue;
            level.m_5594_(null, player.m_20183_(), SoundEvents.f_12056_, SoundSource.BLOCKS, 1.0f, 1.5f);
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(SPAWNERS_DESTROYED, (Object)0);
    }

    protected void m_7378_(CompoundTag tag) {
        if (!this.m_9236_().m_5776_()) {
            this.golemType = GolemType.getTypeForName(tag.m_128461_("Tower"));
            this.setSpawnersDestroyed(tag.m_128451_("SpawnersDestroyed"));
            this.crystalSpawned = tag.m_128471_("CrystalSpawned");
        }
    }

    protected void m_7380_(@NotNull CompoundTag tag) {
        if (this.m_9236_().m_5776_()) {
            this.music.m_120186_();
        } else {
            BABTMain.LOGGER.info("Setting obelisk data");
            tag.m_128359_("Tower", this.golemType.m_7912_());
            tag.m_128405_("SpawnersDestroyed", this.getSpawnersDestroyed());
            tag.m_128379_("CrystalSpawned", this.crystalSpawned);
        }
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)((Item)null));
    }

    @NotNull
    public PushReaction m_7752_() {
        return PushReaction.BLOCK;
    }

    public boolean m_6087_() {
        return this.m_6084_();
    }

    public boolean m_5829_() {
        return true;
    }

    public void m_6074_() {
        Player player = this.m_9236_().m_5788_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 50.0, EntitySelector.f_20408_);
        if (player != null && player.m_7500_()) {
            BABTMain.LOGGER.info("Item: " + player.m_21120_(InteractionHand.MAIN_HAND).m_41720_());
            if (player.m_21120_(InteractionHand.MAIN_HAND).m_41720_() == Items.f_42461_) {
                this.m_142687_(Entity.RemovalReason.KILLED);
            } else {
                BABTMain.LOGGER.info("Used the /kill command. However, an Obelisk has been saved at: " + Math.round(this.m_20185_()) + "X " + Math.round(this.m_20186_()) + "Y " + Math.round(this.m_20189_()) + "Z.");
            }
        } else {
            BABTMain.LOGGER.info("Used the /kill command. However, an Obelisk has been saved at: " + Math.round(this.m_20185_()) + "X " + Math.round(this.m_20186_()) + "Y " + Math.round(this.m_20189_()) + "Z.");
        }
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        Player player;
        if (this.m_6673_(source)) {
            return false;
        }
        if (!source.m_19385_().equals("player")) {
            return false;
        }
        if (this.m_6084_() && !this.m_9236_().m_5776_() && source.m_19390_() && (player = (Player)source.m_7639_()) != null && player.m_21120_(InteractionHand.MAIN_HAND).m_41720_() == Items.f_42461_) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
        return true;
    }

    @NotNull
    public InteractionResult m_6096_(Player player, @NotNull InteractionHand hand) {
        ItemStack itemInHand = player.m_21120_(hand);
        Item item = itemInHand.m_41720_();
        if (item instanceof ResonanceStoneItem) {
            ResonanceStoneItem stoneItem = (ResonanceStoneItem)item;
            stoneItem.addEnchantment(itemInHand);
            return InteractionResult.SUCCESS;
        }
        if (itemInHand.m_150930_(GolemType.getEyeFor(this.golemType)) && this.golemSpawned) {
            this.displayCrystal = false;
            return InteractionResult.CONSUME;
        }
        return super.m_6096_(player, hand);
    }

    public MobCategory getClassification(boolean forSpawnCount) {
        return MobCategory.AMBIENT;
    }

    public void setSpawnersDestroyed(int num) {
        this.f_19804_.m_135381_(SPAWNERS_DESTROYED, (Object)num);
        this.justSpawnedKey = false;
    }

    public int getSpawnersDestroyed() {
        return (Integer)this.f_19804_.m_135370_(SPAWNERS_DESTROYED);
    }
}

