/*
 * Decompiled with CFR 0.152.
 */
package com.brass_amber.ba_bt.entity.ai.goal;

import com.brass_amber.ba_bt.entity.hostile.golem.BTAbstractGolem;
import com.brass_amber.ba_bt.sound.BTSoundEvents;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class GolemFireballAttackGoal
extends Goal {
    protected final BTAbstractGolem golem;
    public int chargeTime;

    public GolemFireballAttackGoal(BTAbstractGolem golem) {
        this.golem = golem;
    }

    public boolean m_8036_() {
        return this.golem.m_5448_() != null && !this.golem.isDormant();
    }

    public void m_8056_() {
        this.chargeTime = 0;
    }

    public void m_8041_() {
        this.golem.setCharging(false);
    }

    public void m_8037_() {
        LivingEntity targetLivingEntity = this.golem.m_5448_();
        if (targetLivingEntity != null) {
            this.golem.m_21563_().m_24960_((Entity)targetLivingEntity, 30.0f, 30.0f);
            double maxShootingDistance = 64.0;
            maxShootingDistance *= maxShootingDistance;
            if (targetLivingEntity.m_20280_((Entity)this.golem) < maxShootingDistance && this.golem.m_142582_((Entity)targetLivingEntity)) {
                ++this.chargeTime;
                if (this.chargeTime == 10 && !this.golem.m_20067_()) {
                    this.golem.playSoundEventWithVariation((SoundEvent)BTSoundEvents.ENTITY_GOLEM_CHARGE.get());
                }
                if (this.chargeTime >= 20) {
                    Vec3 vec3 = this.golem.m_20252_(1.0f);
                    double xPower = targetLivingEntity.m_20185_() - this.golem.m_20185_();
                    double yPower = targetLivingEntity.m_20227_(0.5) - (0.5 + this.golem.m_20227_(0.5));
                    double zPower = targetLivingEntity.m_20189_() - this.golem.m_20189_();
                    Level level = this.golem.m_9236_();
                    if (!this.golem.m_20067_()) {
                        level.m_5898_(null, 1016, this.golem.m_20183_(), 0);
                    }
                    Projectile fireballentity = this.createFireBall(level, xPower, yPower, zPower);
                    double lateralSpawnPositionOffset = 1.2;
                    double verticalSpawnPositionOffset = 0.5;
                    fireballentity.m_6034_(this.golem.m_20185_() + vec3.f_82479_ * lateralSpawnPositionOffset, this.golem.m_20227_(0.5) + verticalSpawnPositionOffset, fireballentity.m_20189_() + vec3.f_82481_ * lateralSpawnPositionOffset);
                    level.m_7967_((Entity)fireballentity);
                    this.chargeTime = this.golem.isEnraged() ? -20 : -40;
                }
            } else if (this.chargeTime > 0) {
                --this.chargeTime;
            }
            this.golem.setCharging(this.chargeTime > 10);
        }
    }

    protected Projectile createFireBall(Level level, double xPower, double yPower, double zPower) {
        return new LargeFireball(level, (LivingEntity)this.golem, xPower, yPower, zPower, this.golem.getExplosionPower());
    }
}

