/*
 * Decompiled with CFR 0.152.
 */
package com.brass_amber.ba_bt.entity;

import com.brass_amber.ba_bt.BattleTowersConfig;
import com.brass_amber.ba_bt.entity.hostile.golem.BTAbstractGolem;
import com.brass_amber.ba_bt.init.BTBlocks;
import com.brass_amber.ba_bt.init.BTEntityType;
import com.brass_amber.ba_bt.sound.BTSoundEvents;
import com.brass_amber.ba_bt.util.BTUtil;
import com.brass_amber.ba_bt.util.GolemType;
import com.brass_amber.ba_bt.util.TowerSpecs;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;

public class OceanDestructionEntity
extends Entity {
    private static final EntityDataAccessor<Integer> CRUMBLE_SPEED = SynchedEntityData.m_135353_(OceanDestructionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> CURRENT_ROW = SynchedEntityData.m_135353_(OceanDestructionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private Boolean initialized = false;
    private TowerSpecs specs;
    private GolemType golemType;
    private List<BlockPos> blocksToRemove;
    private int currentRowY = -64;
    private int crumbleStop = 0;
    private int startTicks = 600;
    private int currentTicks = 0;
    private boolean golemDead = false;
    private final Random random = new Random();
    private boolean checkForGolem = true;
    private boolean hasPlayer = false;
    private ArrayList<FallingBlockEntity> fallingBlocks;
    private final String crumbleSpeedName = "CrumbleSpeed";
    private final String currentRowName = "CurrentFloor";

    public OceanDestructionEntity(EntityType<OceanDestructionEntity> type, Level level) {
        super(type, level);
        this.golemType = GolemType.OCEAN;
        this.startTicks = (Integer)BattleTowersConfig.oceanTimeBeforeCollapse.get() * 20;
        this.blocksToRemove = new ArrayList<BlockPos>();
        this.fallingBlocks = new ArrayList();
    }

    public OceanDestructionEntity(Level level) {
        super((EntityType)BTEntityType.OCEAN_DESTRUCTION.get(), level);
        this.golemType = GolemType.OCEAN;
        this.blocksToRemove = new ArrayList<BlockPos>();
    }

    public void getNextRow() {
        for (int y = this.currentRowY; y < this.currentRowY + 4; ++y) {
            for (int x = this.m_146903_() - 17; x <= this.m_146903_() + 17; ++x) {
                for (int z = this.m_146907_() - 17; z <= this.m_146907_() + 17; ++z) {
                    BlockPos blockToAdd = new BlockPos(x, y, z);
                    FluidState fluidState = this.m_9236_().m_6425_(blockToAdd);
                    if (!(BTUtil.distanceTo2D((Entity)this, blockToAdd) < 17.5)) continue;
                    if (!fluidState.m_76178_()) {
                        this.m_9236_().m_7731_(blockToAdd, ((Block)BTBlocks.AIR_FILL.get()).m_49966_(), 2);
                        continue;
                    }
                    if (this.m_9236_().m_8055_(blockToAdd).m_60795_()) continue;
                    this.blocksToRemove.add(blockToAdd);
                }
            }
        }
        this.currentRowY += 4;
        this.setCurrentRow(this.getCurrentRow() + 1);
    }

    private void init() {
        this.specs = TowerSpecs.getTowerFromGolem(this.golemType);
        this.setCrumbleSpeed(this.specs.getCrumbleSpeed());
        this.crumbleStop = this.m_146904_() + (int)Math.round((double)this.specs.getHeight() * (Double)BattleTowersConfig.oceanTowerCrumblePercent.get() - 1.0);
        this.fallingBlocks = new ArrayList();
        this.initialized = true;
        this.currentRowY = -64 + (this.getCurrentRow() - 1) * 4;
    }

    public void m_8119_() {
        boolean alivePlayer;
        FallingBlockEntity blockEntity;
        int i;
        if (this.m_9236_().m_5776_()) {
            return;
        }
        if (!this.initialized.booleanValue()) {
            this.init();
        }
        if (this.currentRowY < this.m_146904_() && this.getCrumbleSpeed() != 1) {
            this.setCrumbleSpeed(1);
        } else {
            this.setCrumbleSpeed(2);
        }
        ArrayList<FallingBlockEntity> removeFallEntity = new ArrayList<FallingBlockEntity>();
        for (i = 0; i < this.fallingBlocks.size(); ++i) {
            blockEntity = this.fallingBlocks.get(i);
            if (!(blockEntity.m_20186_() < (double)(this.currentRowY - 10))) continue;
            removeFallEntity.add(this.fallingBlocks.remove(i));
        }
        Collections.reverse(removeFallEntity);
        for (i = 0; i < removeFallEntity.size(); ++i) {
            blockEntity = (FallingBlockEntity)removeFallEntity.remove(i);
            blockEntity.m_6074_();
        }
        super.m_8119_();
        if (this.checkForGolem) {
            List entities = this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82377_(50.0, 100.0, 50.0));
            boolean deadGolem = true;
            for (Entity entity : entities) {
                try {
                    BTAbstractGolem golem = (BTAbstractGolem)entity;
                    deadGolem = false;
                }
                catch (Exception golem) {}
            }
            if (deadGolem) {
                this.setGolemDead(true);
            } else {
                this.setGolemDead(false);
                this.currentTicks = 0;
            }
        }
        this.hasPlayer = (alivePlayer = this.m_9236_().m_45914_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 100.0)) ? BTUtil.distanceTo2D((Entity)this, (Entity)this.m_9236_().m_45930_((Entity)this, 100.0)) < 125.0 : false;
        if (this.golemDead && this.hasPlayer) {
            ++this.currentTicks;
            if (this.currentTicks == 1) {
                BTUtil.doNoOutputCommand(this, "/title @a times 30 40 20");
                BTUtil.doNoOutputCommand(this, "/title @a title \"\"");
                BTUtil.doNoOutputCommand(this, "/title @a subtitle {\"text\":\" " + this.specs.getTitleText1() + "\",\"color\":\"" + this.specs.getColorCode() + "\"}");
                this.m_9236_().m_5594_(null, this.m_20183_().m_6630_(6), (SoundEvent)BTSoundEvents.TOWER_BREAK_START.get(), SoundSource.AMBIENT, 4.0f, 1.0f);
            } else if (this.currentTicks == 400) {
                BTUtil.doNoOutputCommand(this, "/title @a title \"\"");
                BTUtil.doNoOutputCommand(this, "/title @a subtitle {\"text\":\"" + this.specs.getTitleText2() + " \",\"color\":\"#aaaaaa\"}");
                this.m_9236_().m_5594_(null, this.m_20183_().m_6630_(6), (SoundEvent)BTSoundEvents.TOWER_BREAK_START.get(), SoundSource.AMBIENT, 4.0f, 1.0f);
            } else if (this.currentTicks == 500) {
                BTUtil.doNoOutputCommand(this, "/title @a title \"\"");
                BTUtil.doNoOutputCommand(this, "/title @a subtitle {\"text\":\"" + this.specs.getTitleText3() + "\",\"color\":\"#aa0000\"}");
            } else if (this.currentTicks == 600) {
                this.m_9236_().m_5594_(null, this.m_20183_().m_6630_(6), (SoundEvent)BTSoundEvents.TOWER_BREAK_CRUMBLE.get(), SoundSource.AMBIENT, 4.0f, 1.0f);
            }
            if (this.currentTicks > this.startTicks && this.currentTicks % this.getCrumbleSpeed() == 0) {
                if (this.currentTicks % 240 == 0) {
                    this.m_9236_().m_5594_(null, this.m_20183_().m_6630_(this.getCurrentRow() * 4), (SoundEvent)BTSoundEvents.TOWER_BREAK_CRUMBLE.get(), SoundSource.AMBIENT, 4.0f, 1.0f);
                }
                if (this.blocksToRemove.size() < 20) {
                    this.getNextRow();
                }
                int numOfBlocks = 64;
                if (this.currentRowY < this.m_146904_()) {
                    numOfBlocks = 128;
                }
                if (this.currentRowY < this.m_9236_().m_5736_() + 3 && this.currentRowY < this.crumbleStop) {
                    boolean falling = false;
                    for (int i2 = 0; i2 < numOfBlocks && !this.blocksToRemove.isEmpty(); ++i2) {
                        int randomIndex = 0;
                        if (this.blocksToRemove.size() != 1) {
                            randomIndex = this.random.nextInt(this.blocksToRemove.size() - 1);
                        }
                        BlockPos removeBlock = this.blocksToRemove.get(randomIndex);
                        BlockState state = this.m_9236_().m_8055_(removeBlock);
                        if (!this.m_9236_().m_8055_(removeBlock.m_7495_()).m_60795_() && !this.m_9236_().m_8055_(removeBlock.m_7495_()).m_60713_(Blocks.f_49990_)) continue;
                        Vec3 velocity = new Vec3(0.0, 0.5, 0.0);
                        this.m_9236_().m_7731_(removeBlock, ((Block)BTBlocks.AIR_FILL.get()).m_49966_(), 2);
                        if (falling) {
                            FallingBlockEntity fallingBlock = FallingBlockEntity.m_201971_((Level)this.m_9236_(), (BlockPos)removeBlock, (BlockState)state);
                            fallingBlock.m_20331_(true);
                            fallingBlock.f_31943_ = false;
                            fallingBlock.m_20256_(velocity);
                            this.fallingBlocks.add(fallingBlock);
                            falling = false;
                        } else {
                            falling = true;
                        }
                        this.blocksToRemove.remove(randomIndex);
                    }
                }
            } else if (this.currentRowY >= this.m_9236_().m_5736_() || this.currentRowY >= this.crumbleStop) {
                for (int y = -64; y < this.m_9236_().m_5736_(); ++y) {
                    for (int x = this.m_146903_() - 16; x <= this.m_146903_() + 16; ++x) {
                        for (int z = this.m_146907_() - 16; z <= this.m_146907_() + 16; ++z) {
                            BlockPos blockToDelete = new BlockPos(x, y, z);
                            BlockState blockState = this.m_9236_().m_8055_(blockToDelete);
                            if (!(BTUtil.distanceTo2D((Entity)this, blockToDelete) < 15.5) || !blockState.m_60713_((Block)BTBlocks.AIR_FILL.get()) && !this.m_9236_().m_46801_(blockToDelete)) continue;
                            this.m_9236_().m_7731_(blockToDelete, Blocks.f_50016_.m_49966_(), 2);
                        }
                    }
                }
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(CRUMBLE_SPEED, (Object)0);
        this.f_19804_.m_135372_(CURRENT_ROW, (Object)0);
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128405_(this.crumbleSpeedName, this.getCrumbleSpeed().intValue());
        compound.m_128405_(this.currentRowName, this.getCurrentRow().intValue());
        compound.m_128359_("GolemType", this.golemType.m_7912_());
    }

    protected void m_7378_(CompoundTag compound) {
        this.setCrumbleSpeed(compound.m_128451_(this.crumbleSpeedName));
        this.setCurrentRow(compound.m_128451_(this.currentRowName) - 1);
        this.golemType = GolemType.getTypeForName(compound.m_128461_("GolemType"));
        this.setGolemDead(false);
        this.checkForGolem = true;
        this.initialized = false;
        this.currentTicks = 580;
    }

    public void setGolemDead(boolean bool) {
        this.golemDead = bool;
    }

    public void setCrumbleSpeed(int speed) {
        this.f_19804_.m_135381_(CRUMBLE_SPEED, (Object)speed);
    }

    public void setCurrentRow(int floor) {
        this.f_19804_.m_135381_(CURRENT_ROW, (Object)floor);
    }

    public Integer getCrumbleSpeed() {
        return (Integer)this.f_19804_.m_135370_(CRUMBLE_SPEED);
    }

    public Integer getCurrentRow() {
        return (Integer)this.f_19804_.m_135370_(CURRENT_ROW);
    }
}

