/*
 * Decompiled with CFR 0.152.
 */
package com.brass_amber.ba_bt.entity;

import com.brass_amber.ba_bt.BABTMain;
import com.brass_amber.ba_bt.BattleTowersConfig;
import com.brass_amber.ba_bt.entity.ExplosionPhysics;
import com.brass_amber.ba_bt.entity.hostile.golem.BTAbstractGolem;
import com.brass_amber.ba_bt.init.BTEntityType;
import com.brass_amber.ba_bt.sound.BTMusic;
import com.brass_amber.ba_bt.sound.BTSoundEvents;
import com.brass_amber.ba_bt.util.BTUtil;
import com.brass_amber.ba_bt.util.GolemType;
import com.brass_amber.ba_bt.util.TowerSpecs;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.sounds.MusicManager;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;

public class LandDestructionEntity
extends Entity {
    private static final EntityDataAccessor<BlockPos> CRUMBLE_START_CORNER = SynchedEntityData.m_135353_(LandDestructionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private static final EntityDataAccessor<Integer> CRUMBLE_BOTTOM = SynchedEntityData.m_135353_(LandDestructionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> CRUMBLE_SPEED = SynchedEntityData.m_135353_(LandDestructionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> CURRENT_ROW = SynchedEntityData.m_135353_(LandDestructionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private Boolean initialized = false;
    private TowerSpecs specs;
    private GolemType golemType;
    private List<BlockPos> blocksToRemove = new ArrayList<BlockPos>();
    private int rows;
    private int startTicks = 600;
    private int currentTicks = 0;
    private boolean golemDead = false;
    private final Random random = new Random();
    private BlockPos removeBlock;
    private boolean checkForGolem = true;
    private boolean hasPlayer;
    private final String crumbleStartName = "CrumbleStart";
    private final String crumbleBottomName = "CrumbleBottom";
    private final String crumbleSpeedName = "CrumbleSpeed";
    private final String currentRowName = "CurrentFloor";

    public LandDestructionEntity(EntityType<LandDestructionEntity> type, Level level) {
        super(type, level);
        this.startTicks = (Integer)BattleTowersConfig.landTimeBeforeCollapse.get() * 20;
    }

    public LandDestructionEntity(BlockPos golemSpawn, Level level) {
        super((EntityType)BTEntityType.LAND_DESTRUCTION.get(), level);
        this.golemType = GolemType.LAND;
        this.setCrumbleStart(golemSpawn.m_7918_(-15, 6, -15));
    }

    public void getNextRow() {
        BlockPos rowCorner = this.getCrumbleStart().m_6625_(this.getCurrentRow() * 3);
        for (int y = rowCorner.m_123342_(); y > rowCorner.m_123342_() - 3; --y) {
            for (int x = rowCorner.m_123341_() - 1; x <= rowCorner.m_123341_() + 31; ++x) {
                for (int z = rowCorner.m_123343_() - 1; z <= rowCorner.m_123343_() + 31; ++z) {
                    BlockPos blockToAdd = new BlockPos(x, y, z);
                    if (!(BTUtil.distanceTo2D((Entity)this, blockToAdd) < 15.5)) continue;
                    if (this.m_9236_().m_46801_(blockToAdd)) {
                        this.m_9236_().m_7731_(blockToAdd, Blocks.f_50016_.m_49966_(), 3);
                        continue;
                    }
                    if (this.m_9236_().m_8055_(blockToAdd).m_60795_()) continue;
                    this.blocksToRemove.add(blockToAdd);
                }
            }
        }
        this.setCurrentRow(this.getCurrentRow() + 1);
    }

    private void init() {
        BABTMain.LOGGER.debug("Initializing");
        this.specs = TowerSpecs.getTowerFromGolem(this.golemType);
        this.setCrumbleSpeed(this.specs.getCrumbleSpeed());
        this.setCrumbleBottom(this.getCrumbleStart().m_123342_() - (int)Math.round((double)this.specs.getHeight() * (Double)BattleTowersConfig.landTowerCrumblePercent.get()));
        this.rows = (int)Math.floor((float)(this.getCrumbleStart().m_123342_() - this.getCrumbleBottom()) / 3.0f);
        this.initialized = true;
    }

    public void m_8119_() {
        boolean alivePlayer;
        super.m_8119_();
        if (this.checkForGolem) {
            List entities = this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82377_(50.0, 100.0, 50.0));
            boolean deadGolem = true;
            for (Entity entity : entities) {
                try {
                    BTAbstractGolem golem = (BTAbstractGolem)entity;
                    deadGolem = false;
                }
                catch (Exception golem) {}
            }
            if (deadGolem) {
                this.setGolemDead(true);
            } else {
                this.setGolemDead(false);
                this.currentTicks = 0;
            }
        }
        this.hasPlayer = (alivePlayer = this.m_9236_().m_45914_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 100.0)) ? BTUtil.distanceTo2D((Entity)this, (Entity)this.m_9236_().m_45930_((Entity)this, 100.0)) < 125.0 : false;
        if (this.golemDead && this.m_9236_().m_5776_()) {
            MusicManager music = Minecraft.m_91087_().m_91397_();
            if (this.hasPlayer) {
                if (!music.m_120187_(BTMusic.TOWER_COLLAPSE_MUSIC)) {
                    music.m_120186_();
                    music.m_120184_(BTMusic.TOWER_COLLAPSE_MUSIC);
                }
            } else {
                music.m_120186_();
            }
            return;
        }
        if (this.golemDead && this.hasPlayer) {
            ++this.currentTicks;
            if (!this.initialized.booleanValue()) {
                this.init();
            }
            if (this.currentTicks == 1) {
                BTUtil.doNoOutputCommand(this, "/title @a times 30 40 20");
                BTUtil.doNoOutputCommand(this, "/title @a title \"\"");
                BTUtil.doNoOutputCommand(this, "/title @a subtitle {\"text\":\" " + this.specs.getTitleText1() + "\",\"color\":\"" + this.specs.getColorCode() + "\"}");
                this.m_9236_().m_5594_(null, this.getCrumbleStart().m_6625_(6), (SoundEvent)BTSoundEvents.TOWER_BREAK_START.get(), SoundSource.AMBIENT, 4.0f, 1.0f);
            } else if (this.currentTicks == 400) {
                BTUtil.doNoOutputCommand(this, "/title @a title \"\"");
                BTUtil.doNoOutputCommand(this, "/title @a subtitle {\"text\":\"" + this.specs.getTitleText2() + " \",\"color\":\"#aaaaaa\"}");
                this.m_9236_().m_5594_(null, this.getCrumbleStart().m_6625_(6), (SoundEvent)BTSoundEvents.TOWER_BREAK_START.get(), SoundSource.AMBIENT, 4.0f, 1.0f);
            } else if (this.currentTicks == 500) {
                BTUtil.doNoOutputCommand(this, "/title @a title \"\"");
                BTUtil.doNoOutputCommand(this, "/title @a subtitle {\"text\":\"" + this.specs.getTitleText3() + "\",\"color\":\"#aa0000\"}");
            } else if (this.currentTicks == 600) {
                this.m_9236_().m_5594_(null, this.getCrumbleStart().m_6625_(6), (SoundEvent)BTSoundEvents.TOWER_BREAK_CRUMBLE.get(), SoundSource.AMBIENT, 4.0f, 1.0f);
            }
            if (this.currentTicks > this.startTicks && this.currentTicks % this.getCrumbleSpeed() == 0 && this.getCurrentRow() < this.rows) {
                if (this.currentTicks % 240 == 0) {
                    this.m_9236_().m_5594_(null, this.getCrumbleStart().m_6625_(this.getCurrentRow() * 3), (SoundEvent)BTSoundEvents.TOWER_BREAK_CRUMBLE.get(), SoundSource.AMBIENT, 4.0f, 1.0f);
                }
                if (this.blocksToRemove.isEmpty()) {
                    this.getNextRow();
                } else {
                    if (this.random.nextDouble() <= 0.125 && this.removeBlock != null) {
                        ExplosionPhysics explosion = new ExplosionPhysics((EntityType<? extends PrimedTnt>)((EntityType)BTEntityType.PHYSICS_EXPLOSION.get()), this.m_9236_());
                        explosion.m_6034_(this.removeBlock.m_123341_(), this.removeBlock.m_123342_(), this.removeBlock.m_123343_());
                        this.m_9236_().m_7967_((Entity)explosion);
                    }
                    for (i = 0; i < 35 && !this.blocksToRemove.isEmpty(); ++i) {
                        int randomIndex = this.blocksToRemove.size() <= 1 ? 0 : this.random.nextInt(this.blocksToRemove.size() - 1);
                        this.removeBlock = this.blocksToRemove.remove(randomIndex);
                        this.m_9236_().m_7471_(this.removeBlock, false);
                    }
                    if (this.currentTicks % 6 == 0 && !this.blocksToRemove.isEmpty()) {
                        this.m_9236_().m_142346_((Entity)this, GameEvent.f_157812_, this.removeBlock);
                        this.m_9236_().m_5594_(null, this.removeBlock, SoundEvents.f_11913_, SoundSource.BLOCKS, 2.0f, 1.0f);
                    }
                }
            } else if (this.getCurrentRow() >= this.rows) {
                int yForClear;
                BABTMain.LOGGER.debug("In Ending Sequence");
                this.getNextRow();
                for (i = 0; i < 60 && !this.blocksToRemove.isEmpty(); ++i) {
                    if (this.blocksToRemove.size() == 1) {
                        this.removeBlock = this.blocksToRemove.remove(0);
                        this.m_9236_().m_7731_(this.removeBlock, Blocks.f_50016_.m_49966_(), 2);
                        continue;
                    }
                    this.removeBlock = this.blocksToRemove.remove(this.random.nextInt(this.blocksToRemove.size() - 1));
                    if (!this.m_9236_().m_8055_(this.removeBlock).m_60819_().m_76178_()) {
                        this.m_9236_().m_7731_(this.removeBlock, Blocks.f_50016_.m_49966_(), 2);
                    }
                    this.m_9236_().m_7471_(this.removeBlock, false);
                }
                ArrayList<BlockPos> shouldBeEmptySpace = new ArrayList<BlockPos>();
                for (int y = yForClear = this.getCrumbleStart().m_123342_(); y > this.getCrumbleBottom() + 3; --y) {
                    for (int x = this.getCrumbleStart().m_123341_(); x <= this.getCrumbleStart().m_123341_() + 30; ++x) {
                        for (int z = this.getCrumbleStart().m_123343_(); z <= this.getCrumbleStart().m_123343_() + 30; ++z) {
                            BlockPos blockToAdd = new BlockPos(x, y, z);
                            if (this.m_9236_().m_8055_(blockToAdd).m_60795_() && !this.m_9236_().m_46801_(blockToAdd) || !(BTUtil.distanceTo2D((Entity)this, blockToAdd) < 14.5)) continue;
                            shouldBeEmptySpace.add(blockToAdd);
                        }
                    }
                }
                for (BlockPos clear : shouldBeEmptySpace) {
                    if (this.m_9236_().m_46801_(clear)) {
                        BTUtil.removeBodyOfWater(clear, this.m_9236_());
                        continue;
                    }
                    this.m_9236_().m_7471_(clear, false);
                }
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(CRUMBLE_START_CORNER, (Object)BlockPos.f_121853_);
        this.f_19804_.m_135372_(CRUMBLE_BOTTOM, (Object)0);
        this.f_19804_.m_135372_(CRUMBLE_SPEED, (Object)0);
        this.f_19804_.m_135372_(CURRENT_ROW, (Object)0);
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128365_(this.crumbleStartName, (Tag)BTUtil.newIntList(this.getCrumbleStart().m_123341_(), this.getCrumbleStart().m_123342_(), this.getCrumbleStart().m_123343_()));
        compound.m_128405_(this.crumbleBottomName, this.getCrumbleBottom().intValue());
        compound.m_128405_(this.crumbleSpeedName, this.getCrumbleSpeed().intValue());
        compound.m_128405_(this.currentRowName, this.getCurrentRow().intValue());
        compound.m_128359_("GolemType", this.golemType.m_7912_());
    }

    protected void m_7378_(CompoundTag compound) {
        ListTag startPos = compound.m_128437_(this.crumbleStartName, 6);
        int x = startPos.m_128763_(0);
        int y = startPos.m_128763_(1);
        int z = startPos.m_128763_(2);
        this.setCrumbleStart(new BlockPos(x, y, z));
        this.setCrumbleBottom(compound.m_128451_(this.crumbleBottomName));
        this.setCrumbleSpeed(compound.m_128451_(this.crumbleSpeedName));
        this.setCurrentRow(compound.m_128451_(this.currentRowName) - 1);
        this.golemType = GolemType.getTypeForName(compound.m_128461_("GolemType"));
        this.setGolemDead(false);
        this.checkForGolem = true;
        this.initialized = false;
        this.currentTicks = 580;
    }

    public void setGolemDead(boolean bool) {
        this.golemDead = bool;
    }

    public void setCrumbleStart(BlockPos startPos) {
        this.f_19804_.m_135381_(CRUMBLE_START_CORNER, (Object)startPos);
    }

    public void setCrumbleBottom(Integer bottomPos) {
        this.f_19804_.m_135381_(CRUMBLE_BOTTOM, (Object)bottomPos);
    }

    public void setCrumbleSpeed(int speed) {
        this.f_19804_.m_135381_(CRUMBLE_SPEED, (Object)speed);
    }

    public void setCurrentRow(int floor) {
        this.f_19804_.m_135381_(CURRENT_ROW, (Object)floor);
    }

    public BlockPos getCrumbleStart() {
        return (BlockPos)this.f_19804_.m_135370_(CRUMBLE_START_CORNER);
    }

    public Integer getCrumbleBottom() {
        return (Integer)this.f_19804_.m_135370_(CRUMBLE_BOTTOM);
    }

    public Integer getCrumbleSpeed() {
        return (Integer)this.f_19804_.m_135370_(CRUMBLE_SPEED);
    }

    public Integer getCurrentRow() {
        return (Integer)this.f_19804_.m_135370_(CURRENT_ROW);
    }
}

