/*
 * Decompiled with CFR 0.152.
 */
package com.brass_amber.ba_bt.datagen.recipes;

import com.brass_amber.ba_bt.datagen.recipes.BTRecipeCategory;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.CraftingRecipeBuilder;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class BTShapedRecipeBuilder
extends CraftingRecipeBuilder
implements RecipeBuilder {
    private final BTRecipeCategory category;
    private final Item result;
    private final int count;
    private final List<String> rows = Lists.newArrayList();
    private final Map<Character, Ingredient> key = Maps.newLinkedHashMap();
    private final Advancement.Builder advancement = Advancement.Builder.m_285878_();
    @Nullable
    private String group;
    private boolean showNotification = true;

    public BTShapedRecipeBuilder(BTRecipeCategory recipeCategory, ItemLike itemLike, int count) {
        this.category = recipeCategory;
        this.result = itemLike.m_5456_();
        this.count = count;
    }

    public static BTShapedRecipeBuilder shaped(BTRecipeCategory p_250853_, ItemLike p_249747_) {
        return BTShapedRecipeBuilder.shaped(p_250853_, p_249747_, 1);
    }

    public static BTShapedRecipeBuilder shaped(BTRecipeCategory p_251325_, ItemLike p_250636_, int p_249081_) {
        return new BTShapedRecipeBuilder(p_251325_, p_250636_, p_249081_);
    }

    public BTShapedRecipeBuilder define(Character p_206417_, TagKey<Item> p_206418_) {
        return this.define(p_206417_, Ingredient.m_204132_(p_206418_));
    }

    public BTShapedRecipeBuilder define(Character p_126128_, ItemLike p_126129_) {
        return this.define(p_126128_, Ingredient.m_43929_((ItemLike[])new ItemLike[]{p_126129_}));
    }

    public BTShapedRecipeBuilder define(Character p_126125_, Ingredient p_126126_) {
        if (this.key.containsKey(p_126125_)) {
            throw new IllegalArgumentException("Symbol '" + p_126125_ + "' is already defined!");
        }
        if (p_126125_.charValue() == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        this.key.put(p_126125_, p_126126_);
        return this;
    }

    public BTShapedRecipeBuilder pattern(String p_126131_) {
        if (!this.rows.isEmpty() && p_126131_.length() != this.rows.get(0).length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        }
        this.rows.add(p_126131_);
        return this;
    }

    public BTShapedRecipeBuilder unlockedBy(String p_126133_, CriterionTriggerInstance p_126134_) {
        this.advancement.m_138386_(p_126133_, p_126134_);
        return this;
    }

    public BTShapedRecipeBuilder group(@Nullable String p_126146_) {
        this.group = p_126146_;
        return this;
    }

    public BTShapedRecipeBuilder showNotification(boolean p_273326_) {
        this.showNotification = p_273326_;
        return this;
    }

    public Item m_142372_() {
        return this.result;
    }

    public void m_126140_(Consumer<FinishedRecipe> p_126141_, ResourceLocation p_126142_) {
        this.ensureValid(p_126142_);
        this.advancement.m_138396_(f_236353_).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)p_126142_)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)p_126142_)).m_138360_(RequirementsStrategy.f_15979_);
        p_126141_.accept((FinishedRecipe)new ShapedRecipeBuilder.Result(p_126142_, this.result, this.count, this.group == null ? "" : this.group, BTShapedRecipeBuilder.determineBookCategory(this.category), this.rows, this.key, this.advancement, p_126142_.m_246208_("recipes/" + this.category.getFolderName() + "/"), this.showNotification));
    }

    private void ensureValid(ResourceLocation p_126144_) {
        if (this.rows.isEmpty()) {
            throw new IllegalStateException("No pattern is defined for shaped recipe " + p_126144_ + "!");
        }
        HashSet set = Sets.newHashSet(this.key.keySet());
        set.remove(Character.valueOf(' '));
        for (String s : this.rows) {
            for (int i = 0; i < s.length(); ++i) {
                char c0 = s.charAt(i);
                if (!this.key.containsKey(Character.valueOf(c0)) && c0 != ' ') {
                    throw new IllegalStateException("Pattern in recipe " + p_126144_ + " uses undefined symbol '" + c0 + "'");
                }
                set.remove(Character.valueOf(c0));
            }
        }
        if (!set.isEmpty()) {
            throw new IllegalStateException("Ingredients are defined but not used in pattern for recipe " + p_126144_);
        }
        if (this.rows.size() == 1 && this.rows.get(0).length() == 1) {
            throw new IllegalStateException("Shaped recipe " + p_126144_ + " only takes in a single item - should it be a shapeless recipe instead?");
        }
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + p_126144_);
        }
    }

    static CraftingBookCategory determineBookCategory(BTRecipeCategory pCategory) {
        return switch (pCategory) {
            case BTRecipeCategory.BUILDING_BLOCKS -> CraftingBookCategory.BUILDING;
            case BTRecipeCategory.TOOLS, BTRecipeCategory.COMBAT -> CraftingBookCategory.EQUIPMENT;
            case BTRecipeCategory.REDSTONE -> CraftingBookCategory.REDSTONE;
            default -> CraftingBookCategory.MISC;
        };
    }
}

