/*
 * Decompiled with CFR 0.152.
 */
package com.brass_amber.ba_bt.client.renderer.golem;

import com.brass_amber.ba_bt.BABTMain;
import com.brass_amber.ba_bt.entity.hostile.golem.BTAbstractGolem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractBTGolemRenderer<E extends BTAbstractGolem, M extends EntityModel<E>>
extends MobRenderer<E, M> {
    private static final float SCALE = 0.9f;
    protected ResourceLocation golemTexturesDormant;
    protected ResourceLocation golemTexturesAwaken;
    protected ResourceLocation golemTexturesEnraged;
    private String golemType;

    public AbstractBTGolemRenderer(EntityRendererProvider.Context context, M model, String golemType) {
        super(context, model, 0.45f);
        this.golemType = golemType;
    }

    protected void scale(E entitylivingbaseIn, PoseStack poseStack, float partialTickTime) {
        poseStack.m_85841_(0.9f, 0.9f, 0.9f);
    }

    public ResourceLocation getTextureLocation(BTAbstractGolem entity) {
        return entity.isEnraged() ? this.golemTexturesEnraged : (entity.isAwake() ? this.golemTexturesAwaken : this.golemTexturesDormant);
    }

    protected void setGolemTextures(String dormant, String awake, String special) {
        this.golemTexturesDormant = this.setGolemTexture(dormant);
        this.golemTexturesAwaken = this.setGolemTexture(awake);
        this.golemTexturesEnraged = this.setGolemTexture(special);
    }

    protected ResourceLocation setGolemTexture(String textureName) {
        return BABTMain.locate("textures/entity/golem/" + this.golemType + "/" + textureName + ".png");
    }
}

