/*
 * Decompiled with CFR 0.152.
 */
package com.brass_amber.ba_bt.client.renderer.chest;

import com.brass_amber.ba_bt.BABTMain;
import com.brass_amber.ba_bt.block.blockentity.BTChestBlockEntity;
import com.brass_amber.ba_bt.util.GolemType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.ChestRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BTChestRenderer
extends ChestRenderer<BTChestBlockEntity> {
    public static Material[] single = new Material[GolemType.VALUES.length];
    public static Material[] left = new Material[GolemType.VALUES.length];
    public static Material[] right = new Material[GolemType.VALUES.length];
    public static Material[] singleGolem = new Material[GolemType.VALUES.length];
    public static Material[] leftGolem = new Material[GolemType.VALUES.length];
    public static Material[] rightGolem = new Material[GolemType.VALUES.length];

    public BTChestRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected Material getMaterial(BTChestBlockEntity chestBlockEntity, ChestType chestType) {
        return BTChestRenderer.getChestMaterial(chestBlockEntity, chestType);
    }

    private static Material getChestMaterial(String name, String type, boolean isGolem) {
        if (isGolem) {
            return new Material(Sheets.f_110740_, BABTMain.locate("entity/chest/" + name + "_golem_chest" + type));
        }
        return new Material(Sheets.f_110740_, BABTMain.locate("entity/chest/" + name + "_chest" + type));
    }

    private static Material getChestMaterial(BTChestBlockEntity chestBlockEntity, ChestType type) {
        if (chestBlockEntity.isGolemChest()) {
            return switch (type) {
                case ChestType.LEFT -> leftGolem[chestBlockEntity.getChestType().ordinal()];
                case ChestType.RIGHT -> rightGolem[chestBlockEntity.getChestType().ordinal()];
                default -> singleGolem[chestBlockEntity.getChestType().ordinal()];
            };
        }
        return switch (type) {
            case ChestType.LEFT -> left[chestBlockEntity.getChestType().ordinal()];
            case ChestType.RIGHT -> right[chestBlockEntity.getChestType().ordinal()];
            default -> single[chestBlockEntity.getChestType().ordinal()];
        };
    }

    static {
        for (GolemType type : GolemType.VALUES) {
            BTChestRenderer.single[type.ordinal()] = BTChestRenderer.getChestMaterial(type.name().toLowerCase(), "", false);
            BTChestRenderer.left[type.ordinal()] = BTChestRenderer.getChestMaterial(type.name().toLowerCase(), "_left", false);
            BTChestRenderer.right[type.ordinal()] = BTChestRenderer.getChestMaterial(type.name().toLowerCase(), "_right", false);
            BTChestRenderer.singleGolem[type.ordinal()] = BTChestRenderer.getChestMaterial(type.name().toLowerCase(), "", true);
            BTChestRenderer.leftGolem[type.ordinal()] = BTChestRenderer.getChestMaterial(type.name().toLowerCase(), "_left", true);
            BTChestRenderer.rightGolem[type.ordinal()] = BTChestRenderer.getChestMaterial(type.name().toLowerCase(), "_right", true);
        }
    }
}

