/*
 * Decompiled with CFR 0.152.
 */
package com.brass_amber.ba_bt.client.model.hostile;

import com.brass_amber.ba_bt.entity.hostile.golem.BTAbstractGolem;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LandGolemModel
extends HumanoidModel<BTAbstractGolem> {
    public static ModelLayerLocation LAYER_LOCATION;
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart hat;
    private final ModelPart rightArm;
    private final ModelPart leftArm;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;
    public HumanoidModel.ArmPose leftArmPose = HumanoidModel.ArmPose.EMPTY;
    public HumanoidModel.ArmPose rightArmPose = HumanoidModel.ArmPose.EMPTY;
    public float swimAmount;

    public LandGolemModel(ModelPart root, ModelLayerLocation location) {
        super(root);
        LAYER_LOCATION = location;
        this.head = root.m_171324_("head");
        this.body = root.m_171324_("body");
        this.hat = root.m_171324_("hat");
        this.rightArm = root.m_171324_("right_arm");
        this.leftArm = root.m_171324_("left_arm");
        this.rightLeg = root.m_171324_("right_leg");
        this.leftLeg = root.m_171324_("left_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-8.0f, -8.0f, -8.0f, 16.0f, 16.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-32.0f, (float)0.0f));
        PartDefinition hat = partdefinition.m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(128, 64).m_171488_(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(32, 32).m_171488_(-8.0f, 0.0f, -4.0f, 16.0f, 24.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-24.0f, (float)0.0f));
        PartDefinition rightArm = partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(16, 71).m_171488_(-6.0f, -4.0f, -4.0f, 8.0f, 24.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-10.0f, (float)-20.0f, (float)0.0f));
        PartDefinition leftArm = partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(80, 32).m_171488_(-2.0f, -4.0f, -4.0f, 8.0f, 24.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)10.0f, (float)-20.0f, (float)0.0f));
        PartDefinition rightLeg = partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171488_(-4.2f, 0.0f, -4.0f, 8.0f, 24.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.8f, (float)0.0f, (float)0.0f));
        PartDefinition leftLeg = partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(37, 32).m_171488_(-3.8f, 0.0f, -4.0f, 8.0f, 24.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.8f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(BTAbstractGolem entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean isTwoHanded;
        boolean isFalling = entity.m_21256_() > 4;
        boolean isSwimming = entity.m_6067_();
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = isFalling ? -0.7853982f : (this.swimAmount > 0.0f ? (isSwimming ? this.m_102835_(this.swimAmount, this.head.f_104203_, -0.7853982f) : this.m_102835_(this.swimAmount, this.head.f_104203_, headPitch * ((float)Math.PI / 180))) : headPitch * ((float)Math.PI / 180));
        this.body.f_104204_ = 0.0f;
        this.rightArm.f_104202_ = 0.0f;
        this.rightArm.f_104200_ = -10.0f;
        this.leftArm.f_104202_ = 0.0f;
        this.leftArm.f_104200_ = 10.0f;
        float f = 1.0f;
        if (isFalling) {
            f = (float)entity.m_20184_().m_82556_();
            f /= 0.2f;
            f = f * f * f;
        }
        if (f < 1.0f) {
            f = 1.0f;
        }
        this.rightArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f / f;
        this.leftArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f / f;
        this.rightArm.f_104205_ = 0.0f;
        this.leftArm.f_104205_ = 0.0f;
        this.rightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount / f;
        this.leftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount / f;
        this.rightLeg.f_104204_ = 0.0f;
        this.leftLeg.f_104204_ = 0.0f;
        this.rightLeg.f_104205_ = 0.0f;
        this.leftLeg.f_104205_ = 0.0f;
        this.rightArm.f_104204_ = 0.0f;
        this.leftArm.f_104204_ = 0.0f;
        boolean isRightHanded = entity.m_5737_() == HumanoidArm.RIGHT;
        boolean bl = isTwoHanded = isRightHanded ? this.leftArmPose.m_102897_() : this.rightArmPose.m_102897_();
        if (isRightHanded != isTwoHanded) {
            this.poseLeftArm(entity);
            this.poseRightArm(entity);
        } else {
            this.poseRightArm(entity);
            this.poseLeftArm(entity);
        }
        this.setupAttackAnimation(entity, ageInTicks);
        this.body.f_104203_ = 0.0f;
        this.rightLeg.f_104202_ = 0.1f;
        this.leftLeg.f_104202_ = 0.1f;
        this.rightLeg.f_104201_ = 0.0f;
        this.leftLeg.f_104201_ = 0.0f;
        this.head.f_104201_ = -32.0f;
        this.body.f_104201_ = -24.0f;
        this.leftArm.f_104201_ = -20.0f;
        this.rightArm.f_104201_ = -20.0f;
        AnimationUtils.m_102082_((ModelPart)this.rightArm, (ModelPart)this.leftArm, (float)ageInTicks);
    }

    protected void setupAttackAnimation(BTAbstractGolem entity, float ageInTicks) {
        if (!(this.f_102608_ <= 0.0f)) {
            HumanoidArm humanoidarm = this.getAttackArm(entity);
            ModelPart arm = this.m_102851_(humanoidarm);
            float f = this.f_102608_;
            this.body.f_104204_ = Mth.m_14031_((float)(Mth.m_14116_((float)f) * ((float)Math.PI * 2))) * 0.2f;
            if (humanoidarm == HumanoidArm.LEFT) {
                this.body.f_104204_ *= -1.0f;
            }
            this.rightArm.f_104202_ = Mth.m_14031_((float)this.body.f_104204_) * 10.0f;
            this.rightArm.f_104200_ = -Mth.m_14089_((float)this.body.f_104204_) * 10.0f;
            this.leftArm.f_104202_ = -Mth.m_14031_((float)this.body.f_104204_) * 10.0f;
            this.leftArm.f_104200_ = Mth.m_14089_((float)this.body.f_104204_) * 10.0f;
            this.rightArm.f_104204_ += this.body.f_104204_;
            this.leftArm.f_104204_ += this.body.f_104204_;
            this.leftArm.f_104203_ += this.body.f_104203_;
            f = 1.0f - this.f_102608_;
            f *= f;
            f *= f;
            f = 1.0f - f;
            float f1 = Mth.m_14031_((float)(f * (float)Math.PI));
            float f2 = Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI)) * -(this.head.f_104203_ - 0.7f) * 0.75f;
            arm.f_104203_ = (float)((double)arm.f_104203_ - ((double)f1 * 1.2 + (double)f2));
            arm.f_104204_ += this.body.f_104204_ * 2.0f;
            arm.f_104205_ += Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI)) * -0.4f;
        }
    }

    public void prepareMobModel(BTAbstractGolem entity, float limbSwing, float limbSwingAmount, float partialTick) {
        this.swimAmount = entity.m_20998_(partialTick);
        super.m_6839_((LivingEntity)entity, limbSwing, limbSwingAmount, partialTick);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer consumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.m_5607_().forEach(headPart -> headPart.m_104301_(poseStack, consumer, packedLight, packedOverlay));
        this.m_5608_().forEach(bodyPart -> bodyPart.m_104301_(poseStack, consumer, packedLight, packedOverlay));
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.body, (Object)this.leftArm, (Object)this.rightArm, (Object)this.leftLeg, (Object)this.rightLeg);
    }

    public void setRotationAngle(ModelPart modelPart, float x, float y, float z) {
        modelPart.f_104203_ = x;
        modelPart.f_104204_ = y;
        modelPart.f_104205_ = z;
    }

    public ModelPart m_5585_() {
        return this.head;
    }

    public void m_6002_(HumanoidArm handSide, PoseStack poseStack) {
        this.m_102851_(handSide).m_104299_(poseStack);
    }

    protected ModelPart m_102851_(HumanoidArm handSide) {
        return handSide == HumanoidArm.LEFT ? this.leftArm : this.rightArm;
    }

    protected float m_102835_(float rotateAmount, float currentRotation, float startingRotation) {
        float f = (startingRotation - currentRotation) % ((float)Math.PI * 2);
        if (f < (float)(-Math.PI)) {
            f += (float)Math.PI * 2;
        }
        if (f >= (float)Math.PI) {
            f -= (float)Math.PI * 2;
        }
        return currentRotation + rotateAmount * f;
    }

    protected HumanoidArm getAttackArm(BTAbstractGolem entity) {
        HumanoidArm handside = entity.m_5737_();
        return entity.f_20912_ == InteractionHand.MAIN_HAND ? handside : handside.m_20828_();
    }

    public void poseRightArm(BTAbstractGolem entity) {
        switch (this.rightArmPose) {
            case EMPTY: {
                this.leftArm.f_104204_ = 0.0f;
                break;
            }
            case BLOCK: {
                this.leftArm.f_104203_ = this.leftArm.f_104203_ * 0.5f - 0.9424779f;
                this.leftArm.f_104204_ = -0.5235988f;
                break;
            }
            case ITEM: {
                this.leftArm.f_104203_ = this.leftArm.f_104203_ * 0.5f - 0.31415927f;
                this.leftArm.f_104204_ = 0.0f;
                break;
            }
            case THROW_SPEAR: {
                this.leftArm.f_104203_ = this.leftArm.f_104203_ * 0.5f - (float)Math.PI;
                this.leftArm.f_104204_ = 0.0f;
                break;
            }
            case BOW_AND_ARROW: {
                this.leftArm.f_104204_ = -0.1f + this.head.f_104204_;
                this.rightArm.f_104204_ = 0.1f + this.head.f_104204_ + 0.4f;
                this.leftArm.f_104203_ = -1.5707964f + this.head.f_104203_;
                this.rightArm.f_104203_ = -1.5707964f + this.head.f_104203_;
                break;
            }
            case CROSSBOW_CHARGE: {
                AnimationUtils.m_102086_((ModelPart)this.leftArm, (ModelPart)this.rightArm, (LivingEntity)entity, (boolean)true);
                break;
            }
            case CROSSBOW_HOLD: {
                AnimationUtils.m_102097_((ModelPart)this.leftArm, (ModelPart)this.rightArm, (ModelPart)this.head, (boolean)true);
            }
        }
    }

    private void poseLeftArm(BTAbstractGolem entity) {
        switch (this.leftArmPose) {
            case EMPTY: {
                this.rightArm.f_104204_ = 0.0f;
                break;
            }
            case BLOCK: {
                this.rightArm.f_104203_ = this.rightArm.f_104203_ * 0.5f - 0.9424779f;
                this.rightArm.f_104204_ = 0.5235988f;
                break;
            }
            case ITEM: {
                this.rightArm.f_104203_ = this.rightArm.f_104203_ * 0.5f - 0.31415927f;
                this.rightArm.f_104204_ = 0.0f;
                break;
            }
            case THROW_SPEAR: {
                this.rightArm.f_104203_ = this.rightArm.f_104203_ * 0.5f - (float)Math.PI;
                this.rightArm.f_104204_ = 0.0f;
                break;
            }
            case BOW_AND_ARROW: {
                this.leftArm.f_104204_ = -0.1f + this.head.f_104204_ - 0.4f;
                this.rightArm.f_104204_ = 0.1f + this.head.f_104204_;
                this.leftArm.f_104203_ = -1.5707964f + this.head.f_104203_;
                this.rightArm.f_104203_ = -1.5707964f + this.head.f_104203_;
                break;
            }
            case CROSSBOW_CHARGE: {
                AnimationUtils.m_102086_((ModelPart)this.leftArm, (ModelPart)this.rightArm, (LivingEntity)entity, (boolean)false);
                break;
            }
            case CROSSBOW_HOLD: {
                AnimationUtils.m_102097_((ModelPart)this.leftArm, (ModelPart)this.rightArm, (ModelPart)this.head, (boolean)false);
            }
        }
    }
}

