/*
 * Decompiled with CFR 0.152.
 */
package com.brass_amber.ba_bt.block.blockentity;

import com.brass_amber.ba_bt.BABTMain;
import com.brass_amber.ba_bt.block.block.BTChestBlock;
import com.brass_amber.ba_bt.util.GolemType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;

public class BTChestBlockEntity
extends ChestBlockEntity {
    protected boolean unlocked = false;
    protected GolemType golemType;
    protected boolean golemChest;
    protected NonNullList<ItemStack> items = NonNullList.m_122780_((int)36, (Object)ItemStack.f_41583_);

    public BTChestBlockEntity(BlockPos blockPos, BlockState blockState, GolemType golemType) {
        this(GolemType.getChestForType(golemType, GolemType.isGolemChest(blockState.m_60734_())), blockPos, blockState);
    }

    public BTChestBlockEntity(BlockPos blockPos, BlockState blockState) {
        this(GolemType.getChestForType(GolemType.getTypeForChest(blockState.m_60734_()), GolemType.isGolemChest(blockState.m_60734_())), blockPos, blockState);
    }

    protected BTChestBlockEntity(BlockEntityType<? extends BTChestBlockEntity> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
        this.golemType = GolemType.getTypeForChest(blockEntityType);
        this.golemChest = GolemType.isGolemChest(blockState.m_60734_());
    }

    public int m_6643_() {
        return 36;
    }

    public GolemType getChestType() {
        return this.golemType;
    }

    protected Component m_6820_() {
        if (this.golemChest) {
            return Component.m_237115_((String)("container.ba_bt." + this.golemType.m_7912_() + "_golem_chest"));
        }
        return Component.m_237115_((String)("container.ba_bt." + this.golemType.m_7912_() + "_chest"));
    }

    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        this.unlocked = compoundTag.m_128471_("Unlocked");
    }

    protected void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        compoundTag.m_128379_("Unlocked", this.unlocked);
    }

    protected NonNullList<ItemStack> m_7086_() {
        return this.items;
    }

    protected void m_6520_(NonNullList<ItemStack> itemStack) {
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < itemStack.size(); ++i) {
            if (i >= this.items.size()) continue;
            this.m_7086_().set(i, (Object)((ItemStack)itemStack.get(i)));
        }
        this.m_6596_();
    }

    public void m_6836_(int itemStack, ItemStack stack) {
        this.m_59640_(null);
        this.items.set(itemStack, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        this.m_6596_();
    }

    protected AbstractContainerMenu m_6555_(int i, Inventory inventory) {
        return new ChestMenu(MenuType.f_39960_, i, inventory, (Container)this, 4);
    }

    public void setUnlocked(boolean tf) {
        ChestType chesttype = (ChestType)this.m_58900_().m_61143_((Property)BTChestBlock.f_51479_);
        this.unlocked = tf;
        if (chesttype != ChestType.SINGLE) {
            Direction direction = BTChestBlock.m_51584_((BlockState)this.m_58900_());
            BTChestBlockEntity chestEntity = null;
            try {
                chestEntity = (BTChestBlockEntity)this.f_58857_.m_7702_(this.m_58899_().m_121945_(direction));
            }
            catch (Exception e) {
                BABTMain.LOGGER.info(e.toString());
            }
            if (chestEntity != null) {
                chestEntity.unlocked = tf;
            }
        }
    }

    public boolean m_7525_(Player player) {
        return super.m_7525_(player) && this.canUnlock(player, this.m_5446_());
    }

    public boolean canUnlock(Player player, Component component) {
        if (this.golemChest) {
            if (!this.unlocked && !player.m_5833_()) {
                player.m_5661_((Component)Component.m_237110_((String)"container.isLocked", (Object[])new Object[]{component}), true);
                player.m_6330_(SoundEvents.f_11748_, SoundSource.BLOCKS, 1.0f, 1.0f);
                return false;
            }
            return true;
        }
        if (!this.unlocked && !player.m_5833_()) {
            player.m_5661_((Component)Component.m_237113_((String)(this.m_6820_().getString() + " is sealed. ")).m_7220_((Component)Component.m_237115_((String)"container.ba_bt.tower_chest.isLocked")), true);
            player.m_6330_(SoundEvents.f_11748_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return false;
        }
        return true;
    }

    public boolean isUnlocked() {
        return this.unlocked;
    }

    public boolean isGolemChest() {
        return this.golemChest;
    }
}

