/*
 * Decompiled with CFR 0.152.
 */
package cristelknight.wwoo.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import cristelknight.wwoo.config.configs.ReplaceBiomesConfig;
import cristelknight.wwoo.utils.Util;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.cristellib.CristelLib;
import net.cristellib.CristelLibExpectPlatform;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;

public class BiomeReplace {
    public static void replace() {
        Path path = CristelLibExpectPlatform.getResourceDirectory((String)"expanded_ecosphere", (String)"resources/ee_default/data/minecraft/dimension/overworld.json");
        if (path == null) {
            throw new RuntimeException();
        }
        JsonObject object = Util.getObjectFromPath(path);
        BiomeReplace.replaceObject(object, false);
        BiomeReplace.addDimensionFile(new ResourceLocation("minecraft", "overworld"), object);
    }

    public static void replaceObject(JsonObject object, boolean skipVanilla) {
        String b;
        JsonObject generator = (JsonObject)object.get("generator");
        JsonObject biome_source = (JsonObject)generator.get("biome_source");
        JsonArray biomes = (JsonArray)biome_source.get("biomes");
        ReplaceBiomesConfig config = (ReplaceBiomesConfig)ReplaceBiomesConfig.DEFAULT.getConfig();
        Map<String, String> replaces = config.bannedBiomes();
        if (replaces.isEmpty()) {
            return;
        }
        HashMap<String, Set<Integer>> strings = new HashMap<String, Set<Integer>>();
        for (Map.Entry<String, String> replace : replaces.entrySet()) {
            b = replace.getKey();
            if (strings.containsKey(b) || BiomeReplace.skipIfVanilla(skipVanilla, replace)) continue;
            Set<Integer> integers = BiomeReplace.getAllBiomes(biomes, b);
            strings.put(b, integers);
        }
        for (Map.Entry<String, String> replace : replaces.entrySet()) {
            b = replace.getKey();
            if (!strings.containsKey(b)) continue;
            String r = replace.getValue();
            BiomeReplace.replaceBiomes(biomes, r, (Set)strings.get(b));
        }
    }

    private static boolean skipIfVanilla(boolean skipVanilla, Map.Entry<String, String> replace) {
        if (!skipVanilla) {
            return false;
        }
        return replace.getKey().contains("minecraft:") || replace.getValue().contains("minecraft:");
    }

    public static byte[] addDimensionFile(ResourceLocation identifier, JsonObject structure) {
        return CristelLib.DATA_PACK.addDataForJsonLocation("dimension", identifier, structure);
    }

    public static Set<Integer> getAllBiomes(JsonArray biomes, String biome) {
        HashSet<Integer> integers = new HashSet<Integer>();
        for (int i = 0; i < biomes.size(); ++i) {
            String b = GsonHelper.m_13906_((JsonObject)((JsonObject)biomes.get(i)), (String)"biome");
            if (!b.equals(biome)) continue;
            integers.add(i);
        }
        return integers;
    }

    public static void replaceBiomes(JsonArray biomes, String biome, Set<Integer> integers) {
        for (int i : integers) {
            JsonObject object = (JsonObject)biomes.get(i);
            object.addProperty("biome", biome);
        }
    }
}

