/*
 * Decompiled with CFR 0.152.
 */
package net.kayn.fallen_gems_affixes.util;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import net.kayn.fallen_gems_affixes.util.EquipmentSlotWrapper;
import net.kayn.fallen_gems_affixes.util.EquipmentSlotWrappers;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class EquipmentSlotUtil {
    public static EquipmentSlotWrapper getVanillaWrapper(@NotNull EquipmentSlot slot) {
        return switch (slot) {
            case EquipmentSlot.HEAD -> EquipmentSlotWrappers.HEAD;
            case EquipmentSlot.CHEST -> EquipmentSlotWrappers.CHEST;
            case EquipmentSlot.LEGS -> EquipmentSlotWrappers.LEGS;
            case EquipmentSlot.FEET -> EquipmentSlotWrappers.FEET;
            case EquipmentSlot.OFFHAND -> EquipmentSlotWrappers.OFF_HAND;
            case EquipmentSlot.MAINHAND -> EquipmentSlotWrappers.MAIN_HAND;
            default -> null;
        };
    }

    public static EquipmentSlot slotFromAllSlotsIndex(int index) {
        return switch (index) {
            case 0 -> EquipmentSlot.MAINHAND;
            case 1 -> EquipmentSlot.OFFHAND;
            case 2 -> EquipmentSlot.FEET;
            case 3 -> EquipmentSlot.LEGS;
            case 4 -> EquipmentSlot.CHEST;
            case 5 -> EquipmentSlot.HEAD;
            default -> null;
        };
    }

    public static EquipmentSlot slotFromInventoryIndex(int index) {
        return switch (index) {
            case 40 -> EquipmentSlot.OFFHAND;
            case 39 -> EquipmentSlot.HEAD;
            case 38 -> EquipmentSlot.CHEST;
            case 37 -> EquipmentSlot.LEGS;
            case 36 -> EquipmentSlot.FEET;
            default -> null;
        };
    }

    public static boolean matchesSlot(ItemStack itemStack, EquipmentSlot givenSlot) {
        for (EquipmentSlot slot : LootCategory.forItem((ItemStack)itemStack).getSlots()) {
            if (givenSlot != slot) continue;
            return true;
        }
        return false;
    }

    public static Iterable<ItemStack> getOffHandAndArmors(Player player) {
        return Iterables.concat((Iterable)Lists.newArrayList((Object[])new ItemStack[]{player.m_21206_()}), (Iterable)player.m_6168_());
    }
}

