/*
 * Decompiled with CFR 0.152.
 */
package net.kayn.fallen_gems_affixes.event;

import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.socket.SocketHelper;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.Gem;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.GemInstance;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import net.kayn.fallen_gems_affixes.adventure.socket.gem.bonus.PermanentEffectBonus;
import net.kayn.fallen_gems_affixes.config.ModConfig;
import net.kayn.fallen_gems_affixes.util.EquipmentSlotUtil;
import net.kayn.fallen_gems_affixes.util.EquipmentSlotWrapper;
import net.kayn.fallen_gems_affixes.util.EquipmentSlotWrappers;
import net.kayn.fallen_gems_affixes.util.IPermanentEffectHandler;
import net.kayn.fallen_gems_affixes.util.ProtectedMobEffectMap;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="fallen_gems_affixes", bus=Mod.EventBusSubscriber.Bus.MOD)
public class PermanentEffectHandler
implements IPermanentEffectHandler {
    private static final PermanentEffectHandler INSTANCE = new PermanentEffectHandler();
    private static Map<UUID, ProtectedMobEffectMap<?>> tickEventProtectedMapWrapper = null;
    private static boolean useTickEvent = false;
    private static boolean configLoaded = false;
    private static final Logger LOGGER = LogManager.getLogger();

    @SubscribeEvent
    public static void onModConfigEvent(ModConfigEvent event) {
        if (configLoaded) {
            return;
        }
        useTickEvent = (Boolean)ModConfig.PERMANENT_EFFECT_USE_TICK_EVENT.get();
        if (useTickEvent) {
            if (tickEventProtectedMapWrapper == null) {
                tickEventProtectedMapWrapper = new HashMap();
            }
            MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, INSTANCE::onPlayerLogIn);
            MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, INSTANCE::onPlayerLogout);
            MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, INSTANCE::onTick);
            MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, INSTANCE::onEntityEquipmentChange);
        } else {
            MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, INSTANCE::onPlayerLogout);
            MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, INSTANCE::onEntityEquipmentChange);
        }
        configLoaded = true;
    }

    public static void createSoftProtectedMapFor(LivingEntity entity) {
        UUID uuid = entity.m_20148_();
        if (tickEventProtectedMapWrapper.get(uuid) != null) {
            return;
        }
        tickEventProtectedMapWrapper.put(uuid, new ProtectedMobEffectMap<LivingEntity>(entity));
    }

    private void onEntityEquipmentChange(LivingEquipmentChangeEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        EquipmentSlot slot = event.getSlot();
        ItemStack from = event.getFrom();
        this.onEquip((LivingEntity)player, from, slot, Operation.REMOVE);
        ItemStack to = event.getTo();
        this.onEquip((LivingEntity)player, to, slot, Operation.ADD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        ProtectedMobEffectMap<?> cached = tickEventProtectedMapWrapper.get(player.m_20148_());
        try {
            block5: for (ItemStack equipment : player.m_20158_()) {
                for (EquipmentSlot slot : LootCategory.forItem((ItemStack)equipment).getSlots()) {
                    EquipmentSlotWrapper slotWrapper = EquipmentSlotUtil.getVanillaWrapper(slot);
                    cached.initOperation(slotWrapper);
                    Set<MobEffect> effects = cached.getEffectsFromCache(slotWrapper);
                    if (effects == null) continue;
                    PermanentEffectHandler.checkGemBonus(equipment, (bonus, rarity) -> {
                        MobEffect effect = bonus.getEffect();
                        if (!player.m_21221_().containsKey(effect) && effects.contains(effect)) {
                            player.m_7292_(new MobEffectInstance(effect, -1, bonus.getAmplifier(rarity)));
                            cached.addPermanentEffect(slotWrapper, effect, bonus.getAmplifier(rarity), true);
                        }
                    });
                    continue block5;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            cached.finalizeOperation();
        }
    }

    private void onPlayerLogIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        tickEventProtectedMapWrapper.put(player.m_20148_(), new ProtectedMobEffectMap<Player>(player));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (useTickEvent) {
            tickEventProtectedMapWrapper.remove(player.m_20148_());
        } else {
            Map map = player.m_21221_();
            if (!(map instanceof ProtectedMobEffectMap)) {
                return;
            }
            ProtectedMobEffectMap map2 = (ProtectedMobEffectMap)map;
            try {
                Set<MobEffect> allPermanentEffects = PermanentEffectHandler.collectPermanentEffects((LivingEntity)player).keySet();
                map2.initOperation(EquipmentSlotWrappers.NONE, ProtectedMobEffectMap.EffectOperator.ON_HANDLER);
                allPermanentEffects.forEach(arg_0 -> ((Player)player).m_21195_(arg_0));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                map2.finalizeOperation();
            }
        }
    }

    public static boolean isUseTickEvent() {
        return useTickEvent;
    }

    public ProtectedMobEffectMap<?> getTickEventProtectedMapWrapper(LivingEntity entity) {
        return tickEventProtectedMapWrapper.get(entity.m_20148_());
    }

    public static Map<MobEffect, Integer> collectPermanentEffects(LivingEntity entity) {
        HashMap<MobEffect, Integer> mobEffects = new HashMap<MobEffect, Integer>();
        int index = 0;
        block0: for (ItemStack equipment : entity.m_20158_()) {
            EquipmentSlot slot1;
            if ((slot1 = EquipmentSlotUtil.slotFromAllSlotsIndex(index++)) == null) continue;
            for (EquipmentSlot slot : LootCategory.forItem((ItemStack)equipment).getSlots()) {
                if (slot1 != slot) continue;
                PermanentEffectHandler.checkGemBonus(equipment, (bonus, rarity) -> mobEffects.put(bonus.getEffect(), bonus.getAmplifier(rarity)));
                continue block0;
            }
        }
        return mobEffects;
    }

    public static void checkGemBonus(ItemStack itemStack, BonusProcessor processor) {
        if (itemStack.m_41619_()) {
            return;
        }
        LootCategory cat = LootCategory.forItem((ItemStack)itemStack);
        for (GemInstance g : SocketHelper.getGems((ItemStack)itemStack)) {
            DynamicHolder rarityHolder;
            if (!g.isValid() || !(rarityHolder = g.rarity()).isBound()) continue;
            LootRarity rarity = (LootRarity)rarityHolder.get();
            Gem gem = (Gem)g.gem().get();
            gem.getBonus(cat, rarity).filter(b -> b instanceof PermanentEffectBonus).map(b -> (PermanentEffectBonus)((Object)b)).ifPresent(bonus -> processor.accept((PermanentEffectBonus)((Object)bonus), rarity));
        }
    }

    public static boolean matches(ItemStack itemStack, MobEffect effect) {
        AtomicBoolean result = new AtomicBoolean(false);
        PermanentEffectHandler.checkGemBonus(itemStack, (bonus, rarity) -> {
            if (bonus.getEffect() == effect) {
                result.set(true);
            }
        });
        return result.get();
    }

    private void onEquip(LivingEntity entity, @NotNull ItemStack itemStack, EquipmentSlot cSlot, Operation operation) {
        for (EquipmentSlot slot : LootCategory.forItem((ItemStack)itemStack).getSlots()) {
            if (cSlot != slot) continue;
            if (useTickEvent) {
                PermanentEffectHandler.checkGemBonus(itemStack, (bonus, rarity) -> this.onEquipByTick(entity, bonus.getEffect(), EquipmentSlotUtil.getVanillaWrapper(cSlot), operation, bonus.getAmplifier(rarity)));
                return;
            }
            PermanentEffectHandler.checkGemBonus(itemStack, (bonus, rarity) -> this.onEquipDefault(entity, bonus.getEffect(), EquipmentSlotUtil.getVanillaWrapper(cSlot), operation, bonus.getAmplifier(rarity)));
            return;
        }
    }

    private void onEquipByTick(LivingEntity entity, MobEffect effect, EquipmentSlotWrapper slotWrapper, Operation operation, int amplifier) {
        ProtectedMobEffectMap<?> map = tickEventProtectedMapWrapper.get(entity.m_20148_());
        map.setOperator(ProtectedMobEffectMap.EffectOperator.ON_EQUIP);
        switch (operation) {
            case ADD: {
                MobEffectInstance inst = new MobEffectInstance(effect, -1, amplifier);
                entity.m_7292_(inst);
                map.addPermanentEffect(slotWrapper, effect, amplifier, true);
                break;
            }
            case REMOVE: {
                entity.m_21195_(effect);
                map.tryRemovePermanentEffect(slotWrapper, effect, amplifier, true);
                if (!map.containsPermanent(effect)) break;
                entity.m_7292_(map.getLastPotentialEffectInst(effect));
            }
        }
        map.setOperator(ProtectedMobEffectMap.EffectOperator.EXTERNAL);
    }

    private void onEquipDefault(LivingEntity entity, MobEffect effect, EquipmentSlotWrapper slotWrapper, Operation operation, int amplifier) {
        Map map = entity.m_21221_();
        if (!(map instanceof ProtectedMobEffectMap)) {
            return;
        }
        ProtectedMobEffectMap map2 = (ProtectedMobEffectMap)map;
        map2.setOperator(ProtectedMobEffectMap.EffectOperator.ON_EQUIP);
        switch (operation) {
            case ADD: {
                MobEffectInstance inst = new MobEffectInstance(effect, -1, amplifier);
                entity.m_7292_(inst);
                break;
            }
            case REMOVE: {
                entity.m_21195_(effect);
            }
        }
        map2.setOperator(ProtectedMobEffectMap.EffectOperator.EXTERNAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPermanentEffect(LivingEntity entity, EquipmentSlotWrapper slot, MobEffect effect, int amplifier, boolean altCondition) {
        Map map1 = entity.m_21221_();
        if (useTickEvent) {
            map1 = tickEventProtectedMapWrapper.get(entity.m_20148_());
        }
        if (!(map1 instanceof ProtectedMobEffectMap)) {
            return;
        }
        ProtectedMobEffectMap map = (ProtectedMobEffectMap)map1;
        try {
            map.initOperation(slot, ProtectedMobEffectMap.EffectOperator.ON_HANDLER);
            entity.m_7292_(new MobEffectInstance(effect, amplifier));
            map.addPermanentEffect(slot, effect, amplifier, altCondition);
        }
        catch (Exception e) {
            LOGGER.error("Failed to add PermanentEffect {}", (Object)effect.m_19482_());
            e.printStackTrace();
        }
        finally {
            map.finalizeOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePermanentEffect(LivingEntity entity, EquipmentSlotWrapper slot, MobEffect effect, int amplifier, boolean altCondition) {
        Map map1 = entity.m_21221_();
        if (useTickEvent) {
            map1 = tickEventProtectedMapWrapper.get(entity.m_20148_());
        }
        if (!(map1 instanceof ProtectedMobEffectMap)) {
            return;
        }
        ProtectedMobEffectMap map = (ProtectedMobEffectMap)map1;
        try {
            map.initOperation(slot, ProtectedMobEffectMap.EffectOperator.ON_HANDLER);
            entity.m_21195_(effect);
            map.tryRemovePermanentEffect(slot, effect, amplifier, altCondition);
        }
        catch (Exception e) {
            LOGGER.error("Failed to remove PermanentEffect {}", (Object)effect.m_19482_());
            e.printStackTrace();
        }
        finally {
            map.finalizeOperation();
        }
    }

    public static void onHotBarSelectedChange(Player player) {
        Map map = player.m_21221_();
        if (!(map instanceof ProtectedMobEffectMap)) {
            return;
        }
        ProtectedMobEffectMap map2 = (ProtectedMobEffectMap)map;
        ItemStack itemStack = player.m_21205_();
        PermanentEffectHandler.effectOperationBySlot(map2, player, EquipmentSlotWrappers.MAIN_HAND, itemStack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void effectOperationBySlot(ProtectedMobEffectMap<?> map, Player player, EquipmentSlotWrapper slotWrapper, ItemStack itemStack) {
        try {
            Set<MobEffect> cachedEffects = map.getEffectsFromCache(slotWrapper);
            map.initOperation(slotWrapper);
            if (cachedEffects != null) {
                for (MobEffect effect : Set.copyOf(cachedEffects)) {
                    player.m_6234_(effect);
                    if (!map.containsPermanent(effect)) continue;
                    player.m_147215_(map.getLastPotentialEffectInst(effect), null);
                }
            }
            if (EquipmentSlotUtil.matchesSlot(itemStack, slotWrapper.getSlot())) {
                PermanentEffectHandler.checkGemBonus(itemStack, (bonus, rarity) -> {
                    MobEffect effect = bonus.getEffect();
                    int amplifier = bonus.getAmplifier(rarity);
                    MobEffectInstance inst = new MobEffectInstance(effect, -1, amplifier);
                    player.m_147215_(inst, null);
                    map.setLastEffectsProvider(itemStack);
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            map.finalizeOperation();
        }
    }

    @Override
    public void setEffectPermanent(ProtectedMobEffectMap<?> map, EquipmentSlotWrapper slot, MobEffect effect, int amplifier, boolean altCondition) {
        map.addPermanentEffect(slot, effect, amplifier, altCondition);
    }

    @Override
    public void unsetEffectPermanent(ProtectedMobEffectMap<?> map, EquipmentSlotWrapper slot, MobEffect effect, int amplifier, boolean altCondition) {
        map.tryRemovePermanentEffect(slot, effect, amplifier, altCondition);
    }

    public static enum Operation {
        ADD,
        REMOVE;

    }

    @FunctionalInterface
    public static interface BonusProcessor {
        public void accept(PermanentEffectBonus var1, LootRarity var2);
    }
}

