/*
 * Decompiled with CFR 0.152.
 */
package net.kayn.fallen_gems_affixes.adventure.socket.gem.bonus;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.GemClass;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.bonus.GemBonus;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import java.util.Map;
import net.kayn.fallen_gems_affixes.adventure.affix.SpellEffectAffix;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringUtil;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

public class SpellEffectBonus
extends GemBonus {
    public static final Codec<SpellEffectBonus> CODEC = RecordCodecBuilder.create(inst -> inst.group(SpellEffectBonus.gemClass(), (App)ForgeRegistries.MOB_EFFECTS.getCodec().fieldOf("mob_effect").forGetter(a -> a.effect), (App)SpellEffectAffix.Target.CODEC.fieldOf("target").forGetter(a -> a.target), (App)LootRarity.mapCodec(EffectData.CODEC).fieldOf("values").forGetter(a -> a.values), (App)PlaceboCodecs.nullableField((Codec)Codec.BOOL, (String)"stack_on_reapply", (Object)false).forGetter(a -> a.stackOnReapply), (App)Codec.intRange((int)1, (int)255).optionalFieldOf("stacking_limit", (Object)255).forGetter(a -> a.stackingLimit)).apply((Applicative)inst, SpellEffectBonus::new));
    protected final MobEffect effect;
    public final SpellEffectAffix.Target target;
    protected final Map<LootRarity, EffectData> values;
    protected final int stackingLimit;
    protected final boolean stackOnReapply;

    public SpellEffectBonus(GemClass gemClass, MobEffect effect, SpellEffectAffix.Target target, Map<LootRarity, EffectData> values, boolean stackOnReapply, int stackingLimit) {
        super(new ResourceLocation("fallen_gems_affixes", "mob_effect"), gemClass);
        this.effect = effect;
        this.target = target;
        this.values = values;
        this.stackOnReapply = stackOnReapply;
        this.stackingLimit = stackingLimit;
    }

    public Codec<? extends GemBonus> getCodec() {
        return CODEC;
    }

    public SpellEffectBonus validate() {
        Preconditions.checkNotNull((Object)this.effect, (Object)"Null mob effect");
        Preconditions.checkNotNull((Object)((Object)this.target), (Object)"Null target");
        Preconditions.checkNotNull(this.values, (Object)"Null values map");
        return this;
    }

    public boolean supports(LootRarity rarity) {
        return this.values.containsKey(rarity);
    }

    public int getNumberOfUUIDs() {
        return 0;
    }

    public Component getSocketBonusTooltip(ItemStack gem, LootRarity rarity) {
        MobEffectInstance inst = this.values.get(rarity).build(this.effect);
        MutableComponent comp = this.target.toComponent(SpellEffectBonus.toComponent(inst)).m_130940_(ChatFormatting.YELLOW);
        int cooldown = this.getCooldown(rarity);
        if (cooldown != 0) {
            MutableComponent cd = Component.m_237110_((String)"affix.apotheosis.cooldown", (Object[])new Object[]{StringUtil.m_14404_((int)cooldown)});
            comp = comp.m_130946_(" ").m_7220_((Component)cd);
        }
        if (this.stackOnReapply) {
            comp = comp.m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"affix.apotheosis.stacking"));
        }
        return comp;
    }

    public void applyEffect(ItemStack gemStack, LivingEntity target, LootRarity rarity) {
        int cooldown = this.getCooldown(rarity);
        if (cooldown == 0 || !Affix.isOnCooldown((ResourceLocation)this.getCooldownId(gemStack), (int)cooldown, (LivingEntity)target)) {
            EffectData data = this.values.get(rarity);
            MobEffectInstance inst = target.m_21124_(this.effect);
            if (this.stackOnReapply && inst != null) {
                if (inst != null) {
                    int amplifier = Math.min(this.stackingLimit, inst.m_19564_() + 1 + data.amplifier);
                    MobEffectInstance newInst = new MobEffectInstance(this.effect, Math.max(inst.m_19557_(), data.duration), amplifier);
                    target.m_7292_(newInst);
                }
            } else {
                target.m_7292_(data.build(this.effect));
            }
            Affix.startCooldown((ResourceLocation)this.getCooldownId(gemStack), (LivingEntity)target);
        }
    }

    protected int getCooldown(LootRarity rarity) {
        EffectData data = this.values.get(rarity);
        return data.cooldown;
    }

    public static Component toComponent(MobEffectInstance inst) {
        MutableComponent mutablecomponent = Component.m_237115_((String)inst.m_19576_());
        MobEffect mobeffect = inst.m_19544_();
        if (inst.m_19564_() > 0) {
            mutablecomponent = Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{mutablecomponent, Component.m_237115_((String)("potion.potency." + inst.m_19564_()))});
        }
        if (inst.m_19557_() > 20) {
            mutablecomponent = Component.m_237110_((String)"potion.withDuration", (Object[])new Object[]{mutablecomponent, MobEffectUtil.m_267641_((MobEffectInstance)inst, (float)1.0f)});
        }
        return mutablecomponent.m_130940_(mobeffect.m_19483_().m_19497_());
    }

    public record EffectData(int duration, int amplifier, int cooldown) {
        private static Codec<EffectData> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.INT.fieldOf("duration").forGetter(EffectData::duration), (App)Codec.INT.fieldOf("amplifier").forGetter(EffectData::amplifier), (App)PlaceboCodecs.nullableField((Codec)Codec.INT, (String)"cooldown", (Object)0).forGetter(EffectData::cooldown)).apply((Applicative)inst, EffectData::new));

        public MobEffectInstance build(MobEffect effect) {
            return new MobEffectInstance(effect, this.duration, this.amplifier);
        }
    }
}

