/*
 * Decompiled with CFR 0.152.
 */
package net.kayn.fallen_gems_affixes.adventure.socket.gem.bonus;

import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.socket.SocketHelper;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.Gem;
import net.kayn.fallen_gems_affixes.adventure.socket.gem.bonus.BossSlayerBonus;
import net.kayn.fallen_gems_affixes.util.BossUtil;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="fallen_gems_affixes")
public class BossSlayerHandler {
    private static final TagKey<EntityType<?>> BOSS_TAG = TagKey.m_203882_((ResourceKey)ForgeRegistries.ENTITY_TYPES.getRegistryKey(), (ResourceLocation)new ResourceLocation("fallen_gems_affixes", "boss_slayer"));

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        LivingEntity target = event.getEntity();
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)entity;
        if (!BossUtil.isBoss(target, BOSS_TAG)) {
            return;
        }
        ItemStack weapon = attacker.m_21205_();
        LootCategory category = LootCategory.forItem((ItemStack)weapon);
        SocketHelper.getGems((ItemStack)weapon).forEach(gemInstance -> {
            if (!gemInstance.isValid()) {
                return;
            }
            if (!gemInstance.rarity().isBound()) {
                return;
            }
            LootRarity rarity = (LootRarity)gemInstance.rarity().get();
            ((Gem)gemInstance.gem().get()).getBonus(category, rarity).ifPresent(bonus -> {
                BossSlayerBonus slayer;
                if (bonus instanceof BossSlayerBonus && (slayer = (BossSlayerBonus)((Object)((Object)bonus))).supports(rarity)) {
                    double mod = slayer.values.get(rarity).get(0.0f);
                    event.setAmount((float)((double)event.getAmount() * (1.0 + mod)));
                }
            });
        });
    }
}

