/*
 * Decompiled with CFR 0.152.
 */
package net.kayn.fallen_gems_affixes.adventure.socket.gem.bonus;

import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.socket.SocketHelper;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.Gem;
import net.kayn.fallen_gems_affixes.adventure.socket.gem.bonus.BossResistanceBonus;
import net.kayn.fallen_gems_affixes.util.BossUtil;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="fallen_gems_affixes")
public class BossResistanceHandler {
    private static final TagKey<EntityType<?>> BOSS_TAG = TagKey.m_203882_((ResourceKey)ForgeRegistries.ENTITY_TYPES.getRegistryKey(), (ResourceLocation)new ResourceLocation("fallen_gems_affixes", "boss_slayer"));

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        LivingEntity victim = event.getEntity();
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)entity;
        if (!BossUtil.isBoss(attacker, BOSS_TAG)) {
            return;
        }
        float[] totalReduction = new float[]{0.0f};
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack armor;
            if (slot.m_20743_() != EquipmentSlot.Type.ARMOR || (armor = victim.m_6844_(slot)).m_41619_()) continue;
            LootCategory category = LootCategory.forItem((ItemStack)armor);
            SocketHelper.getGems((ItemStack)armor).forEach(gemInstance -> {
                if (!gemInstance.isValid()) {
                    return;
                }
                if (!gemInstance.rarity().isBound()) {
                    return;
                }
                LootRarity rarity = (LootRarity)gemInstance.rarity().get();
                ((Gem)gemInstance.gem().get()).getBonus(category, rarity).ifPresent(bonus -> {
                    BossResistanceBonus resistance;
                    if (bonus instanceof BossResistanceBonus && (resistance = (BossResistanceBonus)((Object)((Object)bonus))).supports(rarity)) {
                        double reduction = resistance.values.get(rarity).get(0.0f);
                        totalReduction[0] = totalReduction[0] + (float)reduction;
                    }
                });
            });
        }
        if (totalReduction[0] > 0.0f) {
            totalReduction[0] = Math.min(totalReduction[0], 0.8f);
            event.setAmount(event.getAmount() * (1.0f - totalReduction[0]));
        }
    }
}

