/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.world.advancements;

import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class EFNAchievements {
    public static void init() {
        MinecraftForge.EVENT_BUS.register(EFNAchievements.class);
    }

    @SubscribeEvent
    public static void onItemPickup(PlayerEvent.ItemPickupEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            EFNAchievements.checkItemAchievements(player2, event.getStack());
        }
    }

    @SubscribeEvent
    public static void onItemCrafted(PlayerEvent.ItemCraftedEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            EFNAchievements.checkItemAchievements(player2, event.getCrafting());
        }
    }

    private static void checkItemAchievements(ServerPlayer player, ItemStack stack) {
        ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
        if (itemId.m_135827_().equals("efn")) {
            String path = "efn:obtain_" + itemId.m_135815_();
            EFNAchievements.grantAdvancement(player, path, stack);
        }
    }

    private static void grantAdvancement(ServerPlayer player, String id, ItemStack stack) {
        Advancement advancement = player.f_8924_.m_129889_().m_136041_(new ResourceLocation(id));
        if (advancement != null && !player.m_8960_().m_135996_(advancement).m_8193_()) {
            player.m_8960_().m_135988_(advancement, "obtained");
        }
    }

    public static Advancement.Builder createObtainAdvancement(ItemStack icon, String id) {
        return Advancement.Builder.m_138353_().m_138396_(new ResourceLocation("minecraft:story/root")).m_138386_("obtain", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{icon.m_41720_()})).m_138354_(AdvancementRewards.Builder.m_10005_((int)10)).m_138362_(icon, (Component)Component.m_237115_((String)("advancement.efn." + id + ".title")), (Component)Component.m_237115_((String)("advancement.efn." + id + ".description")), null, FrameType.TASK, true, true, false);
    }
}

