/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.util;

import com.hm.efn.EFN;
import com.hm.efn.EFNCommonConfig;
import com.hm.efn.entity.doppelganger.DoppelgangerEntity;
import com.hm.efn.registries.EFNMobEffectRegistry;
import com.merlin204.avalon.entity.vfx.VFXEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.mehvahdjukaar.dummmmmmy.common.TargetDummyEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import yesman.epicfight.api.animation.property.AnimationEvent;
import yesman.epicfight.api.utils.HitEntityList;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public class TargetTeleportUtils {
    private static final boolean HAS_DUMMY_MOD = ModList.get().isLoaded("dummmmmmy");
    public static final AnimationEvent.Event YAMATO_TRICKER = (entitypatch, self, params) -> {
        ServerPlayer player;
        ServerPlayerPatch playerPatch;
        Entity patt1905$temp;
        if (!entitypatch.isLogicalClient() && (patt1905$temp = entitypatch.getOriginal()) instanceof ServerPlayer && (playerPatch = (ServerPlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)(player = (ServerPlayer)patt1905$temp), ServerPlayerPatch.class)) != null) {
            TargetTeleportUtils.ExecuteYamatoTricker(playerPatch);
        }
    };
    public static final AnimationEvent.Event YAMATO_CATCHER = (entitypatch, self, params) -> {
        ServerPlayer player;
        ServerPlayerPatch playerPatch;
        Entity patt2370$temp;
        if (!entitypatch.isLogicalClient() && (patt2370$temp = entitypatch.getOriginal()) instanceof ServerPlayer && (playerPatch = (ServerPlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)(player = (ServerPlayer)patt2370$temp), ServerPlayerPatch.class)) != null) {
            TargetTeleportUtils.ExecuteYamatoCatcher(playerPatch);
        }
    };

    public static void ExecuteYamatoTricker(LivingEntityPatch<?> entitypatch) {
        Entity entity;
        if (entitypatch != null && !entitypatch.isLogicalClient() && (entity = entitypatch.getOriginal()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            ServerPlayerPatch playerPatch = (ServerPlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)player, ServerPlayerPatch.class);
            if (playerPatch == null) {
                return;
            }
            ArrayList<LivingEntity> recentEntities = new ArrayList<LivingEntity>(playerPatch.getCurrentlyActuallyHitEntities());
            LivingEntity lastHurtMob = player.m_21214_();
            if (lastHurtMob != null && !recentEntities.contains(lastHurtMob)) {
                recentEntities.add(lastHurtMob);
            }
            playerPatch.getCurrentlyActuallyHitEntities().clear();
            player.m_21335_(null);
            if (recentEntities.isEmpty()) {
                return;
            }
            LivingEntity target = TargetTeleportUtils.getPriorityTarget(playerPatch, recentEntities);
            if (target == null || target.m_213877_() || target.m_9236_() != player.m_9236_()) {
                return;
            }
            double baseOffset = 1.0;
            float targetYaw = target.m_146908_();
            double radianYaw = Math.toRadians(targetYaw);
            double targetX = target.m_20185_() - Math.sin(radianYaw) * baseOffset;
            double targetZ = target.m_20189_() + Math.cos(radianYaw) * baseOffset;
            double targetY = target.m_20186_() + 0.7;
            if (TargetTeleportUtils.attemptTeleport(player, target, targetX, targetY, targetZ)) {
                TargetTeleportUtils.spawnTeleportEffects(player);
                player.m_7292_(new MobEffectInstance((MobEffect)EFNMobEffectRegistry.VERTICALSTOP.get(), 10, 1, false, false, false));
                player.m_36335_().m_41524_(Items.f_42584_, 5);
            }
        }
    }

    public static void ExecuteYamatoCatcher(LivingEntityPatch<?> entitypatch) {
        Entity entity;
        if (entitypatch != null && !entitypatch.isLogicalClient() && (entity = entitypatch.getOriginal()) instanceof ServerPlayer) {
            Vec3 catchPos;
            LivingEntity target;
            ServerPlayer player = (ServerPlayer)entity;
            ServerPlayerPatch playerPatch = (ServerPlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)player, ServerPlayerPatch.class);
            if (playerPatch == null) {
                return;
            }
            ArrayList<LivingEntity> recentEntities = new ArrayList<LivingEntity>(playerPatch.getCurrentlyActuallyHitEntities());
            LivingEntity lastHurtMob = player.m_21214_();
            if (lastHurtMob != null && !recentEntities.contains(lastHurtMob)) {
                recentEntities.add(lastHurtMob);
            }
            double catchRange = 30.0;
            float catchAngle = 180.0f;
            double knockbackResistanceThreshold = 0.45;
            ArrayList<String> blacklist = new ArrayList<String>((Collection)EFNCommonConfig.YAMATO_CATCHER_BLACKLIST.get());
            ArrayList<String> whitelist = new ArrayList<String>((Collection)EFNCommonConfig.YAMATO_CATCHER_WHITELIST.get());
            ArrayList<LivingEntity> validTargets = new ArrayList<LivingEntity>();
            Vec3 playerLook = player.m_20154_().m_82541_();
            Vec3 playerPos = player.m_20182_();
            LivingEntity epicFightTarget = playerPatch.getTarget();
            if (epicFightTarget != null && TargetTeleportUtils.isValidCatcherTarget(epicFightTarget, player, 30.0, 180.0f, playerPos, playerLook, 0.45, blacklist, whitelist)) {
                validTargets.add(epicFightTarget);
            }
            for (LivingEntity entity2 : recentEntities) {
                if (entity2 == epicFightTarget || !TargetTeleportUtils.isValidCatcherTarget(entity2, player, 30.0, 180.0f, playerPos, playerLook, 0.45, blacklist, whitelist)) continue;
                validTargets.add(entity2);
            }
            validTargets.sort((e1, e2) -> {
                if (e1 == epicFightTarget) {
                    return -1;
                }
                if (e2 == epicFightTarget) {
                    return 1;
                }
                return Double.compare(e1.m_20270_((Entity)player), e2.m_20270_((Entity)player));
            });
            if (!validTargets.isEmpty() && TargetTeleportUtils.attemptCatchEntity(player, target = (LivingEntity)validTargets.get(0), catchPos = playerPos.m_82549_(playerLook.m_82490_(1.5)).m_82520_(0.0, 1.3, 0.0))) {
                target.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 20, 0, false, false, false));
                target.m_7292_(new MobEffectInstance((MobEffect)EFNMobEffectRegistry.VERTICALSTOP.get(), 10, 0, false, false, false));
                target.m_7292_(new MobEffectInstance((MobEffect)EFNMobEffectRegistry.HORIZONTAL_STOP.get(), 10, 0, false, false, false));
                TargetTeleportUtils.spawnCatchEffects(player, target);
                player.m_36335_().m_41524_(Items.f_42584_, 5);
            }
        }
    }

    private static boolean isValidCatcherTarget(LivingEntity entity, ServerPlayer player, double catchRange, float catchAngle, Vec3 playerPos, Vec3 playerLook, double knockbackResistanceThreshold, List<String> blacklist, List<String> whitelist) {
        double knockbackResistance;
        if (entity == null || entity.m_213877_() || entity.m_9236_() != player.m_9236_()) {
            return false;
        }
        if (HAS_DUMMY_MOD && entity instanceof TargetDummyEntity) {
            return false;
        }
        if (entity instanceof DoppelgangerEntity || entity instanceof VFXEntity) {
            return false;
        }
        if ((double)entity.m_20270_((Entity)player) > catchRange) {
            return false;
        }
        if (!TargetTeleportUtils.isInFront(playerPos, playerLook, entity.m_20182_(), catchAngle)) {
            return false;
        }
        ResourceLocation entityId = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
        if (entityId != null) {
            String entityIdString = entityId.toString();
            if (blacklist.contains(entityIdString)) {
                return false;
            }
            if (whitelist.contains(entityIdString)) {
                return true;
            }
        }
        return (knockbackResistance = entity.m_21133_(Attributes.f_22278_)) < knockbackResistanceThreshold;
    }

    private static LivingEntity getPriorityTarget(ServerPlayerPatch playerPatch, List<LivingEntity> recentEntities) {
        try {
            ArrayList<LivingEntity> entityList = new ArrayList<LivingEntity>(recentEntities);
            LivingEntity epicFightTarget = playerPatch.getTarget();
            entityList.removeIf(entity -> HAS_DUMMY_MOD && entity instanceof TargetDummyEntity);
            entityList.removeIf(entity -> entity instanceof DoppelgangerEntity);
            entityList.removeIf(entity -> entity instanceof VFXEntity);
            HitEntityList hostilityList = new HitEntityList((LivingEntityPatch)playerPatch, entityList, HitEntityList.Priority.HOSTILITY);
            double hostileRange = 25.0;
            double neutralRange = 5.0;
            ArrayList<LivingEntity> ultimatePriority = new ArrayList<LivingEntity>();
            ArrayList<LivingEntity> firstPriority = new ArrayList<LivingEntity>();
            ArrayList<LivingEntity> secondPriority = new ArrayList<LivingEntity>();
            ArrayList<LivingEntity> others = new ArrayList<LivingEntity>();
            while (hostilityList.next()) {
                Mob mob;
                boolean isHostile;
                double maxRange;
                Entity entity2 = hostilityList.getEntity();
                if (!(entity2 instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity2;
                double distance = entity2.m_20270_(playerPatch.getOriginal());
                if (distance > (maxRange = (isHostile = TargetTeleportUtils.isHostileTarget(playerPatch, entity2)) ? 25.0 : 5.0)) continue;
                if (epicFightTarget != null && entity2 == epicFightTarget) {
                    Mob mob2;
                    boolean isMobTargeting;
                    boolean isRecentHit = recentEntities.contains(entity2);
                    boolean bl = isMobTargeting = entity2 instanceof Mob && (mob2 = (Mob)entity2).m_5448_() == playerPatch.getOriginal();
                    if (isRecentHit && isMobTargeting) {
                        ultimatePriority.add(livingEntity);
                        continue;
                    }
                }
                if (((ServerPlayer)playerPatch.getOriginal()).m_21188_() == entity2) {
                    firstPriority.add(livingEntity);
                    continue;
                }
                if (entity2 instanceof Mob && (mob = (Mob)entity2).m_5448_() == playerPatch.getOriginal()) {
                    firstPriority.add(livingEntity);
                    continue;
                }
                if (playerPatch.getCurrentlyActuallyHitEntities() == entity2) {
                    firstPriority.add(livingEntity);
                    continue;
                }
                if (entity2 == epicFightTarget) {
                    secondPriority.add(livingEntity);
                    continue;
                }
                others.add(livingEntity);
            }
            if (!ultimatePriority.isEmpty()) {
                return (LivingEntity)ultimatePriority.get(0);
            }
            if (!firstPriority.isEmpty()) {
                return (LivingEntity)firstPriority.get(0);
            }
            if (!secondPriority.isEmpty()) {
                return (LivingEntity)secondPriority.get(0);
            }
            return others.isEmpty() ? null : (LivingEntity)others.get(0);
        }
        catch (ClassCastException e) {
            EFN.LOGGER.warn("ClassCastException in target selection (likely llama targeting issue), using fallback: {}", (Object)e.getMessage());
            return TargetTeleportUtils.getFallbackTarget(playerPatch, recentEntities);
        }
        catch (Exception e) {
            EFN.LOGGER.error("Unexpected error in getPriorityTarget", (Throwable)e);
            return TargetTeleportUtils.getFallbackTarget(playerPatch, recentEntities);
        }
    }

    private static LivingEntity getFallbackTarget(ServerPlayerPatch playerPatch, List<LivingEntity> recentEntities) {
        try {
            recentEntities.removeIf(entity -> entity == null || entity.m_213877_() || HAS_DUMMY_MOD && entity instanceof TargetDummyEntity || entity instanceof DoppelgangerEntity || entity instanceof VFXEntity);
            if (recentEntities.isEmpty()) {
                return null;
            }
            recentEntities.sort((e1, e2) -> {
                double dist1 = e1.m_20280_(playerPatch.getOriginal());
                double dist2 = e2.m_20280_(playerPatch.getOriginal());
                return Double.compare(dist1, dist2);
            });
            return recentEntities.get(0);
        }
        catch (Exception e) {
            EFN.LOGGER.error("Error in fallback target selection", (Throwable)e);
            return null;
        }
    }

    private static boolean isHostileTarget(LivingEntityPatch<?> playerPatch, Entity entity) {
        Mob mob;
        return ((LivingEntity)playerPatch.getOriginal()).m_21188_() == entity || entity instanceof Mob && (mob = (Mob)entity).m_5448_() == playerPatch.getOriginal() || entity == playerPatch.getTarget();
    }

    private static boolean attemptTeleport(ServerPlayer player, LivingEntity target, double x, double y, double z) {
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos(x, y, z);
        for (int i = 0; i < 5; ++i) {
            boolean canPass;
            BlockState block = target.m_9236_().m_8055_((BlockPos)checkPos);
            boolean bl = canPass = block.m_60795_() || block.m_60812_((BlockGetter)target.m_9236_(), (BlockPos)checkPos).m_83281_();
            if (canPass) {
                player.m_8999_((ServerLevel)player.m_9236_(), x, y, z, player.m_146908_(), player.m_146909_());
                return true;
            }
            checkPos.m_122173_(Direction.UP);
            y += 1.0;
        }
        return false;
    }

    private static void spawnTeleportEffects(ServerPlayer player) {
        ((ServerLevel)player.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123810_, player.m_20185_(), player.m_20186_() + 0.5, player.m_20189_(), 15, 0.3, 0.3, 0.3, 0.1);
        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 0.7f, 1.2f);
    }

    private static boolean isInFront(Vec3 viewerPos, Vec3 lookVec, Vec3 targetPos, float maxAngleDeg) {
        Vec3 toTarget = targetPos.m_82546_(viewerPos).m_82541_();
        double angle = Math.toDegrees(Math.acos(lookVec.m_82526_(toTarget)));
        return angle <= (double)maxAngleDeg;
    }

    private static boolean attemptCatchEntity(ServerPlayer player, LivingEntity target, Vec3 catchPos) {
        boolean teleportSuccess;
        if (target.m_213877_() || target.m_9236_() != player.m_9236_()) {
            return false;
        }
        ServerLevel serverLevel = (ServerLevel)player.m_9236_();
        if (target instanceof ServerPlayer) {
            target.m_264318_(serverLevel, catchPos.f_82479_, catchPos.f_82480_, catchPos.f_82481_, Set.of(), target.m_146908_(), target.m_146909_());
            teleportSuccess = true;
        } else {
            target.m_6021_(catchPos.f_82479_, catchPos.f_82480_, catchPos.f_82481_);
            teleportSuccess = true;
        }
        target.m_20256_(Vec3.f_82478_);
        target.f_19864_ = true;
        target.m_6853_(true);
        return teleportSuccess;
    }

    private static void spawnCatchEffects(ServerPlayer player, LivingEntity target) {
        ServerLevel level = (ServerLevel)player.m_9236_();
        level.m_8767_((ParticleOptions)ParticleTypes.f_123760_, player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_(), 20, 0.5, 0.5, 0.5, 0.1);
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 0.7f, 1.5f);
        level.m_8767_((ParticleOptions)ParticleTypes.f_123810_, target.m_20185_(), target.m_20186_() + 0.5, target.m_20189_(), 15, 0.3, 0.3, 0.3, 0.05);
    }
}

