/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.skill.weapon_passive;

import com.hm.efn.gameasset.animations.EFNLanceAnimations;
import com.hm.efn.gameasset.combos.Meenlance;
import com.p1nero.invincible.api.skill.ComboNode;
import com.p1nero.invincible.capability.InvinciblePlayerCapabilityProvider;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.passive.PassiveSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class MeenLancePassive
extends PassiveSkill {
    private static final UUID MEEN_CHARGE_ANIMATION_LISTENER_UUID = UUID.fromString("e5f6a1b2-c3d4-11ed-a05b-0242ac114513");
    private static final UUID EVENT_UUID = UUID.fromString("e5f6a1b2-c3d4-11ed-a05b-0242ac114514");
    private final boolean isBeingRemoved = false;

    public MeenLancePassive(SkillBuilder<? extends PassiveSkill> builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.ANIMATION_BEGIN_EVENT, MEEN_CHARGE_ANIMATION_LISTENER_UUID, event -> {
            ServerPlayerPatch serverPatch;
            PlayerPatch patt1554$temp = event.getPlayerPatch();
            if (patt1554$temp instanceof ServerPlayerPatch && (serverPatch = (ServerPlayerPatch)patt1554$temp).getOriginal() instanceof ServerPlayer) {
                this.handleMeenlanceAnimation(serverPatch, event.getAnimation());
            }
        });
    }

    private void handleMeenlanceAnimation(ServerPlayerPatch playerPatch, StaticAnimation animation) {
        if (playerPatch == null || ((ServerPlayer)playerPatch.getOriginal()).m_9236_().m_5776_()) {
            return;
        }
        ServerPlayer player = (ServerPlayer)playerPatch.getOriginal();
        if (animation == EFNLanceAnimations.NF_MEEN_CHARGE1.get()) {
            this.updateComboNode(player, Meenlance.MeenExtendRoot_1);
        } else if (animation == EFNLanceAnimations.NF_MEEN_CHARGE2.get()) {
            this.updateComboNode(player, Meenlance.MeenExtendRoot_2);
        } else if (animation == EFNLanceAnimations.NF_MEEN_CHARGE3.get()) {
            this.updateComboNode(player, Meenlance.MeenExtendRoot_3);
        } else if (animation == EFNLanceAnimations.NF_MEEN_AUTO3.get()) {
            this.updateComboNode(player, Meenlance.MeenExtendRoot_4);
        }
    }

    private void updateComboNode(ServerPlayer player, ComboNode node) {
        player.getCapability(InvinciblePlayerCapabilityProvider.INVINCIBLE_PLAYER).ifPresent(inv -> inv.setCurrentNode(node));
    }

    public void onRemoved(SkillContainer container) {
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.ANIMATION_BEGIN_EVENT, MEEN_CHARGE_ANIMATION_LISTENER_UUID);
    }
}

