/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.skill.weapon_innate;

import com.google.common.collect.Lists;
import com.p1nero.invincible.skill.ComboBasicAttack;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.skill.dodge.DodgeSkill;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class ExampleInnate
extends ComboBasicAttack {
    public ExampleInnate(ComboBasicAttack.Builder builder) {
        super(builder);
    }

    public static float getParriedDamage(ServerPlayer player) {
        PlayerPatch playerPatch = (PlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)player, PlayerPatch.class);
        if (playerPatch == null) {
            return 0.0f;
        }
        float[] parriedDamage = new float[]{0.0f};
        UUID tempListenerId = UUID.randomUUID();
        playerPatch.getEventListener().addEventListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_ATTACK, tempListenerId, e -> {
            if (e.isParried()) {
                parriedDamage[0] = e.getDamage();
            }
        });
        playerPatch.getEventListener().removeListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_ATTACK, tempListenerId);
        return parriedDamage[0];
    }

    public static float getBlockedDamage(ServerPlayer player) {
        PlayerPatch playerPatch = (PlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)player, PlayerPatch.class);
        if (playerPatch == null) {
            return 0.0f;
        }
        float[] blockedDamage = new float[]{0.0f};
        UUID tempListenerId = UUID.randomUUID();
        playerPatch.getEventListener().addEventListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_ATTACK, tempListenerId, event -> {
            if (event.getResult() == AttackResult.ResultType.BLOCKED && !event.isParried()) {
                blockedDamage[0] = event.getDamage();
            }
        });
        playerPatch.getEventListener().removeListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_ATTACK, tempListenerId);
        return blockedDamage[0];
    }

    public static float getDodgedDamage(ServerPlayer player) {
        PlayerPatch playerPatch = (PlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)player, PlayerPatch.class);
        if (playerPatch == null) {
            return 0.0f;
        }
        float[] dodgedDamage = new float[]{0.0f};
        UUID tempListenerId = UUID.randomUUID();
        playerPatch.getEventListener().addEventListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_ATTACK, tempListenerId, event -> {
            if (event.getResult() == AttackResult.ResultType.MISSED && ExampleInnate.isDodgeSkillActive(playerPatch)) {
                dodgedDamage[0] = event.getDamage();
            }
        });
        playerPatch.getEventListener().removeListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_ATTACK, tempListenerId);
        return dodgedDamage[0];
    }

    private static boolean isDodgeSkillActive(PlayerPatch<?> playerPatch) {
        SkillContainer skillContainer = playerPatch.getSkill((SkillSlot)SkillSlots.DODGE);
        return skillContainer != null && skillContainer.getSkill() instanceof DodgeSkill && skillContainer.isActivated();
    }

    public List<Component> getTooltipOnItem(ItemStack itemStack, CapabilityItem cap, PlayerPatch<?> playerpatch) {
        ArrayList list = Lists.newArrayList();
        list.add(Component.m_237115_((String)"skill.efn.example.tooltip1"));
        return list;
    }
}

